/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.deposit;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.deposit.DiscountingIborFixingDepositProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.deposit.ResolvedIborFixingDepositTrade;

public class DiscountingIborFixingDepositTradePricer {
    public static final DiscountingIborFixingDepositTradePricer DEFAULT = new DiscountingIborFixingDepositTradePricer(DiscountingIborFixingDepositProductPricer.DEFAULT);
    private final DiscountingIborFixingDepositProductPricer productPricer;

    public DiscountingIborFixingDepositTradePricer(DiscountingIborFixingDepositProductPricer productPricer) {
        this.productPricer = (DiscountingIborFixingDepositProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public CurrencyAmount presentValue(ResolvedIborFixingDepositTrade trade, RatesProvider provider) {
        return this.productPricer.presentValue(trade.getProduct(), provider);
    }

    public PointSensitivities presentValueSensitivity(ResolvedIborFixingDepositTrade trade, RatesProvider provider) {
        return this.productPricer.presentValueSensitivity(trade.getProduct(), provider);
    }

    public double parRate(ResolvedIborFixingDepositTrade trade, RatesProvider provider) {
        return this.productPricer.parRate(trade.getProduct(), provider);
    }

    public PointSensitivities parRateSensitivity(ResolvedIborFixingDepositTrade trade, RatesProvider provider) {
        return this.productPricer.parRateSensitivity(trade.getProduct(), provider);
    }

    public double parSpread(ResolvedIborFixingDepositTrade trade, RatesProvider provider) {
        return this.productPricer.parSpread(trade.getProduct(), provider);
    }

    public PointSensitivities parSpreadSensitivity(ResolvedIborFixingDepositTrade trade, RatesProvider provider) {
        return this.productPricer.parSpreadSensitivity(trade.getProduct(), provider);
    }
}

