/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.deposit;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.deposit.DiscountingTermDepositProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.deposit.ResolvedTermDeposit;
import com.opengamma.strata.product.deposit.ResolvedTermDepositTrade;

public class DiscountingTermDepositTradePricer {
    public static final DiscountingTermDepositTradePricer DEFAULT = new DiscountingTermDepositTradePricer(DiscountingTermDepositProductPricer.DEFAULT);
    private final DiscountingTermDepositProductPricer productPricer;

    public DiscountingTermDepositTradePricer(DiscountingTermDepositProductPricer productPricer) {
        this.productPricer = (DiscountingTermDepositProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public CurrencyAmount presentValue(ResolvedTermDepositTrade trade, RatesProvider provider) {
        return this.productPricer.presentValue(trade.getProduct(), provider);
    }

    public PointSensitivities presentValueSensitivity(ResolvedTermDepositTrade trade, RatesProvider provider) {
        return this.productPricer.presentValueSensitivity(trade.getProduct(), provider);
    }

    public double parRate(ResolvedTermDepositTrade trade, RatesProvider provider) {
        return this.productPricer.parRate(trade.getProduct(), provider);
    }

    public PointSensitivities parRateSensitivity(ResolvedTermDepositTrade trade, RatesProvider provider) {
        return this.productPricer.parRateSensitivity(trade.getProduct(), provider);
    }

    public double parSpread(ResolvedTermDepositTrade trade, RatesProvider provider) {
        return this.productPricer.parSpread(trade.getProduct(), provider);
    }

    public PointSensitivities parSpreadSensitivity(ResolvedTermDepositTrade trade, RatesProvider provider) {
        return this.productPricer.parSpreadSensitivity(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedTermDepositTrade trade, RatesProvider provider) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, provider)});
    }

    public CurrencyAmount currentCash(ResolvedTermDepositTrade trade, RatesProvider provider) {
        ResolvedTermDeposit product = trade.getProduct();
        if (product.getStartDate().isEqual(provider.getValuationDate())) {
            return CurrencyAmount.of((Currency)product.getCurrency(), (double)(-product.getNotional()));
        }
        if (product.getEndDate().isEqual(provider.getValuationDate())) {
            return CurrencyAmount.of((Currency)product.getCurrency(), (double)(product.getNotional() + product.getInterest()));
        }
        return CurrencyAmount.zero((Currency)product.getCurrency());
    }
}

