/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.fx.DiscountingFxNdfProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxNdfTrade;

public class DiscountingFxNdfTradePricer {
    public static final DiscountingFxNdfTradePricer DEFAULT = new DiscountingFxNdfTradePricer(DiscountingFxNdfProductPricer.DEFAULT);
    private final DiscountingFxNdfProductPricer productPricer;

    public DiscountingFxNdfTradePricer(DiscountingFxNdfProductPricer productPricer) {
        this.productPricer = (DiscountingFxNdfProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public CurrencyAmount presentValue(ResolvedFxNdfTrade trade, RatesProvider provider) {
        return this.productPricer.presentValue(trade.getProduct(), provider);
    }

    public PointSensitivities presentValueSensitivity(ResolvedFxNdfTrade trade, RatesProvider provider) {
        return this.productPricer.presentValueSensitivity(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxNdfTrade trade, RatesProvider provider) {
        return this.productPricer.currencyExposure(trade.getProduct(), provider);
    }

    public CurrencyAmount currentCash(ResolvedFxNdfTrade trade, RatesProvider provider) {
        return this.productPricer.currentCash(trade.getProduct(), provider);
    }

    public FxRate forwardFxRate(ResolvedFxNdfTrade trade, RatesProvider provider) {
        return this.productPricer.forwardFxRate(trade.getProduct(), provider);
    }
}

