/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.fx.FxForwardRates;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxSingle;
import java.time.LocalDate;

public class DiscountingFxSingleProductPricer {
    public static final DiscountingFxSingleProductPricer DEFAULT = new DiscountingFxSingleProductPricer(DiscountingPaymentPricer.DEFAULT);
    private final DiscountingPaymentPricer paymentPricer;

    public DiscountingFxSingleProductPricer(DiscountingPaymentPricer paymentPricer) {
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public MultiCurrencyAmount presentValue(ResolvedFxSingle fx, RatesProvider provider) {
        if (provider.getValuationDate().isAfter(fx.getPaymentDate())) {
            return MultiCurrencyAmount.empty();
        }
        CurrencyAmount pv1 = this.paymentPricer.presentValue(fx.getBaseCurrencyPayment(), provider);
        CurrencyAmount pv2 = this.paymentPricer.presentValue(fx.getCounterCurrencyPayment(), provider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pv1, pv2});
    }

    public PointSensitivities presentValueSensitivity(ResolvedFxSingle fx, RatesProvider provider) {
        if (provider.getValuationDate().isAfter(fx.getPaymentDate())) {
            return PointSensitivities.empty();
        }
        PointSensitivityBuilder pvcs1 = this.paymentPricer.presentValueSensitivity(fx.getBaseCurrencyPayment(), provider);
        PointSensitivityBuilder pvcs2 = this.paymentPricer.presentValueSensitivity(fx.getCounterCurrencyPayment(), provider);
        return pvcs1.combinedWith(pvcs2).build();
    }

    public double parSpread(ResolvedFxSingle fx, RatesProvider provider) {
        Payment basePayment = fx.getBaseCurrencyPayment();
        Payment counterPayment = fx.getCounterCurrencyPayment();
        MultiCurrencyAmount pv = this.presentValue(fx, provider);
        double pvCounterCcy = pv.convertedTo(counterPayment.getCurrency(), (FxRateProvider)provider).getAmount();
        double dfEnd = provider.discountFactor(counterPayment.getCurrency(), fx.getPaymentDate());
        double notionalBaseCcy = basePayment.getAmount();
        return pvCounterCcy / (notionalBaseCcy * dfEnd);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSingle product, RatesProvider provider) {
        return this.presentValue(product, provider);
    }

    public MultiCurrencyAmount currentCash(ResolvedFxSingle fx, LocalDate valuationDate) {
        if (valuationDate.isEqual(fx.getPaymentDate())) {
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{fx.getBaseCurrencyPayment().getValue(), fx.getCounterCurrencyPayment().getValue()});
        }
        return MultiCurrencyAmount.empty();
    }

    public FxRate forwardFxRate(ResolvedFxSingle fx, RatesProvider provider) {
        FxForwardRates fxForwardRates = provider.fxForwardRates(fx.getCurrencyPair());
        Payment basePayment = fx.getBaseCurrencyPayment();
        Payment counterPayment = fx.getCounterCurrencyPayment();
        double forwardRate = fxForwardRates.rate(basePayment.getCurrency(), fx.getPaymentDate());
        return FxRate.of((Currency)basePayment.getCurrency(), (Currency)counterPayment.getCurrency(), (double)forwardRate);
    }

    public PointSensitivityBuilder forwardFxRatePointSensitivity(ResolvedFxSingle fx, RatesProvider provider) {
        FxForwardRates fxForwardRates = provider.fxForwardRates(fx.getCurrencyPair());
        PointSensitivityBuilder forwardFxRatePointSensitivity = fxForwardRates.ratePointSensitivity(fx.getReceiveCurrencyAmount().getCurrency(), fx.getPaymentDate());
        return forwardFxRatePointSensitivity;
    }

    public double forwardFxRateSpotSensitivity(ResolvedFxSingle fx, RatesProvider provider) {
        FxForwardRates fxForwardRates = provider.fxForwardRates(fx.getCurrencyPair());
        double forwardRateSpotSensitivity = fxForwardRates.rateFxSpotSensitivity(fx.getReceiveCurrencyAmount().getCurrency(), fx.getPaymentDate());
        return forwardRateSpotSensitivity;
    }
}

