/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.fx.DiscountingFxSingleProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxSingleTrade;

public class DiscountingFxSingleTradePricer {
    public static final DiscountingFxSingleTradePricer DEFAULT = new DiscountingFxSingleTradePricer(DiscountingFxSingleProductPricer.DEFAULT);
    private final DiscountingFxSingleProductPricer productPricer;

    public DiscountingFxSingleTradePricer(DiscountingFxSingleProductPricer productPricer) {
        this.productPricer = (DiscountingFxSingleProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public MultiCurrencyAmount presentValue(ResolvedFxSingleTrade trade, RatesProvider provider) {
        return this.productPricer.presentValue(trade.getProduct(), provider);
    }

    public PointSensitivities presentValueSensitivity(ResolvedFxSingleTrade trade, RatesProvider provider) {
        return this.productPricer.presentValueSensitivity(trade.getProduct(), provider);
    }

    public double parSpread(ResolvedFxSingleTrade trade, RatesProvider provider) {
        return this.productPricer.parSpread(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSingleTrade trade, RatesProvider provider) {
        return this.productPricer.currencyExposure(trade.getProduct(), provider);
    }

    public MultiCurrencyAmount currentCash(ResolvedFxSingleTrade trade, RatesProvider provider) {
        return this.productPricer.currentCash(trade.getProduct(), provider.getValuationDate());
    }

    public FxRate forwardFxRate(ResolvedFxSingleTrade trade, RatesProvider provider) {
        return this.productPricer.forwardFxRate(trade.getProduct(), provider);
    }

    public PointSensitivities forwardFxRatePointSensitivity(ResolvedFxSingleTrade trade, RatesProvider provider) {
        return this.productPricer.forwardFxRatePointSensitivity(trade.getProduct(), provider).build();
    }

    public double forwardFxRateSpotSensitivity(ResolvedFxSingleTrade trade, RatesProvider provider) {
        return this.productPricer.forwardFxRateSpotSensitivity(trade.getProduct(), provider);
    }
}

