/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.fx.DiscountingFxSingleProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxSwap;
import java.time.LocalDate;

public class DiscountingFxSwapProductPricer {
    public static final DiscountingFxSwapProductPricer DEFAULT = new DiscountingFxSwapProductPricer(DiscountingFxSingleProductPricer.DEFAULT);
    private final DiscountingFxSingleProductPricer fxPricer;

    public DiscountingFxSwapProductPricer(DiscountingFxSingleProductPricer fxPricer) {
        this.fxPricer = (DiscountingFxSingleProductPricer)ArgChecker.notNull((Object)fxPricer, (String)"fxPricer");
    }

    public MultiCurrencyAmount presentValue(ResolvedFxSwap swap, RatesProvider provider) {
        MultiCurrencyAmount farPv = this.fxPricer.presentValue(swap.getFarLeg(), provider);
        MultiCurrencyAmount nearPv = this.fxPricer.presentValue(swap.getNearLeg(), provider);
        return nearPv.plus(farPv);
    }

    public PointSensitivities presentValueSensitivity(ResolvedFxSwap swap, RatesProvider provider) {
        PointSensitivities nearSens = this.fxPricer.presentValueSensitivity(swap.getNearLeg(), provider);
        PointSensitivities farSens = this.fxPricer.presentValueSensitivity(swap.getFarLeg(), provider);
        return nearSens.combinedWith(farSens);
    }

    public double parSpread(ResolvedFxSwap swap, RatesProvider provider) {
        Payment counterPaymentNear = swap.getNearLeg().getCounterCurrencyPayment();
        MultiCurrencyAmount pv = this.presentValue(swap, provider);
        double pvCounterCcy = pv.convertedTo(counterPaymentNear.getCurrency(), (FxRateProvider)provider).getAmount();
        double dfEnd = provider.discountFactor(counterPaymentNear.getCurrency(), swap.getFarLeg().getPaymentDate());
        double notionalBaseCcy = swap.getNearLeg().getBaseCurrencyPayment().getAmount();
        return -pvCounterCcy / (notionalBaseCcy * dfEnd);
    }

    public PointSensitivities parSpreadSensitivity(ResolvedFxSwap swap, RatesProvider provider) {
        Payment counterPaymentNear = swap.getNearLeg().getCounterCurrencyPayment();
        MultiCurrencyAmount pv = this.presentValue(swap, provider);
        double pvCounterCcy = pv.convertedTo(counterPaymentNear.getCurrency(), (FxRateProvider)provider).getAmount();
        double dfEnd = provider.discountFactor(counterPaymentNear.getCurrency(), swap.getFarLeg().getPaymentDate());
        double notionalBaseCcy = swap.getNearLeg().getBaseCurrencyPayment().getAmount();
        double ps = -pvCounterCcy / (notionalBaseCcy * dfEnd);
        double psBar = 1.0;
        double pvCounterCcyBar = -1.0 / (notionalBaseCcy * dfEnd) * psBar;
        double dfEndBar = -ps / dfEnd * psBar;
        ZeroRateSensitivity ddfEnddr = provider.discountFactors(counterPaymentNear.getCurrency()).zeroRatePointSensitivity(swap.getFarLeg().getPaymentDate());
        PointSensitivities result = ddfEnddr.multipliedBy(dfEndBar).build();
        PointSensitivities dpvdr = this.presentValueSensitivity(swap, provider);
        PointSensitivities dpvdrConverted = dpvdr.convertedTo(counterPaymentNear.getCurrency(), (FxRateProvider)provider);
        return result.combinedWith(dpvdrConverted.multipliedBy(pvCounterCcyBar));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSwap product, RatesProvider provider) {
        return this.presentValue(product, provider);
    }

    public MultiCurrencyAmount currentCash(ResolvedFxSwap swap, LocalDate valuationDate) {
        MultiCurrencyAmount farPv = this.fxPricer.currentCash(swap.getFarLeg(), valuationDate);
        MultiCurrencyAmount nearPv = this.fxPricer.currentCash(swap.getNearLeg(), valuationDate);
        return nearPv.plus(farPv);
    }
}

