/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.fx.FxForwardRates;
import com.opengamma.strata.pricer.fx.FxIndexRates;
import com.opengamma.strata.pricer.fx.FxIndexSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ForwardFxIndexRates
implements FxIndexRates,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FxIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FxForwardRates fxForwardRates;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDateDoubleTimeSeries fixings;
    private static final long serialVersionUID = 1L;

    public static ForwardFxIndexRates of(FxIndex index, FxForwardRates fxForwardRates) {
        return ForwardFxIndexRates.of(index, fxForwardRates, LocalDateDoubleTimeSeries.empty());
    }

    public static ForwardFxIndexRates of(FxIndex index, FxForwardRates fxForwardRates, LocalDateDoubleTimeSeries fixings) {
        return new ForwardFxIndexRates(index, fxForwardRates, fixings);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.fixings = LocalDateDoubleTimeSeries.empty();
    }

    @ImmutableValidator
    private void validate() {
        if (!this.index.getCurrencyPair().equals((Object)this.fxForwardRates.getCurrencyPair())) {
            throw new IllegalArgumentException("Underlying FxForwardRates must have same currency pair");
        }
    }

    public LocalDate getValuationDate() {
        return this.fxForwardRates.getValuationDate();
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        return this.fxForwardRates.findData(name);
    }

    public int getParameterCount() {
        return this.fxForwardRates.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.fxForwardRates.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.fxForwardRates.getParameterMetadata(parameterIndex);
    }

    @Override
    public ForwardFxIndexRates withParameter(int parameterIndex, double newValue) {
        return this.withFxForwardRates(this.fxForwardRates.withParameter(parameterIndex, newValue));
    }

    @Override
    public ForwardFxIndexRates withPerturbation(ParameterPerturbation perturbation) {
        return this.withFxForwardRates(this.fxForwardRates.withPerturbation(perturbation));
    }

    @Override
    public double rate(FxIndexObservation observation, Currency baseCurrency) {
        ArgChecker.isTrue((boolean)this.index.getCurrencyPair().contains(baseCurrency), (String)"Currency {} invalid for FxIndex {}", (Object[])new Object[]{baseCurrency, this.index});
        LocalDate fixingDate = observation.getFixingDate();
        double fxIndexRate = !fixingDate.isAfter(this.getValuationDate()) ? this.historicRate(observation) : this.forwardRate(observation);
        boolean inverse = baseCurrency.equals((Object)this.index.getCurrencyPair().getCounter());
        return inverse ? 1.0 / fxIndexRate : fxIndexRate;
    }

    private double historicRate(FxIndexObservation observation) {
        LocalDate fixingDate = observation.getFixingDate();
        OptionalDouble fixedRate = this.fixings.get(fixingDate);
        if (fixedRate.isPresent()) {
            return fixedRate.getAsDouble();
        }
        if (fixingDate.isBefore(this.getValuationDate())) {
            if (this.fixings.isEmpty()) {
                throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}, no time-series supplied", (Object[])new Object[]{this.index, fixingDate}));
            }
            throw new IllegalArgumentException(Messages.format((String)"Unable to get fixing for {} on date {}", (Object[])new Object[]{this.index, fixingDate}));
        }
        return this.forwardRate(observation);
    }

    private double forwardRate(FxIndexObservation observation) {
        return this.fxForwardRates.rate(this.index.getCurrencyPair().getBase(), observation.getMaturityDate());
    }

    @Override
    public PointSensitivityBuilder ratePointSensitivity(FxIndexObservation observation, Currency baseCurrency) {
        ArgChecker.isTrue((boolean)this.index.getCurrencyPair().contains(baseCurrency), (String)"Currency {} invalid for FxIndex {}", (Object[])new Object[]{baseCurrency, this.index});
        LocalDate fixingDate = observation.getFixingDate();
        if (fixingDate.isBefore(this.getValuationDate()) || fixingDate.equals(this.getValuationDate()) && this.fixings.get(fixingDate).isPresent()) {
            return PointSensitivityBuilder.none();
        }
        return FxIndexSensitivity.of(observation, baseCurrency, 1.0);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(FxIndexSensitivity pointSensitivity) {
        return this.fxForwardRates.parameterSensitivity(pointSensitivity.toFxForwardSensitivity());
    }

    @Override
    public MultiCurrencyAmount currencyExposure(FxIndexSensitivity pointSensitivity) {
        return this.fxForwardRates.currencyExposure(pointSensitivity.toFxForwardSensitivity());
    }

    public ForwardFxIndexRates withFxForwardRates(FxForwardRates fxForwardRates) {
        return new ForwardFxIndexRates(this.index, fxForwardRates, this.fixings);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ForwardFxIndexRates(FxIndex index, FxForwardRates fxForwardRates, LocalDateDoubleTimeSeries fixings) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)fxForwardRates, (String)"fxForwardRates");
        JodaBeanUtils.notNull((Object)fixings, (String)"fixings");
        this.index = index;
        this.fxForwardRates = fxForwardRates;
        this.fixings = fixings;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public FxIndex getIndex() {
        return this.index;
    }

    @Override
    public FxForwardRates getFxForwardRates() {
        return this.fxForwardRates;
    }

    @Override
    public LocalDateDoubleTimeSeries getFixings() {
        return this.fixings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ForwardFxIndexRates other = (ForwardFxIndexRates)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.fxForwardRates, (Object)other.fxForwardRates) && JodaBeanUtils.equal((Object)this.fixings, (Object)other.fixings);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fxForwardRates);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixings);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ForwardFxIndexRates{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("fxForwardRates").append('=').append(JodaBeanUtils.toString((Object)this.fxForwardRates)).append(',').append(' ');
        buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ForwardFxIndexRates> {
        private FxIndex index;
        private FxForwardRates fxForwardRates;
        private LocalDateDoubleTimeSeries fixings;

        private Builder() {
            ForwardFxIndexRates.applyDefaults(this);
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -1002932800: {
                    return this.fxForwardRates;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (FxIndex)newValue;
                    break;
                }
                case -1002932800: {
                    this.fxForwardRates = (FxForwardRates)newValue;
                    break;
                }
                case -843784602: {
                    this.fixings = (LocalDateDoubleTimeSeries)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ForwardFxIndexRates build() {
            return new ForwardFxIndexRates(this.index, this.fxForwardRates, this.fixings);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ForwardFxIndexRates.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("fxForwardRates").append('=').append(JodaBeanUtils.toString((Object)this.fxForwardRates)).append(',').append(' ');
            buf.append("fixings").append('=').append(JodaBeanUtils.toString((Object)this.fixings));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", ForwardFxIndexRates.class, FxIndex.class);
        private final MetaProperty<FxForwardRates> fxForwardRates = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fxForwardRates", ForwardFxIndexRates.class, FxForwardRates.class);
        private final MetaProperty<LocalDateDoubleTimeSeries> fixings = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixings", ForwardFxIndexRates.class, LocalDateDoubleTimeSeries.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "fxForwardRates", "fixings"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -1002932800: {
                    return this.fxForwardRates;
                }
                case -843784602: {
                    return this.fixings;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ForwardFxIndexRates> builder() {
            return new Builder();
        }

        public Class<? extends ForwardFxIndexRates> beanType() {
            return ForwardFxIndexRates.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxIndex> index() {
            return this.index;
        }

        public MetaProperty<FxForwardRates> fxForwardRates() {
            return this.fxForwardRates;
        }

        public MetaProperty<LocalDateDoubleTimeSeries> fixings() {
            return this.fixings;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((ForwardFxIndexRates)bean).getIndex();
                }
                case -1002932800: {
                    return ((ForwardFxIndexRates)bean).getFxForwardRates();
                }
                case -843784602: {
                    return ((ForwardFxIndexRates)bean).getFixings();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

