/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FxForwardSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull")
    private final Currency referenceCurrency;
    @PropertyDefinition(validate="notNull")
    private final LocalDate referenceDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static FxForwardSensitivity of(CurrencyPair currencyPair, Currency referenceCurrency, LocalDate referenceDate, double sensitivity) {
        boolean inverse = referenceCurrency.equals((Object)currencyPair.getCounter());
        CurrencyPair pair = inverse ? currencyPair.inverse() : currencyPair;
        Currency sensitivityCurrency = pair.getCounter();
        return new FxForwardSensitivity(currencyPair, referenceCurrency, referenceDate, sensitivityCurrency, sensitivity);
    }

    public static FxForwardSensitivity of(CurrencyPair currencyPair, Currency referenceCurrency, LocalDate referenceDate, Currency sensitivityCurrency, double sensitivity) {
        return new FxForwardSensitivity(currencyPair, referenceCurrency, referenceDate, sensitivityCurrency, sensitivity);
    }

    @ImmutableValidator
    private void validate() {
        if (!this.currencyPair.contains(this.referenceCurrency)) {
            throw new IllegalArgumentException(Messages.format((String)"Reference currency {} must be one of those in the currency pair {}", (Object[])new Object[]{this.referenceCurrency, this.currencyPair}));
        }
    }

    public Currency getReferenceCounterCurrency() {
        boolean inverse = this.referenceCurrency.equals((Object)this.currencyPair.getBase());
        return inverse ? this.currencyPair.getCounter() : this.currencyPair.getBase();
    }

    public FxForwardSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new FxForwardSensitivity(this.currencyPair, this.referenceCurrency, this.referenceDate, currency, this.sensitivity);
    }

    public FxForwardSensitivity withSensitivity(double sensitivity) {
        return new FxForwardSensitivity(this.currencyPair, this.referenceCurrency, this.referenceDate, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof FxForwardSensitivity) {
            FxForwardSensitivity otherFx = (FxForwardSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.currencyPair.toString()), (Comparable)((Object)otherFx.currencyPair.toString())).compare((Comparable)this.currency, (Comparable)otherFx.currency).compare((Comparable)this.referenceCurrency, (Comparable)otherFx.referenceCurrency).compare((Comparable)this.referenceDate, (Comparable)otherFx.referenceDate).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public FxForwardSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (FxForwardSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public FxForwardSensitivity multipliedBy(double factor) {
        return new FxForwardSensitivity(this.currencyPair, this.referenceCurrency, this.referenceDate, this.currency, this.sensitivity * factor);
    }

    public FxForwardSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new FxForwardSensitivity(this.currencyPair, this.referenceCurrency, this.referenceDate, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public FxForwardSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public FxForwardSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxForwardSensitivity(CurrencyPair currencyPair, Currency referenceCurrency, LocalDate referenceDate, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        JodaBeanUtils.notNull((Object)referenceCurrency, (String)"referenceCurrency");
        JodaBeanUtils.notNull((Object)referenceDate, (String)"referenceDate");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.currencyPair = currencyPair;
        this.referenceCurrency = referenceCurrency;
        this.referenceDate = referenceDate;
        this.currency = currency;
        this.sensitivity = sensitivity;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public Currency getReferenceCurrency() {
        return this.referenceCurrency;
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxForwardSensitivity other = (FxForwardSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((Object)this.referenceCurrency, (Object)other.referenceCurrency) && JodaBeanUtils.equal((Object)this.referenceDate, (Object)other.referenceDate) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.referenceCurrency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.referenceDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("FxForwardSensitivity{");
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
        buf.append("referenceCurrency").append('=').append(JodaBeanUtils.toString((Object)this.referenceCurrency)).append(',').append(' ');
        buf.append("referenceDate").append('=').append(JodaBeanUtils.toString((Object)this.referenceDate)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxForwardSensitivity> {
        private CurrencyPair currencyPair;
        private Currency referenceCurrency;
        private LocalDate referenceDate;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case 727652476: {
                    return this.referenceCurrency;
                }
                case 1600456089: {
                    return this.referenceDate;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case 727652476: {
                    this.referenceCurrency = (Currency)newValue;
                    break;
                }
                case 1600456089: {
                    this.referenceDate = (LocalDate)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxForwardSensitivity build() {
            return new FxForwardSensitivity(this.currencyPair, this.referenceCurrency, this.referenceDate, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("FxForwardSensitivity.Builder{");
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("referenceCurrency").append('=').append(JodaBeanUtils.toString((Object)this.referenceCurrency)).append(',').append(' ');
            buf.append("referenceDate").append('=').append(JodaBeanUtils.toString((Object)this.referenceDate)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", FxForwardSensitivity.class, CurrencyPair.class);
        private final MetaProperty<Currency> referenceCurrency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"referenceCurrency", FxForwardSensitivity.class, Currency.class);
        private final MetaProperty<LocalDate> referenceDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"referenceDate", FxForwardSensitivity.class, LocalDate.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", FxForwardSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", FxForwardSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currencyPair", "referenceCurrency", "referenceDate", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case 727652476: {
                    return this.referenceCurrency;
                }
                case 1600456089: {
                    return this.referenceDate;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxForwardSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends FxForwardSensitivity> beanType() {
            return FxForwardSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<Currency> referenceCurrency() {
            return this.referenceCurrency;
        }

        public MetaProperty<LocalDate> referenceDate() {
            return this.referenceDate;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return ((FxForwardSensitivity)bean).getCurrencyPair();
                }
                case 727652476: {
                    return ((FxForwardSensitivity)bean).getReferenceCurrency();
                }
                case 1600456089: {
                    return ((FxForwardSensitivity)bean).getReferenceDate();
                }
                case 575402001: {
                    return ((FxForwardSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((FxForwardSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

