/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fx;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.fx.FxForwardSensitivity;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FxIndexSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final FxIndexObservation observation;
    @PropertyDefinition(validate="notNull")
    private final Currency referenceCurrency;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static FxIndexSensitivity of(FxIndexObservation observation, Currency referenceCurrency, double sensitivity) {
        CurrencyPair obsPair = observation.getCurrencyPair();
        boolean inverse = referenceCurrency.equals((Object)obsPair.getCounter());
        CurrencyPair queriedPair = inverse ? obsPair.inverse() : obsPair;
        Currency sensiCurrency = queriedPair.getCounter();
        return new FxIndexSensitivity(observation, referenceCurrency, sensiCurrency, sensitivity);
    }

    public static FxIndexSensitivity of(FxIndexObservation observation, Currency referenceCurrency, Currency sensitivityCurrency, double sensitivity) {
        return new FxIndexSensitivity(observation, referenceCurrency, sensitivityCurrency, sensitivity);
    }

    public FxForwardSensitivity toFxForwardSensitivity() {
        return FxForwardSensitivity.of(this.observation.getCurrencyPair(), this.referenceCurrency, this.observation.getMaturityDate(), this.currency, this.sensitivity);
    }

    public FxIndex getIndex() {
        return this.observation.getIndex();
    }

    public FxIndexSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new FxIndexSensitivity(this.observation, this.referenceCurrency, currency, this.sensitivity);
    }

    public FxIndexSensitivity withSensitivity(double sensitivity) {
        return new FxIndexSensitivity(this.observation, this.referenceCurrency, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof FxIndexSensitivity) {
            FxIndexSensitivity otherFx = (FxIndexSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.getIndex().toString()), (Comparable)((Object)otherFx.getIndex().toString())).compare((Comparable)this.currency, (Comparable)otherFx.currency).compare((Comparable)this.referenceCurrency, (Comparable)otherFx.referenceCurrency).compare((Comparable)this.observation.getFixingDate(), (Comparable)otherFx.observation.getFixingDate()).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public FxIndexSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (FxIndexSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public FxIndexSensitivity multipliedBy(double factor) {
        return new FxIndexSensitivity(this.observation, this.referenceCurrency, this.currency, this.sensitivity * factor);
    }

    public FxIndexSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new FxIndexSensitivity(this.observation, this.referenceCurrency, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public FxIndexSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public FxIndexSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxIndexSensitivity(FxIndexObservation observation, Currency referenceCurrency, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)observation, (String)"observation");
        JodaBeanUtils.notNull((Object)referenceCurrency, (String)"referenceCurrency");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.observation = observation;
        this.referenceCurrency = referenceCurrency;
        this.currency = currency;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public FxIndexObservation getObservation() {
        return this.observation;
    }

    public Currency getReferenceCurrency() {
        return this.referenceCurrency;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxIndexSensitivity other = (FxIndexSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.observation, (Object)other.observation) && JodaBeanUtils.equal((Object)this.referenceCurrency, (Object)other.referenceCurrency) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.referenceCurrency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("FxIndexSensitivity{");
        buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
        buf.append("referenceCurrency").append('=').append(JodaBeanUtils.toString((Object)this.referenceCurrency)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxIndexSensitivity> {
        private FxIndexObservation observation;
        private Currency referenceCurrency;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 727652476: {
                    return this.referenceCurrency;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    this.observation = (FxIndexObservation)newValue;
                    break;
                }
                case 727652476: {
                    this.referenceCurrency = (Currency)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxIndexSensitivity build() {
            return new FxIndexSensitivity(this.observation, this.referenceCurrency, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("FxIndexSensitivity.Builder{");
            buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
            buf.append("referenceCurrency").append('=').append(JodaBeanUtils.toString((Object)this.referenceCurrency)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxIndexObservation> observation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observation", FxIndexSensitivity.class, FxIndexObservation.class);
        private final MetaProperty<Currency> referenceCurrency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"referenceCurrency", FxIndexSensitivity.class, Currency.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", FxIndexSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", FxIndexSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"observation", "referenceCurrency", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 727652476: {
                    return this.referenceCurrency;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxIndexSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends FxIndexSensitivity> beanType() {
            return FxIndexSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxIndexObservation> observation() {
            return this.observation;
        }

        public MetaProperty<Currency> referenceCurrency() {
            return this.referenceCurrency;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return ((FxIndexSensitivity)bean).getObservation();
                }
                case 727652476: {
                    return ((FxIndexSensitivity)bean).getReferenceCurrency();
                }
                case 575402001: {
                    return ((FxIndexSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((FxIndexSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

