/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionSensitivity;
import com.opengamma.strata.pricer.impl.option.BlackBarrierPriceFormulaRepository;
import com.opengamma.strata.pricer.impl.option.BlackOneTouchAssetPriceFormulaRepository;
import com.opengamma.strata.pricer.impl.option.BlackOneTouchCashPriceFormulaRepository;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxSingle;
import com.opengamma.strata.product.fxopt.ResolvedFxSingleBarrierOption;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOption;
import com.opengamma.strata.product.option.SimpleConstantContinuousBarrier;
import java.time.LocalDate;
import java.time.ZonedDateTime;

public class BlackFxSingleBarrierOptionProductPricer {
    public static final BlackFxSingleBarrierOptionProductPricer DEFAULT = new BlackFxSingleBarrierOptionProductPricer();
    private static final BlackBarrierPriceFormulaRepository BARRIER_PRICER = new BlackBarrierPriceFormulaRepository();
    private static final BlackOneTouchAssetPriceFormulaRepository ASSET_REBATE_PRICER = new BlackOneTouchAssetPriceFormulaRepository();
    private static final BlackOneTouchCashPriceFormulaRepository CASH_REBATE_PRICER = new BlackOneTouchCashPriceFormulaRepository();

    public CurrencyAmount presentValue(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double price = this.price(option, ratesProvider, volatilities);
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        return CurrencyAmount.of((Currency)underlyingOption.getCounterCurrency(), (double)(this.signedNotional(underlyingOption) * price));
    }

    public double price(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        this.validate(option, ratesProvider, volatilities);
        SimpleConstantContinuousBarrier barrier = (SimpleConstantContinuousBarrier)option.getBarrier();
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        if (volatilities.relativeTime(underlyingOption.getExpiry()) < 0.0) {
            return 0.0;
        }
        ResolvedFxSingle underlyingFx = underlyingOption.getUnderlying();
        Currency ccyBase = underlyingFx.getBaseCurrencyPayment().getCurrency();
        Currency ccyCounter = underlyingFx.getCounterCurrencyPayment().getCurrency();
        CurrencyPair currencyPair = underlyingFx.getCurrencyPair();
        DiscountFactors baseDiscountFactors = ratesProvider.discountFactors(ccyBase);
        DiscountFactors counterDiscountFactors = ratesProvider.discountFactors(ccyCounter);
        double rateBase = baseDiscountFactors.zeroRate(underlyingFx.getPaymentDate());
        double rateCounter = counterDiscountFactors.zeroRate(underlyingFx.getPaymentDate());
        double costOfCarry = rateCounter - rateBase;
        double dfBase = baseDiscountFactors.discountFactor(underlyingFx.getPaymentDate());
        double dfCounter = counterDiscountFactors.discountFactor(underlyingFx.getPaymentDate());
        double todayFx = ratesProvider.fxRate(currencyPair);
        double strike = underlyingOption.getStrike();
        double forward = todayFx * dfBase / dfCounter;
        double volatility = volatilities.volatility(currencyPair, underlyingOption.getExpiry(), strike, forward);
        double timeToExpiry = volatilities.relativeTime(underlyingOption.getExpiry());
        double price = BARRIER_PRICER.price(todayFx, strike, timeToExpiry, costOfCarry, rateCounter, volatility, underlyingOption.getPutCall().isCall(), barrier);
        if (option.getRebate().isPresent()) {
            CurrencyAmount rebate = (CurrencyAmount)option.getRebate().get();
            double priceRebate = rebate.getCurrency().equals((Object)ccyCounter) ? CASH_REBATE_PRICER.price(todayFx, timeToExpiry, costOfCarry, rateCounter, volatility, barrier.inverseKnockType()) : ASSET_REBATE_PRICER.price(todayFx, timeToExpiry, costOfCarry, rateCounter, volatility, barrier.inverseKnockType());
            price += priceRebate * rebate.getAmount() / Math.abs(underlyingFx.getBaseCurrencyPayment().getAmount());
        }
        return price;
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyStrike(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        if (volatilities.relativeTime(underlyingOption.getExpiry()) <= 0.0) {
            return PointSensitivityBuilder.none();
        }
        ValueDerivatives priceDerivatives = this.priceDerivatives(option, ratesProvider, volatilities);
        ResolvedFxSingle underlyingFx = underlyingOption.getUnderlying();
        CurrencyPair currencyPair = underlyingFx.getCurrencyPair();
        double signedNotional = this.signedNotional(underlyingOption);
        double counterYearFraction = ratesProvider.discountFactors(currencyPair.getCounter()).relativeYearFraction(underlyingFx.getPaymentDate());
        ZeroRateSensitivity counterSensi = ZeroRateSensitivity.of(currencyPair.getCounter(), counterYearFraction, signedNotional * (priceDerivatives.getDerivative(2) + priceDerivatives.getDerivative(3)));
        double baseYearFraction = ratesProvider.discountFactors(currencyPair.getBase()).relativeYearFraction(underlyingFx.getPaymentDate());
        ZeroRateSensitivity baseSensi = ZeroRateSensitivity.of(currencyPair.getBase(), baseYearFraction, currencyPair.getCounter(), -priceDerivatives.getDerivative(3) * signedNotional);
        return counterSensi.combinedWith(baseSensi);
    }

    public CurrencyAmount presentValueDelta(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double delta = this.delta(option, ratesProvider, volatilities);
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        return CurrencyAmount.of((Currency)underlyingOption.getCounterCurrency(), (double)(this.signedNotional(underlyingOption) * delta));
    }

    public double delta(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        if (volatilities.relativeTime(option.getUnderlyingOption().getExpiry()) < 0.0) {
            return 0.0;
        }
        ValueDerivatives priceDerivatives = this.priceDerivatives(option, ratesProvider, volatilities);
        return priceDerivatives.getDerivative(0);
    }

    public CurrencyAmount presentValueGamma(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double gamma = this.gamma(option, ratesProvider, volatilities);
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        return CurrencyAmount.of((Currency)underlyingOption.getCounterCurrency(), (double)(this.signedNotional(underlyingOption) * gamma));
    }

    public double gamma(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ValueDerivatives priceDerivatives = this.priceDerivatives(option, ratesProvider, volatilities);
        return priceDerivatives.getDerivative(6);
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsVolatility(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        if (volatilities.relativeTime(underlyingOption.getExpiry()) <= 0.0) {
            return PointSensitivityBuilder.none();
        }
        ValueDerivatives priceDerivatives = this.priceDerivatives(option, ratesProvider, volatilities);
        ResolvedFxSingle underlyingFx = underlyingOption.getUnderlying();
        CurrencyPair currencyPair = underlyingFx.getCurrencyPair();
        Currency ccyBase = currencyPair.getBase();
        Currency ccyCounter = currencyPair.getCounter();
        double dfBase = ratesProvider.discountFactor(ccyBase, underlyingFx.getPaymentDate());
        double dfCounter = ratesProvider.discountFactor(ccyCounter, underlyingFx.getPaymentDate());
        double todayFx = ratesProvider.fxRate(currencyPair);
        double forward = todayFx * dfBase / dfCounter;
        return FxOptionSensitivity.of(volatilities.getName(), currencyPair, volatilities.relativeTime(underlyingOption.getExpiry()), underlyingOption.getStrike(), forward, ccyCounter, priceDerivatives.getDerivative(4) * this.signedNotional(underlyingOption));
    }

    public double vega(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ValueDerivatives priceDerivatives = this.priceDerivatives(option, ratesProvider, volatilities);
        return priceDerivatives.getDerivative(4);
    }

    public CurrencyAmount presentValueTheta(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double theta = this.theta(option, ratesProvider, volatilities);
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        return CurrencyAmount.of((Currency)underlyingOption.getCounterCurrency(), (double)(this.signedNotional(underlyingOption) * theta));
    }

    public double theta(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ValueDerivatives priceDerivatives = this.priceDerivatives(option, ratesProvider, volatilities);
        return -priceDerivatives.getDerivative(5);
    }

    public FxRate forwardFxRate(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider) {
        CurrencyPair strikePair = option.getCurrencyPair();
        LocalDate paymentDate = option.getUnderlyingOption().getUnderlying().getPaymentDate();
        double forwardRate = ratesProvider.fxForwardRates(strikePair).rate(strikePair.getBase(), paymentDate);
        return FxRate.of((CurrencyPair)strikePair, (double)forwardRate);
    }

    public double impliedVolatility(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ZonedDateTime expiry = option.getUnderlyingOption().getExpiry();
        double timeToExpiry = volatilities.relativeTime(expiry);
        if (timeToExpiry <= 0.0) {
            throw new IllegalArgumentException("valuation is after option's expiry.");
        }
        FxRate forward = this.forwardFxRate(option, ratesProvider);
        CurrencyPair strikePair = option.getCurrencyPair();
        double strike = option.getUnderlyingOption().getStrike();
        return volatilities.volatility(strikePair, expiry, strike, forward.fxRate(strikePair));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        if (volatilities.relativeTime(underlyingOption.getExpiry()) < 0.0) {
            return MultiCurrencyAmount.empty();
        }
        ValueDerivatives priceDerivatives = this.priceDerivatives(option, ratesProvider, volatilities);
        double price = priceDerivatives.getValue();
        double delta = priceDerivatives.getDerivative(0);
        CurrencyPair currencyPair = underlyingOption.getUnderlying().getCurrencyPair();
        double todayFx = ratesProvider.fxRate(currencyPair);
        double signedNotional = this.signedNotional(underlyingOption);
        CurrencyAmount domestic = CurrencyAmount.of((Currency)currencyPair.getCounter(), (double)((price - delta * todayFx) * signedNotional));
        CurrencyAmount foreign = CurrencyAmount.of((Currency)currencyPair.getBase(), (double)(delta * signedNotional));
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{domestic, foreign});
    }

    private ValueDerivatives priceDerivatives(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        this.validate(option, ratesProvider, volatilities);
        SimpleConstantContinuousBarrier barrier = (SimpleConstantContinuousBarrier)option.getBarrier();
        ResolvedFxVanillaOption underlyingOption = option.getUnderlyingOption();
        double[] derivatives = new double[7];
        if (volatilities.relativeTime(underlyingOption.getExpiry()) < 0.0) {
            return ValueDerivatives.of((double)0.0, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
        }
        ResolvedFxSingle underlyingFx = underlyingOption.getUnderlying();
        CurrencyPair currencyPair = underlyingFx.getCurrencyPair();
        Currency ccyBase = currencyPair.getBase();
        Currency ccyCounter = currencyPair.getCounter();
        DiscountFactors baseDiscountFactors = ratesProvider.discountFactors(ccyBase);
        DiscountFactors counterDiscountFactors = ratesProvider.discountFactors(ccyCounter);
        double rateBase = baseDiscountFactors.zeroRate(underlyingFx.getPaymentDate());
        double rateCounter = counterDiscountFactors.zeroRate(underlyingFx.getPaymentDate());
        double costOfCarry = rateCounter - rateBase;
        double dfBase = baseDiscountFactors.discountFactor(underlyingFx.getPaymentDate());
        double dfCounter = counterDiscountFactors.discountFactor(underlyingFx.getPaymentDate());
        double todayFx = ratesProvider.fxRate(currencyPair);
        double strike = underlyingOption.getStrike();
        double forward = todayFx * dfBase / dfCounter;
        double volatility = volatilities.volatility(currencyPair, underlyingOption.getExpiry(), strike, forward);
        double timeToExpiry = volatilities.relativeTime(underlyingOption.getExpiry());
        ValueDerivatives valueDerivatives = BARRIER_PRICER.priceAdjoint(todayFx, strike, timeToExpiry, costOfCarry, rateCounter, volatility, underlyingOption.getPutCall().isCall(), barrier);
        if (!option.getRebate().isPresent()) {
            return valueDerivatives;
        }
        CurrencyAmount rebate = (CurrencyAmount)option.getRebate().get();
        ValueDerivatives valueDerivativesRebate = rebate.getCurrency().equals((Object)ccyCounter) ? CASH_REBATE_PRICER.priceAdjoint(todayFx, timeToExpiry, costOfCarry, rateCounter, volatility, barrier.inverseKnockType()) : ASSET_REBATE_PRICER.priceAdjoint(todayFx, timeToExpiry, costOfCarry, rateCounter, volatility, barrier.inverseKnockType());
        double rebateRate = rebate.getAmount() / Math.abs(underlyingFx.getBaseCurrencyPayment().getAmount());
        double price = valueDerivatives.getValue() + rebateRate * valueDerivativesRebate.getValue();
        derivatives[0] = valueDerivatives.getDerivative(0) + rebateRate * valueDerivativesRebate.getDerivative(0);
        derivatives[1] = valueDerivatives.getDerivative(1);
        for (int i = 2; i < 7; ++i) {
            derivatives[i] = valueDerivatives.getDerivative(i) + rebateRate * valueDerivativesRebate.getDerivative(i - 1);
        }
        return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
    }

    private void validate(ResolvedFxSingleBarrierOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ArgChecker.isTrue((boolean)(option.getBarrier() instanceof SimpleConstantContinuousBarrier), (String)"Barrier should be SimpleConstantContinuousBarrier");
        ArgChecker.isTrue((boolean)ratesProvider.getValuationDate().isEqual(volatilities.getValuationDateTime().toLocalDate()), (String)"Volatility and rate data must be for the same date");
    }

    private double signedNotional(ResolvedFxVanillaOption option) {
        return (option.getLongShort().isLong() ? 1.0 : -1.0) * Math.abs(option.getUnderlying().getBaseCurrencyPayment().getAmount());
    }
}

