/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.BlackFxSingleBarrierOptionProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fxopt.ResolvedFxSingleBarrierOption;
import com.opengamma.strata.product.fxopt.ResolvedFxSingleBarrierOptionTrade;
import java.time.LocalDate;

public class BlackFxSingleBarrierOptionTradePricer {
    public static final BlackFxSingleBarrierOptionTradePricer DEFAULT = new BlackFxSingleBarrierOptionTradePricer(BlackFxSingleBarrierOptionProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final BlackFxSingleBarrierOptionProductPricer productPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public BlackFxSingleBarrierOptionTradePricer(BlackFxSingleBarrierOptionProductPricer productPricer, DiscountingPaymentPricer paymentPricer) {
        this.productPricer = (BlackFxSingleBarrierOptionProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public MultiCurrencyAmount presentValue(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxSingleBarrierOption product = trade.getProduct();
        CurrencyAmount pvProduct = this.productPricer.presentValue(product, ratesProvider, volatilities);
        Payment premium = trade.getPremium();
        CurrencyAmount pvPremium = this.paymentPricer.presentValue(premium, ratesProvider);
        return MultiCurrencyAmount.total((Iterable)ImmutableList.of((Object)pvProduct, (Object)pvPremium));
    }

    public PointSensitivities presentValueSensitivityRatesStickyStrike(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxSingleBarrierOption product = trade.getProduct();
        PointSensitivityBuilder pvcsProduct = this.productPricer.presentValueSensitivityRatesStickyStrike(product, ratesProvider, volatilities);
        Payment premium = trade.getPremium();
        PointSensitivityBuilder pvcsPremium = this.paymentPricer.presentValueSensitivity(premium, ratesProvider);
        return pvcsProduct.combinedWith(pvcsPremium).build();
    }

    public PointSensitivities presentValueSensitivityModelParamsVolatility(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxSingleBarrierOption product = trade.getProduct();
        return this.productPricer.presentValueSensitivityModelParamsVolatility(product, ratesProvider, volatilities).build();
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        Payment premium = trade.getPremium();
        CurrencyAmount pvPremium = this.paymentPricer.presentValue(premium, ratesProvider);
        ResolvedFxSingleBarrierOption product = trade.getProduct();
        return this.productPricer.currencyExposure(product, ratesProvider, volatilities).plus(pvPremium);
    }

    public CurrencyAmount currentCash(ResolvedFxSingleBarrierOptionTrade trade, LocalDate valuationDate) {
        Payment premium = trade.getPremium();
        if (premium.getDate().equals(valuationDate)) {
            return CurrencyAmount.of((Currency)premium.getCurrency(), (double)premium.getAmount());
        }
        return CurrencyAmount.of((Currency)premium.getCurrency(), (double)0.0);
    }

    public FxRate forwardFxRate(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider) {
        ResolvedFxSingleBarrierOption product = trade.getProduct();
        return this.productPricer.forwardFxRate(product, ratesProvider);
    }

    public double impliedVolatility(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxSingleBarrierOption option = trade.getProduct();
        return this.productPricer.impliedVolatility(option, ratesProvider, volatilities);
    }
}

