/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.BlackFxVanillaOptionProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOption;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOptionTrade;
import java.time.LocalDate;

public class BlackFxVanillaOptionTradePricer {
    public static final BlackFxVanillaOptionTradePricer DEFAULT = new BlackFxVanillaOptionTradePricer(BlackFxVanillaOptionProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final BlackFxVanillaOptionProductPricer productPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public BlackFxVanillaOptionTradePricer(BlackFxVanillaOptionProductPricer productPricer, DiscountingPaymentPricer paymentPricer) {
        this.productPricer = (BlackFxVanillaOptionProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public MultiCurrencyAmount presentValue(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxVanillaOption product = trade.getProduct();
        CurrencyAmount pvProduct = this.productPricer.presentValue(product, ratesProvider, volatilities);
        Payment premium = trade.getPremium();
        CurrencyAmount pvPremium = this.paymentPricer.presentValue(premium, ratesProvider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvProduct}).plus(pvPremium);
    }

    public PointSensitivities presentValueSensitivityRatesStickyStrike(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxVanillaOption product = trade.getProduct();
        PointSensitivities pvcsProduct = this.productPricer.presentValueSensitivityRatesStickyStrike(product, ratesProvider, volatilities);
        Payment premium = trade.getPremium();
        PointSensitivities pvcsPremium = this.paymentPricer.presentValueSensitivity(premium, ratesProvider).build();
        return pvcsProduct.combinedWith(pvcsPremium);
    }

    public PointSensitivities presentValueSensitivityModelParamsVolatility(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxVanillaOption product = trade.getProduct();
        return this.productPricer.presentValueSensitivityModelParamsVolatility(product, ratesProvider, volatilities).build();
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        Payment premium = trade.getPremium();
        CurrencyAmount pvPremium = this.paymentPricer.presentValue(premium, ratesProvider);
        ResolvedFxVanillaOption product = trade.getProduct();
        return this.productPricer.currencyExposure(product, ratesProvider, volatilities).plus(pvPremium);
    }

    public CurrencyAmount currentCash(ResolvedFxVanillaOptionTrade trade, LocalDate valuationDate) {
        Payment premium = trade.getPremium();
        if (premium.getDate().equals(valuationDate)) {
            return CurrencyAmount.of((Currency)premium.getCurrency(), (double)premium.getAmount());
        }
        return CurrencyAmount.of((Currency)premium.getCurrency(), (double)0.0);
    }

    public FxRate forwardFxRate(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider) {
        ResolvedFxVanillaOption product = trade.getProduct();
        return this.productPricer.forwardFxRate(product, ratesProvider);
    }

    public double impliedVolatility(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxVanillaOption option = trade.getProduct();
        return this.productPricer.impliedVolatility(option, ratesProvider, volatilities);
    }
}

