/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesName;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FxOptionSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final FxOptionVolatilitiesName volatilitiesName;
    @PropertyDefinition(validate="notNull")
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull")
    private final double expiry;
    @PropertyDefinition
    private final double strike;
    @PropertyDefinition
    private final double forward;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static FxOptionSensitivity of(FxOptionVolatilitiesName volatilitiesName, CurrencyPair currencyPair, double expiry, double strike, double forward, Currency sensitivityCurrency, double sensitivity) {
        return new FxOptionSensitivity(volatilitiesName, currencyPair, expiry, strike, forward, sensitivityCurrency, sensitivity);
    }

    public FxOptionSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new FxOptionSensitivity(this.volatilitiesName, this.currencyPair, this.expiry, this.strike, this.forward, currency, this.sensitivity);
    }

    public FxOptionSensitivity withSensitivity(double sensitivity) {
        return new FxOptionSensitivity(this.volatilitiesName, this.currencyPair, this.expiry, this.strike, this.forward, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof FxOptionSensitivity) {
            FxOptionSensitivity otherOption = (FxOptionSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.volatilitiesName), (Comparable)((Object)otherOption.volatilitiesName)).compare((Comparable)((Object)this.currencyPair.toString()), (Comparable)((Object)otherOption.currencyPair.toString())).compare(this.expiry, otherOption.expiry).compare(this.strike, otherOption.strike).compare(this.forward, otherOption.forward).compare((Comparable)this.currency, (Comparable)otherOption.currency).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public FxOptionSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (FxOptionSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public FxOptionSensitivity multipliedBy(double factor) {
        return new FxOptionSensitivity(this.volatilitiesName, this.currencyPair, this.expiry, this.strike, this.forward, this.currency, this.sensitivity * factor);
    }

    public FxOptionSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new FxOptionSensitivity(this.volatilitiesName, this.currencyPair, this.expiry, this.strike, this.forward, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public FxOptionSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public FxOptionSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxOptionSensitivity(FxOptionVolatilitiesName volatilitiesName, CurrencyPair currencyPair, double expiry, double strike, double forward, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)volatilitiesName, (String)"volatilitiesName");
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.volatilitiesName = volatilitiesName;
        this.currencyPair = currencyPair;
        this.expiry = expiry;
        this.strike = strike;
        this.forward = forward;
        this.currency = currency;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public FxOptionVolatilitiesName getVolatilitiesName() {
        return this.volatilitiesName;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public double getExpiry() {
        return this.expiry;
    }

    public double getStrike() {
        return this.strike;
    }

    public double getForward() {
        return this.forward;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxOptionSensitivity other = (FxOptionSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.volatilitiesName, (Object)other.volatilitiesName) && JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((double)this.expiry, (double)other.expiry) && JodaBeanUtils.equal((double)this.strike, (double)other.strike) && JodaBeanUtils.equal((double)this.forward, (double)other.forward) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.volatilitiesName);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strike);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.forward);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("FxOptionSensitivity{");
        buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
        buf.append("forward").append('=').append(JodaBeanUtils.toString((Object)this.forward)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxOptionSensitivity> {
        private FxOptionVolatilitiesName volatilitiesName;
        private CurrencyPair currencyPair;
        private double expiry;
        private double strike;
        private double forward;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -891985998: {
                    return this.strike;
                }
                case -677145915: {
                    return this.forward;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    this.volatilitiesName = (FxOptionVolatilitiesName)newValue;
                    break;
                }
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (Double)newValue;
                    break;
                }
                case -891985998: {
                    this.strike = (Double)newValue;
                    break;
                }
                case -677145915: {
                    this.forward = (Double)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxOptionSensitivity build() {
            return new FxOptionSensitivity(this.volatilitiesName, this.currencyPair, this.expiry, this.strike, this.forward, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("FxOptionSensitivity.Builder{");
            buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
            buf.append("forward").append('=').append(JodaBeanUtils.toString((Object)this.forward)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxOptionVolatilitiesName> volatilitiesName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"volatilitiesName", FxOptionSensitivity.class, FxOptionVolatilitiesName.class);
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", FxOptionSensitivity.class, CurrencyPair.class);
        private final MetaProperty<Double> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", FxOptionSensitivity.class, Double.TYPE);
        private final MetaProperty<Double> strike = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strike", FxOptionSensitivity.class, Double.TYPE);
        private final MetaProperty<Double> forward = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"forward", FxOptionSensitivity.class, Double.TYPE);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", FxOptionSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", FxOptionSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"volatilitiesName", "currencyPair", "expiry", "strike", "forward", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -891985998: {
                    return this.strike;
                }
                case -677145915: {
                    return this.forward;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxOptionSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends FxOptionSensitivity> beanType() {
            return FxOptionSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxOptionVolatilitiesName> volatilitiesName() {
            return this.volatilitiesName;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<Double> expiry() {
            return this.expiry;
        }

        public MetaProperty<Double> strike() {
            return this.strike;
        }

        public MetaProperty<Double> forward() {
            return this.forward;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return ((FxOptionSensitivity)bean).getVolatilitiesName();
                }
                case 1005147787: {
                    return ((FxOptionSensitivity)bean).getCurrencyPair();
                }
                case -1289159373: {
                    return ((FxOptionSensitivity)bean).getExpiry();
                }
                case -891985998: {
                    return ((FxOptionSensitivity)bean).getStrike();
                }
                case -677145915: {
                    return ((FxOptionSensitivity)bean).getForward();
                }
                case 575402001: {
                    return ((FxOptionSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((FxOptionSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

