/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesName;
import com.opengamma.strata.product.common.PutCall;
import java.time.LocalDate;
import java.time.ZonedDateTime;

public interface FxOptionVolatilities
extends MarketDataView,
ParameterizedData {
    public FxOptionVolatilitiesName getName();

    public CurrencyPair getCurrencyPair();

    public ValueType getVolatilityType();

    default public LocalDate getValuationDate() {
        return this.getValuationDateTime().toLocalDate();
    }

    public ZonedDateTime getValuationDateTime();

    public FxOptionVolatilities withParameter(int var1, double var2);

    public FxOptionVolatilities withPerturbation(ParameterPerturbation var1);

    default public double volatility(CurrencyPair currencyPair, ZonedDateTime expiryDateTime, double strike, double forward) {
        return this.volatility(currencyPair, this.relativeTime(expiryDateTime), strike, forward);
    }

    public double volatility(CurrencyPair var1, double var2, double var4, double var6);

    default public CurrencyParameterSensitivities parameterSensitivity(PointSensitivity ... pointSensitivities) {
        return this.parameterSensitivity(PointSensitivities.of((PointSensitivity[])pointSensitivities));
    }

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities var1);

    public ValueDerivatives firstPartialDerivatives(CurrencyPair var1, double var2, double var4, double var6);

    public double price(double var1, PutCall var3, double var4, double var6, double var8);

    public double relativeTime(ZonedDateTime var1);
}

