/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.DoublesPair;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.RecombiningTrinomialTreeData;
import com.opengamma.strata.pricer.impl.volatility.local.ImpliedTrinomialTreeLocalVolatilityCalculator;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOption;
import java.util.function.Function;

public class ImpliedTrinomialTreeFxOptionCalibrator {
    private final int nSteps;

    public ImpliedTrinomialTreeFxOptionCalibrator(int nSteps) {
        ArgChecker.isTrue((nSteps > 1 ? 1 : 0) != 0, (String)"the number of steps should be greater than 1");
        this.nSteps = nSteps;
    }

    public int getNumberOfSteps() {
        return this.nSteps;
    }

    public RecombiningTrinomialTreeData calibrateTrinomialTree(ResolvedFxVanillaOption option, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        double timeToExpiry = volatilities.relativeTime(option.getExpiry());
        CurrencyPair currencyPair = option.getUnderlying().getCurrencyPair();
        return this.calibrateTrinomialTree(timeToExpiry, currencyPair, ratesProvider, volatilities);
    }

    public RecombiningTrinomialTreeData calibrateTrinomialTree(double timeToExpiry, final CurrencyPair currencyPair, RatesProvider ratesProvider, final BlackFxOptionVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        if (timeToExpiry <= 0.0) {
            throw new IllegalArgumentException("option expired");
        }
        Currency ccyBase = currencyPair.getBase();
        Currency ccyCounter = currencyPair.getCounter();
        final double todayFx = ratesProvider.fxRate(currencyPair);
        final DiscountFactors baseDiscountFactors = ratesProvider.discountFactors(ccyBase);
        final DiscountFactors counterDiscountFactors = ratesProvider.discountFactors(ccyCounter);
        Function<Double, Double> interestRate = new Function<Double, Double>(){

            @Override
            public Double apply(Double t) {
                return counterDiscountFactors.zeroRate(t);
            }
        };
        Function<Double, Double> dividendRate = new Function<Double, Double>(){

            @Override
            public Double apply(Double t) {
                return baseDiscountFactors.zeroRate(t);
            }
        };
        Function<DoublesPair, Double> impliedVolSurface = new Function<DoublesPair, Double>(){

            @Override
            public Double apply(DoublesPair tk) {
                double dfBase = baseDiscountFactors.discountFactor(tk.getFirst());
                double dfCounter = counterDiscountFactors.discountFactor(tk.getFirst());
                double forward = todayFx * dfBase / dfCounter;
                return volatilities.volatility(currencyPair, tk.getFirst(), tk.getSecond(), forward);
            }
        };
        ImpliedTrinomialTreeLocalVolatilityCalculator localVol = new ImpliedTrinomialTreeLocalVolatilityCalculator(this.nSteps, timeToExpiry);
        return localVol.calibrateImpliedVolatility(impliedVolSurface, todayFx, interestRate, dividendRate);
    }

    private void validate(RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ArgChecker.isTrue((boolean)ratesProvider.getValuationDate().isEqual(volatilities.getValuationDateTime().toLocalDate()), (String)"Volatility and rate data must be for the same date");
    }
}

