/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fxopt.ResolvedFxSingleBarrierOption;
import com.opengamma.strata.product.fxopt.ResolvedFxSingleBarrierOptionTrade;
import java.time.LocalDate;

public class ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer {
    public static final ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer DEFAULT = new ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer(ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer productPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer(ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer productPricer, DiscountingPaymentPricer paymentPricer) {
        this.productPricer = (ImpliedTrinomialTreeFxSingleBarrierOptionProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public MultiCurrencyAmount presentValue(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxSingleBarrierOption product = trade.getProduct();
        CurrencyAmount pvProduct = this.productPricer.presentValue(product, ratesProvider, volatilities);
        Payment premium = trade.getPremium();
        CurrencyAmount pvPremium = this.paymentPricer.presentValue(premium, ratesProvider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pvProduct, pvPremium});
    }

    public CurrencyParameterSensitivities presentValueSensitivityRates(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        ResolvedFxSingleBarrierOption product = trade.getProduct();
        CurrencyParameterSensitivities sensProduct = this.productPricer.presentValueSensitivityRates(product, ratesProvider, volatilities);
        Payment premium = trade.getPremium();
        PointSensitivityBuilder pvcsPremium = this.paymentPricer.presentValueSensitivity(premium, ratesProvider);
        CurrencyParameterSensitivities sensPremium = ratesProvider.parameterSensitivity(pvcsPremium.build());
        return sensProduct.combinedWith(sensPremium);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, BlackFxOptionVolatilities volatilities) {
        Payment premium = trade.getPremium();
        CurrencyAmount pvPremium = this.paymentPricer.presentValue(premium, ratesProvider);
        ResolvedFxSingleBarrierOption product = trade.getProduct();
        return this.productPricer.currencyExposure(product, ratesProvider, volatilities).plus(pvPremium);
    }

    public CurrencyAmount currentCash(ResolvedFxSingleBarrierOptionTrade trade, LocalDate valuationDate) {
        Payment premium = trade.getPremium();
        if (premium.getDate().equals(valuationDate)) {
            return CurrencyAmount.of((Currency)premium.getCurrency(), (double)premium.getAmount());
        }
        return CurrencyAmount.of((Currency)premium.getCurrency(), (double)0.0);
    }
}

