/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolators;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.param.ParameterizedDataCombiner;
import com.opengamma.strata.pricer.fxopt.SmileAndBucketedSensitivities;
import com.opengamma.strata.pricer.fxopt.SmileDeltaParameters;
import com.opengamma.strata.pricer.fxopt.SmileDeltaTermStructure;
import com.opengamma.strata.pricer.fxopt.VolatilityAndBucketedSensitivities;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class InterpolatedStrikeSmileDeltaTermStructure
implements SmileDeltaTermStructure,
ParameterizedData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ImmutableList<SmileDeltaParameters> volatilityTerm;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator timeInterpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator timeExtrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator timeExtrapolatorRight;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator strikeInterpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator strikeExtrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator strikeExtrapolatorRight;
    private final transient DoubleArray expiries;
    private final transient ParameterizedDataCombiner paramCombiner;
    private static final long serialVersionUID = 1L;

    public static InterpolatedStrikeSmileDeltaTermStructure of(List<SmileDeltaParameters> volatilityTerm, DayCount dayCount) {
        return InterpolatedStrikeSmileDeltaTermStructure.of(volatilityTerm, dayCount, CurveInterpolators.TIME_SQUARE, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT, CurveInterpolators.LINEAR, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT);
    }

    public static InterpolatedStrikeSmileDeltaTermStructure of(List<SmileDeltaParameters> volatilityTerm, DayCount dayCount, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight) {
        return InterpolatedStrikeSmileDeltaTermStructure.of(volatilityTerm, dayCount, CurveInterpolators.TIME_SQUARE, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT, strikeInterpolator, strikeExtrapolatorLeft, strikeExtrapolatorRight);
    }

    @Deprecated
    public static InterpolatedStrikeSmileDeltaTermStructure of(List<SmileDeltaParameters> volatilityTerm, DayCount dayCount, CurveExtrapolator timeExtrapolatorLeft, CurveInterpolator timeInterpolator, CurveExtrapolator timeExtrapolatorRight, CurveExtrapolator strikeExtrapolatorLeft, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorRight) {
        return InterpolatedStrikeSmileDeltaTermStructure.of(volatilityTerm, dayCount, timeInterpolator, timeExtrapolatorLeft, timeExtrapolatorRight, strikeInterpolator, strikeExtrapolatorLeft, strikeExtrapolatorRight);
    }

    public static InterpolatedStrikeSmileDeltaTermStructure of(List<SmileDeltaParameters> volatilityTerm, DayCount dayCount, CurveInterpolator timeInterpolator, CurveExtrapolator timeExtrapolatorLeft, CurveExtrapolator timeExtrapolatorRight, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight) {
        ArgChecker.notEmpty(volatilityTerm, (String)"volatilityTerm");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        int nSmiles = volatilityTerm.size();
        DoubleArray deltaBase = volatilityTerm.get(0).getDelta();
        for (int i = 1; i < nSmiles; ++i) {
            ArgChecker.isTrue((boolean)deltaBase.equals((Object)volatilityTerm.get(i).getDelta()), (String)"delta must be common to all smiles");
        }
        return new InterpolatedStrikeSmileDeltaTermStructure(volatilityTerm, dayCount, timeInterpolator, timeExtrapolatorLeft, timeExtrapolatorRight, strikeInterpolator, strikeExtrapolatorLeft, strikeExtrapolatorRight);
    }

    public static InterpolatedStrikeSmileDeltaTermStructure of(DoubleArray expiries, DoubleArray delta, DoubleMatrix volatility, DayCount dayCount) {
        return InterpolatedStrikeSmileDeltaTermStructure.of(expiries, delta, volatility, dayCount, CurveInterpolators.TIME_SQUARE, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT, CurveInterpolators.LINEAR, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT);
    }

    public static InterpolatedStrikeSmileDeltaTermStructure of(DoubleArray expiries, DoubleArray delta, DoubleMatrix volatility, DayCount dayCount, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight) {
        return InterpolatedStrikeSmileDeltaTermStructure.of(expiries, delta, volatility, dayCount, CurveInterpolators.TIME_SQUARE, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT, strikeInterpolator, strikeExtrapolatorLeft, strikeExtrapolatorRight);
    }

    public static InterpolatedStrikeSmileDeltaTermStructure of(DoubleArray expiries, DoubleArray delta, DoubleMatrix volatility, DayCount dayCount, CurveInterpolator timeInterpolator, CurveExtrapolator timeExtrapolatorLeft, CurveExtrapolator timeExtrapolatorRight, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight) {
        ArgChecker.notNull((Object)delta, (String)"delta");
        ArgChecker.notNull((Object)volatility, (String)"volatility");
        ArgChecker.notNull((Object)expiries, (String)"expiries");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        ArgChecker.isTrue((delta.size() > 0 ? 1 : 0) != 0, (String)"Need more than one volatility value to perform strike interpolation");
        int nbExp = expiries.size();
        ArgChecker.isTrue((volatility.rowCount() == nbExp ? 1 : 0) != 0, (String)"Volatility array length {} should be equal to the number of expiries {}", (Object[])new Object[]{volatility.rowCount(), nbExp});
        ArgChecker.isTrue((volatility.columnCount() == 2 * delta.size() + 1 ? 1 : 0) != 0, (String)"Volatility array {} should be equal to (2 * number of deltas) + 1, have {}", (Object[])new Object[]{volatility.columnCount(), 2 * delta.size() + 1});
        ImmutableList.Builder vt = ImmutableList.builder();
        for (int loopexp = 0; loopexp < nbExp; ++loopexp) {
            vt.add((Object)SmileDeltaParameters.of(expiries.get(loopexp), delta, volatility.row(loopexp)));
        }
        return new InterpolatedStrikeSmileDeltaTermStructure((List<SmileDeltaParameters>)vt.build(), dayCount, timeInterpolator, timeExtrapolatorLeft, timeExtrapolatorRight, strikeInterpolator, strikeExtrapolatorLeft, strikeExtrapolatorRight, expiries);
    }

    public static InterpolatedStrikeSmileDeltaTermStructure of(DoubleArray expiries, DoubleArray delta, DoubleArray atm, DoubleMatrix riskReversal, DoubleMatrix strangle, DayCount dayCount) {
        return InterpolatedStrikeSmileDeltaTermStructure.of(expiries, delta, atm, riskReversal, strangle, dayCount, CurveInterpolators.TIME_SQUARE, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT, CurveInterpolators.LINEAR, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT);
    }

    public static InterpolatedStrikeSmileDeltaTermStructure of(DoubleArray expiries, DoubleArray delta, DoubleArray atm, DoubleMatrix riskReversal, DoubleMatrix strangle, DayCount dayCount, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight) {
        return InterpolatedStrikeSmileDeltaTermStructure.of(expiries, delta, atm, riskReversal, strangle, dayCount, CurveInterpolators.TIME_SQUARE, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT, strikeInterpolator, strikeExtrapolatorLeft, strikeExtrapolatorRight);
    }

    public static InterpolatedStrikeSmileDeltaTermStructure of(DoubleArray expiries, DoubleArray delta, DoubleArray atm, DoubleMatrix riskReversal, DoubleMatrix strangle, DayCount dayCount, CurveInterpolator timeInterpolator, CurveExtrapolator timeExtrapolatorLeft, CurveExtrapolator timeExtrapolatorRight, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight) {
        ArgChecker.notNull((Object)expiries, (String)"expiries");
        ArgChecker.notNull((Object)delta, (String)"delta");
        ArgChecker.notNull((Object)atm, (String)"ATM");
        ArgChecker.notNull((Object)riskReversal, (String)"risk reversal");
        ArgChecker.notNull((Object)strangle, (String)"strangle");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        int nbExp = expiries.size();
        ArgChecker.isTrue((atm.size() == nbExp ? 1 : 0) != 0, (String)"ATM length should be coherent with time to expiry length");
        ArgChecker.isTrue((riskReversal.rowCount() == nbExp ? 1 : 0) != 0, (String)"Risk reversal length should be coherent with time to expiry length");
        ArgChecker.isTrue((strangle.rowCount() == nbExp ? 1 : 0) != 0, (String)"Strangle length should be coherent with time to expiry length");
        ArgChecker.isTrue((riskReversal.columnCount() == delta.size() ? 1 : 0) != 0, (String)"Risk reversal size should be coherent with time to delta length");
        ArgChecker.isTrue((strangle.columnCount() == delta.size() ? 1 : 0) != 0, (String)"Strangle size should be coherent with time to delta length");
        ImmutableList.Builder vt = ImmutableList.builder();
        for (int loopexp = 0; loopexp < nbExp; ++loopexp) {
            vt.add((Object)SmileDeltaParameters.of(expiries.get(loopexp), atm.get(loopexp), delta, riskReversal.row(loopexp), strangle.row(loopexp)));
        }
        return new InterpolatedStrikeSmileDeltaTermStructure((List<SmileDeltaParameters>)vt.build(), dayCount, timeInterpolator, timeExtrapolatorLeft, timeExtrapolatorRight, strikeInterpolator, strikeExtrapolatorLeft, strikeExtrapolatorRight, expiries);
    }

    @ImmutableConstructor
    private InterpolatedStrikeSmileDeltaTermStructure(List<SmileDeltaParameters> volatilityTerm, DayCount dayCount, CurveInterpolator timeInterpolator, CurveExtrapolator timeExtrapolatorLeft, CurveExtrapolator timeExtrapolatorRight, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight) {
        this(volatilityTerm, dayCount, timeInterpolator, timeExtrapolatorLeft, timeExtrapolatorRight, strikeInterpolator, strikeExtrapolatorLeft, strikeExtrapolatorRight, DoubleArray.copyOf((Collection)volatilityTerm.stream().map(vt -> vt.getExpiry()).collect(Collectors.toList())));
    }

    private InterpolatedStrikeSmileDeltaTermStructure(List<SmileDeltaParameters> volatilityTerm, DayCount dayCount, CurveInterpolator timeInterpolator, CurveExtrapolator timeExtrapolatorLeft, CurveExtrapolator timeExtrapolatorRight, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight, DoubleArray expiries) {
        JodaBeanUtils.notNull(volatilityTerm, (String)"volatilityTerm");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)timeInterpolator, (String)"timeInterpolator");
        JodaBeanUtils.notNull((Object)timeExtrapolatorLeft, (String)"timeExtrapolatorLeft");
        JodaBeanUtils.notNull((Object)timeExtrapolatorRight, (String)"timeExtrapolatorRight");
        JodaBeanUtils.notNull((Object)strikeInterpolator, (String)"strikeInterpolator");
        JodaBeanUtils.notNull((Object)strikeExtrapolatorLeft, (String)"strikeExtrapolatorLeft");
        JodaBeanUtils.notNull((Object)strikeExtrapolatorRight, (String)"strikeExtrapolatorRight");
        this.volatilityTerm = ImmutableList.copyOf(volatilityTerm);
        this.dayCount = dayCount;
        this.timeExtrapolatorLeft = timeExtrapolatorLeft;
        this.timeInterpolator = timeInterpolator;
        this.timeExtrapolatorRight = timeExtrapolatorRight;
        this.strikeExtrapolatorLeft = strikeExtrapolatorLeft;
        this.strikeInterpolator = strikeInterpolator;
        this.strikeExtrapolatorRight = strikeExtrapolatorRight;
        this.expiries = expiries;
        this.paramCombiner = ParameterizedDataCombiner.of(volatilityTerm);
    }

    private Object readResolve() {
        return new InterpolatedStrikeSmileDeltaTermStructure((List<SmileDeltaParameters>)this.volatilityTerm, this.dayCount, this.timeInterpolator, this.timeExtrapolatorLeft, this.timeExtrapolatorRight, this.strikeInterpolator, this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
    }

    public int getParameterCount() {
        return this.paramCombiner.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.paramCombiner.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.paramCombiner.getParameterMetadata(parameterIndex);
    }

    @Override
    public InterpolatedStrikeSmileDeltaTermStructure withParameter(int parameterIndex, double newValue) {
        List updated = this.paramCombiner.withParameter(SmileDeltaParameters.class, parameterIndex, newValue);
        return new InterpolatedStrikeSmileDeltaTermStructure(updated, this.dayCount, this.timeInterpolator, this.timeExtrapolatorLeft, this.timeExtrapolatorRight, this.strikeInterpolator, this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
    }

    @Override
    public InterpolatedStrikeSmileDeltaTermStructure withPerturbation(ParameterPerturbation perturbation) {
        List updated = this.paramCombiner.withPerturbation(SmileDeltaParameters.class, perturbation);
        return new InterpolatedStrikeSmileDeltaTermStructure(updated, this.dayCount, this.timeInterpolator, this.timeExtrapolatorLeft, this.timeExtrapolatorRight, this.strikeInterpolator, this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
    }

    @Override
    public DoubleArray getExpiries() {
        return this.expiries;
    }

    @Override
    public List<Optional<Tenor>> getExpiryTenors() {
        return (List)this.volatilityTerm.stream().map(smileDeltaParams -> smileDeltaParams.getExpiryTenor()).collect(Guavate.toImmutableList());
    }

    @Override
    public double volatility(double time, double strike, double forward) {
        ArgChecker.isTrue((time >= 0.0 ? 1 : 0) != 0, (String)"Positive time");
        SmileDeltaParameters smile = this.smileForExpiry(time);
        DoubleArray strikes = smile.strike(forward);
        BoundCurveInterpolator bound = this.strikeInterpolator.bind(strikes, smile.getVolatility(), this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
        return bound.interpolate(strike);
    }

    @Override
    public VolatilityAndBucketedSensitivities volatilityAndSensitivities(double time, double strike, double forward) {
        ArgChecker.isTrue((time >= 0.0 ? 1 : 0) != 0, (String)"Positive time");
        SmileDeltaParameters smile = this.smileForExpiry(time);
        DoubleArray strikes = smile.strike(forward);
        BoundCurveInterpolator bound = this.strikeInterpolator.bind(strikes, smile.getVolatility(), this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
        double volatility = bound.interpolate(strike);
        DoubleArray smileVolatilityBar = bound.parameterSensitivity(strike);
        SmileAndBucketedSensitivities smileAndSensitivities = this.smileAndSensitivitiesForExpiry(time, smileVolatilityBar);
        return VolatilityAndBucketedSensitivities.of(volatility, smileAndSensitivities.getSensitivities());
    }

    @Override
    public ValueDerivatives partialFirstDerivatives(double expiry, double strike, double forward) {
        ArgChecker.isTrue((expiry >= 0.0 ? 1 : 0) != 0, (String)"Positive time");
        SmileDeltaParameters smile = this.smileForExpiry(expiry);
        DoubleArray strikes = smile.strike(forward);
        BoundCurveInterpolator volBound = this.strikeInterpolator.bind(strikes, smile.getVolatility(), this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
        double vol = volBound.interpolate(strike);
        double dVoldStrike = volBound.firstDerivative(strike);
        DoubleArray smileVolsDerivativeToExpiry = this.smileVolsDerivativeToExpiry(expiry);
        BoundCurveInterpolator smileVolDerivativeBound = this.strikeInterpolator.bind(strikes, smileVolsDerivativeToExpiry, this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
        double dSmileVoldExpiry = smileVolDerivativeBound.interpolate(strike);
        DoubleArray impliedStrikesDerivativeToTime = smile.impliedStrikesDerivativeToExpiry(forward);
        DoubleArray impliedStrikesDerivativeToSmileVols = smile.impliedStrikesDerivativeToSmileVols(forward);
        BoundCurveInterpolator impliedVolDerivativeTimeBound = this.strikeInterpolator.bind(strikes, impliedStrikesDerivativeToTime, this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
        BoundCurveInterpolator impliedVolDerivativeSmileVolBound = this.strikeInterpolator.bind(strikes, impliedStrikesDerivativeToSmileVols, this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
        double dImpliedStrikedExpiry = impliedVolDerivativeTimeBound.interpolate(strike);
        double dImpliedStrikedSmileVol = impliedVolDerivativeSmileVolBound.interpolate(strike);
        double dStrikedExpiry = dImpliedStrikedSmileVol * dSmileVoldExpiry + dImpliedStrikedExpiry;
        double negativedVoldStrike = -1.0 * dVoldStrike;
        double dVoldExpiry = dStrikedExpiry * negativedVoldStrike + dSmileVoldExpiry;
        return ValueDerivatives.of((double)vol, (DoubleArray)DoubleArray.of((double)dVoldExpiry, (double)dVoldStrike));
    }

    @Override
    public SmileDeltaParameters smileForExpiry(double expiry) {
        int nbVol = this.getStrikeCount();
        int nbTime = this.getSmileCount();
        ArgChecker.isTrue((nbTime > 1 ? 1 : 0) != 0, (String)"Need more than one time value to perform interpolation");
        double[] volatilityT = new double[nbVol];
        for (int loopvol = 0; loopvol < nbVol; ++loopvol) {
            double[] volDelta = new double[nbTime];
            for (int looptime = 0; looptime < nbTime; ++looptime) {
                volDelta[looptime] = ((SmileDeltaParameters)this.volatilityTerm.get(looptime)).getVolatility().get(loopvol);
            }
            BoundCurveInterpolator bound = this.timeInterpolator.bind(this.getExpiries(), DoubleArray.ofUnsafe((double[])volDelta), this.timeExtrapolatorLeft, this.timeExtrapolatorRight);
            volatilityT[loopvol] = bound.interpolate(expiry);
        }
        return SmileDeltaParameters.of(expiry, this.getDelta(), DoubleArray.ofUnsafe((double[])volatilityT));
    }

    private DoubleArray smileVolsDerivativeToExpiry(double expiry) {
        int nbVol = this.getStrikeCount();
        int nbTime = this.getSmileCount();
        ArgChecker.isTrue((nbTime > 1 ? 1 : 0) != 0, (String)"Need more than one time value to perform interpolation");
        double[] derivatives = new double[nbVol];
        for (int loopvol = 0; loopvol < nbVol; ++loopvol) {
            double[] volDelta = new double[nbTime];
            for (int looptime = 0; looptime < nbTime; ++looptime) {
                volDelta[looptime] = ((SmileDeltaParameters)this.volatilityTerm.get(looptime)).getVolatility().get(loopvol);
            }
            BoundCurveInterpolator bound = this.timeInterpolator.bind(this.getExpiries(), DoubleArray.ofUnsafe((double[])volDelta), this.timeExtrapolatorLeft, this.timeExtrapolatorRight);
            derivatives[loopvol] = bound.firstDerivative(expiry);
        }
        return DoubleArray.ofUnsafe((double[])derivatives);
    }

    @Override
    public SmileAndBucketedSensitivities smileAndSensitivitiesForExpiry(double expiry, DoubleArray volatilityAtTimeSensitivity) {
        int nbVol = this.getStrikeCount();
        ArgChecker.isTrue((volatilityAtTimeSensitivity.size() == nbVol ? 1 : 0) != 0, (String)"Sensitivity with incorrect size");
        ArgChecker.isTrue((nbVol > 1 ? 1 : 0) != 0, (String)"Need more than one volatility value to perform interpolation");
        int nbTime = this.getSmileCount();
        ArgChecker.isTrue((nbTime > 1 ? 1 : 0) != 0, (String)"Need more than one time value to perform interpolation");
        double[] volatilityT = new double[nbVol];
        double[][] volatilitySensitivity = new double[nbTime][nbVol];
        for (int loopvol = 0; loopvol < nbVol; ++loopvol) {
            double[] volDelta = new double[nbTime];
            for (int looptime = 0; looptime < nbTime; ++looptime) {
                volDelta[looptime] = ((SmileDeltaParameters)this.volatilityTerm.get(looptime)).getVolatility().get(loopvol);
            }
            BoundCurveInterpolator bound = this.timeInterpolator.bind(this.getExpiries(), DoubleArray.ofUnsafe((double[])volDelta), this.timeExtrapolatorLeft, this.timeExtrapolatorRight);
            DoubleArray volatilitySensitivityVol = bound.parameterSensitivity(expiry);
            for (int looptime = 0; looptime < nbTime; ++looptime) {
                volatilitySensitivity[looptime][loopvol] = volatilitySensitivityVol.get(looptime) * volatilityAtTimeSensitivity.get(loopvol);
            }
            volatilityT[loopvol] = bound.interpolate(expiry);
        }
        SmileDeltaParameters smile = SmileDeltaParameters.of(expiry, this.getDelta(), DoubleArray.ofUnsafe((double[])volatilityT));
        return SmileAndBucketedSensitivities.of(smile, DoubleMatrix.ofUnsafe((double[][])volatilitySensitivity));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public ImmutableList<SmileDeltaParameters> getVolatilityTerm() {
        return this.volatilityTerm;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    public CurveInterpolator getTimeInterpolator() {
        return this.timeInterpolator;
    }

    public CurveExtrapolator getTimeExtrapolatorLeft() {
        return this.timeExtrapolatorLeft;
    }

    public CurveExtrapolator getTimeExtrapolatorRight() {
        return this.timeExtrapolatorRight;
    }

    public CurveInterpolator getStrikeInterpolator() {
        return this.strikeInterpolator;
    }

    public CurveExtrapolator getStrikeExtrapolatorLeft() {
        return this.strikeExtrapolatorLeft;
    }

    public CurveExtrapolator getStrikeExtrapolatorRight() {
        return this.strikeExtrapolatorRight;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InterpolatedStrikeSmileDeltaTermStructure other = (InterpolatedStrikeSmileDeltaTermStructure)obj;
            return JodaBeanUtils.equal(this.volatilityTerm, other.volatilityTerm) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.timeInterpolator, (Object)other.timeInterpolator) && JodaBeanUtils.equal((Object)this.timeExtrapolatorLeft, (Object)other.timeExtrapolatorLeft) && JodaBeanUtils.equal((Object)this.timeExtrapolatorRight, (Object)other.timeExtrapolatorRight) && JodaBeanUtils.equal((Object)this.strikeInterpolator, (Object)other.strikeInterpolator) && JodaBeanUtils.equal((Object)this.strikeExtrapolatorLeft, (Object)other.strikeExtrapolatorLeft) && JodaBeanUtils.equal((Object)this.strikeExtrapolatorRight, (Object)other.strikeExtrapolatorRight);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.volatilityTerm);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.timeInterpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.timeExtrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.timeExtrapolatorRight);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeInterpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeExtrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeExtrapolatorRight);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(288);
        buf.append("InterpolatedStrikeSmileDeltaTermStructure{");
        buf.append("volatilityTerm").append('=').append(JodaBeanUtils.toString(this.volatilityTerm)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("timeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.timeInterpolator)).append(',').append(' ');
        buf.append("timeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorLeft)).append(',').append(' ');
        buf.append("timeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorRight)).append(',').append(' ');
        buf.append("strikeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.strikeInterpolator)).append(',').append(' ');
        buf.append("strikeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorLeft)).append(',').append(' ');
        buf.append("strikeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorRight));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<InterpolatedStrikeSmileDeltaTermStructure> {
        private List<SmileDeltaParameters> volatilityTerm = ImmutableList.of();
        private DayCount dayCount;
        private CurveInterpolator timeInterpolator;
        private CurveExtrapolator timeExtrapolatorLeft;
        private CurveExtrapolator timeExtrapolatorRight;
        private CurveInterpolator strikeInterpolator;
        private CurveExtrapolator strikeExtrapolatorLeft;
        private CurveExtrapolator strikeExtrapolatorRight;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 70074929: {
                    return this.volatilityTerm;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -587914188: {
                    return this.timeInterpolator;
                }
                case -286652761: {
                    return this.timeExtrapolatorLeft;
                }
                case -290640004: {
                    return this.timeExtrapolatorRight;
                }
                case 815202713: {
                    return this.strikeInterpolator;
                }
                case -1176196724: {
                    return this.strikeExtrapolatorLeft;
                }
                case -2096699081: {
                    return this.strikeExtrapolatorRight;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 70074929: {
                    this.volatilityTerm = (List)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -587914188: {
                    this.timeInterpolator = (CurveInterpolator)newValue;
                    break;
                }
                case -286652761: {
                    this.timeExtrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case -290640004: {
                    this.timeExtrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                case 815202713: {
                    this.strikeInterpolator = (CurveInterpolator)newValue;
                    break;
                }
                case -1176196724: {
                    this.strikeExtrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case -2096699081: {
                    this.strikeExtrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public InterpolatedStrikeSmileDeltaTermStructure build() {
            return new InterpolatedStrikeSmileDeltaTermStructure((List)this.volatilityTerm, this.dayCount, this.timeInterpolator, this.timeExtrapolatorLeft, this.timeExtrapolatorRight, this.strikeInterpolator, this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("InterpolatedStrikeSmileDeltaTermStructure.Builder{");
            buf.append("volatilityTerm").append('=').append(JodaBeanUtils.toString(this.volatilityTerm)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("timeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.timeInterpolator)).append(',').append(' ');
            buf.append("timeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorLeft)).append(',').append(' ');
            buf.append("timeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorRight)).append(',').append(' ');
            buf.append("strikeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.strikeInterpolator)).append(',').append(' ');
            buf.append("strikeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorLeft)).append(',').append(' ');
            buf.append("strikeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorRight));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<SmileDeltaParameters>> volatilityTerm = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"volatilityTerm", InterpolatedStrikeSmileDeltaTermStructure.class, ImmutableList.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", InterpolatedStrikeSmileDeltaTermStructure.class, DayCount.class);
        private final MetaProperty<CurveInterpolator> timeInterpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeInterpolator", InterpolatedStrikeSmileDeltaTermStructure.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> timeExtrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeExtrapolatorLeft", InterpolatedStrikeSmileDeltaTermStructure.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> timeExtrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeExtrapolatorRight", InterpolatedStrikeSmileDeltaTermStructure.class, CurveExtrapolator.class);
        private final MetaProperty<CurveInterpolator> strikeInterpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikeInterpolator", InterpolatedStrikeSmileDeltaTermStructure.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> strikeExtrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikeExtrapolatorLeft", InterpolatedStrikeSmileDeltaTermStructure.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> strikeExtrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikeExtrapolatorRight", InterpolatedStrikeSmileDeltaTermStructure.class, CurveExtrapolator.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"volatilityTerm", "dayCount", "timeInterpolator", "timeExtrapolatorLeft", "timeExtrapolatorRight", "strikeInterpolator", "strikeExtrapolatorLeft", "strikeExtrapolatorRight"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 70074929: {
                    return this.volatilityTerm;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -587914188: {
                    return this.timeInterpolator;
                }
                case -286652761: {
                    return this.timeExtrapolatorLeft;
                }
                case -290640004: {
                    return this.timeExtrapolatorRight;
                }
                case 815202713: {
                    return this.strikeInterpolator;
                }
                case -1176196724: {
                    return this.strikeExtrapolatorLeft;
                }
                case -2096699081: {
                    return this.strikeExtrapolatorRight;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends InterpolatedStrikeSmileDeltaTermStructure> builder() {
            return new Builder();
        }

        public Class<? extends InterpolatedStrikeSmileDeltaTermStructure> beanType() {
            return InterpolatedStrikeSmileDeltaTermStructure.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<SmileDeltaParameters>> volatilityTerm() {
            return this.volatilityTerm;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<CurveInterpolator> timeInterpolator() {
            return this.timeInterpolator;
        }

        public MetaProperty<CurveExtrapolator> timeExtrapolatorLeft() {
            return this.timeExtrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> timeExtrapolatorRight() {
            return this.timeExtrapolatorRight;
        }

        public MetaProperty<CurveInterpolator> strikeInterpolator() {
            return this.strikeInterpolator;
        }

        public MetaProperty<CurveExtrapolator> strikeExtrapolatorLeft() {
            return this.strikeExtrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> strikeExtrapolatorRight() {
            return this.strikeExtrapolatorRight;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 70074929: {
                    return ((InterpolatedStrikeSmileDeltaTermStructure)bean).getVolatilityTerm();
                }
                case 1905311443: {
                    return ((InterpolatedStrikeSmileDeltaTermStructure)bean).getDayCount();
                }
                case -587914188: {
                    return ((InterpolatedStrikeSmileDeltaTermStructure)bean).getTimeInterpolator();
                }
                case -286652761: {
                    return ((InterpolatedStrikeSmileDeltaTermStructure)bean).getTimeExtrapolatorLeft();
                }
                case -290640004: {
                    return ((InterpolatedStrikeSmileDeltaTermStructure)bean).getTimeExtrapolatorRight();
                }
                case 815202713: {
                    return ((InterpolatedStrikeSmileDeltaTermStructure)bean).getStrikeInterpolator();
                }
                case -1176196724: {
                    return ((InterpolatedStrikeSmileDeltaTermStructure)bean).getStrikeExtrapolatorLeft();
                }
                case -2096699081: {
                    return ((InterpolatedStrikeSmileDeltaTermStructure)bean).getStrikeExtrapolatorRight();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

