/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.fxopt;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class RecombiningTrinomialTreeData
implements ImmutableBean,
Serializable {
    @PropertyDefinition
    private final DoubleMatrix stateValue;
    @PropertyDefinition
    private final ImmutableList<DoubleMatrix> transitionProbability;
    @PropertyDefinition
    private final DoubleArray discountFactor;
    @PropertyDefinition
    private final DoubleArray time;
    private static final long serialVersionUID = 1L;

    public static RecombiningTrinomialTreeData of(DoubleMatrix stateValue, List<DoubleMatrix> transitionProbability, DoubleArray discountFactor, DoubleArray time) {
        int nSteps = discountFactor.size();
        ArgChecker.isTrue((stateValue.rowCount() == nSteps + 1 ? 1 : 0) != 0, (String)"the number of rows of stateValue must be (nSteps + 1)");
        ArgChecker.isTrue((transitionProbability.size() == nSteps ? 1 : 0) != 0, (String)"the size of transitionProbability list must be nSteps");
        ArgChecker.isTrue((time.size() == nSteps + 1 ? 1 : 0) != 0, (String)"the size of time must be (nSteps + 1)");
        for (int i = 0; i < nSteps; ++i) {
            ArgChecker.isTrue((stateValue.row(i).size() == 2 * i + 1 ? 1 : 0) != 0, (String)"the i-th row of stateValue must have the size (2 * i + 1)");
            ArgChecker.isTrue((transitionProbability.get(i).rowCount() == 2 * i + 1 ? 1 : 0) != 0, (String)"the i-th element of transitionProbability list must have (2 * i + 1) rows");
            ArgChecker.isTrue((transitionProbability.get(i).columnCount() == 3 ? 1 : 0) != 0, (String)"the i-th element of transitionProbability list must have 3 columns");
        }
        ArgChecker.isTrue((stateValue.row(nSteps).size() == 2 * nSteps + 1 ? 1 : 0) != 0);
        return new RecombiningTrinomialTreeData(stateValue, transitionProbability, discountFactor, time);
    }

    public int getNumberOfSteps() {
        return this.transitionProbability.size();
    }

    public DoubleArray getStateValueAtLayer(int i) {
        return this.stateValue.row(i);
    }

    public DoubleMatrix getProbabilityAtLayer(int i) {
        return (DoubleMatrix)this.transitionProbability.get(i);
    }

    public double getDiscountFactorAtLayer(int i) {
        return this.discountFactor.get(i);
    }

    public double getSpot() {
        return this.stateValue.get(0, 0);
    }

    public double getTime(int i) {
        return this.time.get(i);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private RecombiningTrinomialTreeData(DoubleMatrix stateValue, List<DoubleMatrix> transitionProbability, DoubleArray discountFactor, DoubleArray time) {
        this.stateValue = stateValue;
        this.transitionProbability = transitionProbability != null ? ImmutableList.copyOf(transitionProbability) : null;
        this.discountFactor = discountFactor;
        this.time = time;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public DoubleMatrix getStateValue() {
        return this.stateValue;
    }

    public ImmutableList<DoubleMatrix> getTransitionProbability() {
        return this.transitionProbability;
    }

    public DoubleArray getDiscountFactor() {
        return this.discountFactor;
    }

    public DoubleArray getTime() {
        return this.time;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RecombiningTrinomialTreeData other = (RecombiningTrinomialTreeData)obj;
            return JodaBeanUtils.equal((Object)this.stateValue, (Object)other.stateValue) && JodaBeanUtils.equal(this.transitionProbability, other.transitionProbability) && JodaBeanUtils.equal((Object)this.discountFactor, (Object)other.discountFactor) && JodaBeanUtils.equal((Object)this.time, (Object)other.time);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stateValue);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.transitionProbability);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.discountFactor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.time);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("RecombiningTrinomialTreeData{");
        buf.append("stateValue").append('=').append(JodaBeanUtils.toString((Object)this.stateValue)).append(',').append(' ');
        buf.append("transitionProbability").append('=').append(JodaBeanUtils.toString(this.transitionProbability)).append(',').append(' ');
        buf.append("discountFactor").append('=').append(JodaBeanUtils.toString((Object)this.discountFactor)).append(',').append(' ');
        buf.append("time").append('=').append(JodaBeanUtils.toString((Object)this.time));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<RecombiningTrinomialTreeData> {
        private DoubleMatrix stateValue;
        private List<DoubleMatrix> transitionProbability;
        private DoubleArray discountFactor;
        private DoubleArray time;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -236449952: {
                    return this.stateValue;
                }
                case 734501792: {
                    return this.transitionProbability;
                }
                case -557144592: {
                    return this.discountFactor;
                }
                case 3560141: {
                    return this.time;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -236449952: {
                    this.stateValue = (DoubleMatrix)newValue;
                    break;
                }
                case 734501792: {
                    this.transitionProbability = (List)newValue;
                    break;
                }
                case -557144592: {
                    this.discountFactor = (DoubleArray)newValue;
                    break;
                }
                case 3560141: {
                    this.time = (DoubleArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public RecombiningTrinomialTreeData build() {
            return new RecombiningTrinomialTreeData(this.stateValue, this.transitionProbability, this.discountFactor, this.time);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("RecombiningTrinomialTreeData.Builder{");
            buf.append("stateValue").append('=').append(JodaBeanUtils.toString((Object)this.stateValue)).append(',').append(' ');
            buf.append("transitionProbability").append('=').append(JodaBeanUtils.toString(this.transitionProbability)).append(',').append(' ');
            buf.append("discountFactor").append('=').append(JodaBeanUtils.toString((Object)this.discountFactor)).append(',').append(' ');
            buf.append("time").append('=').append(JodaBeanUtils.toString((Object)this.time));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<DoubleMatrix> stateValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stateValue", RecombiningTrinomialTreeData.class, DoubleMatrix.class);
        private final MetaProperty<ImmutableList<DoubleMatrix>> transitionProbability = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"transitionProbability", RecombiningTrinomialTreeData.class, ImmutableList.class);
        private final MetaProperty<DoubleArray> discountFactor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountFactor", RecombiningTrinomialTreeData.class, DoubleArray.class);
        private final MetaProperty<DoubleArray> time = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"time", RecombiningTrinomialTreeData.class, DoubleArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"stateValue", "transitionProbability", "discountFactor", "time"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -236449952: {
                    return this.stateValue;
                }
                case 734501792: {
                    return this.transitionProbability;
                }
                case -557144592: {
                    return this.discountFactor;
                }
                case 3560141: {
                    return this.time;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends RecombiningTrinomialTreeData> builder() {
            return new Builder();
        }

        public Class<? extends RecombiningTrinomialTreeData> beanType() {
            return RecombiningTrinomialTreeData.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<DoubleMatrix> stateValue() {
            return this.stateValue;
        }

        public MetaProperty<ImmutableList<DoubleMatrix>> transitionProbability() {
            return this.transitionProbability;
        }

        public MetaProperty<DoubleArray> discountFactor() {
            return this.discountFactor;
        }

        public MetaProperty<DoubleArray> time() {
            return this.time;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -236449952: {
                    return ((RecombiningTrinomialTreeData)bean).getStateValue();
                }
                case 734501792: {
                    return ((RecombiningTrinomialTreeData)bean).getTransitionProbability();
                }
                case -557144592: {
                    return ((RecombiningTrinomialTreeData)bean).getDiscountFactor();
                }
                case 3560141: {
                    return ((RecombiningTrinomialTreeData)bean).getTime();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

