/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.option;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.MathUtils;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import com.opengamma.strata.product.option.SimpleConstantContinuousBarrier;

public class BlackOneTouchAssetPriceFormulaRepository {
    private static final ProbabilityDistribution<Double> NORMAL = new NormalDistribution(0.0, 1.0);
    private static final double SMALL = 1.0E-6;

    public double price(double spot, double timeToExpiry, double costOfCarry, double rate, double lognormalVol, SimpleConstantContinuousBarrier barrier) {
        ArgChecker.notNull((Object)barrier, (String)"barrier");
        boolean isKnockIn = barrier.getKnockType().isKnockIn();
        boolean isDown = barrier.getBarrierType().isDown();
        double h = barrier.getBarrierLevel();
        ArgChecker.isFalse((isDown && spot <= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (DOWN and spot<=barrier).");
        ArgChecker.isFalse((!isDown && spot >= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (UP and spot>=barrier).");
        double eta = isDown ? 1.0 : -1.0;
        double df1 = Math.exp(timeToExpiry * (costOfCarry - rate));
        double lognormalVolSq = lognormalVol * lognormalVol;
        double lognormalVolT = lognormalVol * Math.sqrt(timeToExpiry);
        if (MathUtils.nearZero((double)Math.min(timeToExpiry, lognormalVolSq), (double)1.0E-6)) {
            return isKnockIn ? 0.0 : spot * df1;
        }
        double mu = (costOfCarry - 0.5 * lognormalVolSq) / lognormalVolSq;
        double lambda = Math.sqrt(mu * mu + 2.0 * rate / lognormalVolSq);
        double m1 = lognormalVolT * (1.0 + mu);
        double x2 = Math.log(spot / h) / lognormalVolT + m1;
        double y2 = Math.log(h / spot) / lognormalVolT + m1;
        double z = Math.log(h / spot) / lognormalVolT + lambda * lognormalVolT;
        double xE = isKnockIn ? this.getF(spot, z, lognormalVolT, h, mu, lambda, eta, h) : this.getE(spot, df1, x2, y2, h, mu, eta);
        return xE;
    }

    public ValueDerivatives priceAdjoint(double spot, double timeToExpiry, double costOfCarry, double rate, double lognormalVol, SimpleConstantContinuousBarrier barrier) {
        ArgChecker.notNull((Object)barrier, (String)"barrier");
        double[] derivatives = new double[6];
        boolean isKnockIn = barrier.getKnockType().isKnockIn();
        boolean isDown = barrier.getBarrierType().isDown();
        double h = barrier.getBarrierLevel();
        ArgChecker.isFalse((isDown && spot <= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (DOWN and spot<=barrier).");
        ArgChecker.isFalse((!isDown && spot >= barrier.getBarrierLevel() ? 1 : 0) != 0, (String)"The Data is not consistent with an alive barrier (UP and spot>=barrier).");
        double eta = isDown ? 1.0 : -1.0;
        double df1 = Math.exp(timeToExpiry * (costOfCarry - rate));
        double lognormalVolSq = lognormalVol * lognormalVol;
        double lognormalVolT = lognormalVol * Math.sqrt(timeToExpiry);
        if (MathUtils.nearZero((double)Math.min(timeToExpiry, lognormalVolSq), (double)1.0E-6)) {
            if (isKnockIn) {
                return ValueDerivatives.of((double)0.0, (DoubleArray)DoubleArray.filled((int)6));
            }
            double price = df1 * spot;
            derivatives[0] = df1;
            derivatives[1] = -timeToExpiry * price;
            derivatives[2] = timeToExpiry * price;
            derivatives[4] = (costOfCarry - rate) * price;
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
        }
        double mu = (costOfCarry - 0.5 * lognormalVolSq) / lognormalVolSq;
        double lambda = Math.sqrt(mu * mu + 2.0 * rate / lognormalVolSq);
        double m1 = lognormalVolT * (1.0 + mu);
        double x2 = Math.log(spot / h) / lognormalVolT + m1;
        double y2 = Math.log(h / spot) / lognormalVolT + m1;
        double z = Math.log(h / spot) / lognormalVolT + lambda * lognormalVolT;
        double[] eDerivFirst = new double[6];
        double[] eDerivSecond = new double[5];
        double[] fDerivFirst = new double[5];
        double[] fDerivSecond = new double[5];
        double price = isKnockIn ? this.getFAdjoint(spot, z, lognormalVolT, h, mu, lambda, eta, h, fDerivFirst, fDerivSecond) : this.getEAdjoint(spot, df1, x2, y2, h, mu, eta, eDerivFirst, eDerivSecond);
        double zBar = 0.0;
        double y2Bar = 0.0;
        double x2Bar = 0.0;
        double zSqBar = 0.0;
        double y2SqBar = 0.0;
        double x2SqBar = 0.0;
        double zsBar = 0.0;
        double x2sBar = 0.0;
        double y2sBar = 0.0;
        double lambdaBar = 0.0;
        double muBar = 0.0;
        double lognormalVolTBar = 0.0;
        double df1Bar = 0.0;
        if (isKnockIn) {
            zBar = fDerivFirst[1];
            lambdaBar = fDerivFirst[4];
            muBar = fDerivFirst[3];
            lognormalVolTBar = fDerivFirst[2];
            derivatives[0] = fDerivFirst[0];
            zSqBar = fDerivSecond[1];
            zsBar = fDerivSecond[2];
            derivatives[5] = fDerivSecond[0];
        } else {
            y2Bar = eDerivFirst[3];
            x2Bar = eDerivFirst[2];
            muBar = eDerivFirst[4];
            df1Bar = eDerivFirst[1];
            derivatives[0] = eDerivFirst[0];
            x2SqBar = eDerivSecond[1];
            y2SqBar = eDerivSecond[2];
            x2sBar = eDerivSecond[3];
            y2sBar = eDerivSecond[4];
            derivatives[5] = eDerivSecond[0];
        }
        double dxyds = 1.0 / spot / lognormalVolT;
        double m1Bar = x2Bar + y2Bar;
        double lognormalVolSqBar = -costOfCarry / (lognormalVolSq * lognormalVolSq) * (muBar += lognormalVolT * m1Bar + mu / lambda * lambdaBar) - rate / (lognormalVolSq * lognormalVolSq) / lambda * lambdaBar;
        derivatives[0] = derivatives[0] + (dxyds * x2Bar - dxyds * y2Bar - dxyds * zBar);
        derivatives[1] = 1.0 / lambda / lognormalVolSq * lambdaBar - timeToExpiry * df1 * df1Bar;
        derivatives[2] = 1.0 / lognormalVolSq * muBar + timeToExpiry * df1 * df1Bar;
        derivatives[3] = 2.0 * lognormalVol * lognormalVolSqBar + Math.sqrt(timeToExpiry) * (lognormalVolTBar += (lambda - Math.log(h / spot) / (lognormalVolT * lognormalVolT)) * zBar - Math.log(h / spot) / (lognormalVolT * lognormalVolT) * y2Bar - Math.log(spot / h) / (lognormalVolT * lognormalVolT) * x2Bar + (1.0 + mu) * m1Bar);
        derivatives[4] = (costOfCarry - rate) * df1 * df1Bar + lognormalVolTBar * lognormalVolT * 0.5 / timeToExpiry;
        derivatives[5] = derivatives[5] + (-dxyds * x2Bar / spot + dxyds * y2Bar / spot + dxyds * zBar / spot + dxyds * dxyds * x2SqBar + 2.0 * dxyds * x2sBar + dxyds * dxyds * y2SqBar - 2.0 * dxyds * y2sBar + dxyds * dxyds * zSqBar - 2.0 * dxyds * zsBar);
        return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
    }

    private double getE(double s, double df1, double x, double y, double h, double mu, double eta) {
        return s * df1 * (NORMAL.getCDF((Object)(eta * x)) - Math.pow(h / s, 2.0 * (mu + 1.0)) * NORMAL.getCDF((Object)(eta * y)));
    }

    private double getF(double s, double z, double lognormalVolT, double h, double mu, double lambda, double eta, double barrier) {
        return barrier * (Math.pow(h / s, mu + lambda) * NORMAL.getCDF((Object)(eta * z)) + Math.pow(h / s, mu - lambda) * NORMAL.getCDF((Object)(eta * (z - 2.0 * lambda * lognormalVolT))));
    }

    private double getEAdjoint(double s, double df1, double x, double y, double h, double mu, double eta, double[] firstDerivatives, double[] secondDerivatives) {
        double n1 = NORMAL.getCDF((Object)(eta * x));
        double n2 = NORMAL.getCDF((Object)(eta * y));
        double n1df = NORMAL.getPDF((Object)x);
        double n2df = NORMAL.getPDF((Object)y);
        double hsMu = Math.pow(h / s, 2.0 * (mu + 1.0));
        double e = s * df1 * (n1 - hsMu * n2);
        firstDerivatives[0] = df1 * n1 - df1 * hsMu * n2 + 2.0 * (mu + 1.0) * df1 * hsMu * n2;
        firstDerivatives[1] = s * (n1 - hsMu * n2);
        firstDerivatives[2] = s * df1 * n1df * eta;
        firstDerivatives[3] = -s * df1 * hsMu * n2df * eta;
        firstDerivatives[4] = -2.0 * Math.log(h / s) * s * df1 * hsMu * n2;
        secondDerivatives[0] = -hsMu * n2 * 2.0 * (mu + 1.0) * (2.0 * mu + 3.0) * df1 / s + hsMu * n2 * 4.0 * (mu + 1.0) * df1 / s;
        secondDerivatives[1] = -s * df1 * n1df * eta * x;
        secondDerivatives[2] = hsMu * n2df * s * df1 * eta * y;
        secondDerivatives[3] = df1 * n1df * eta;
        secondDerivatives[4] = -hsMu * n2df * df1 * eta + hsMu * n2df * 2.0 * (mu + 1.0) * df1 * eta;
        return e;
    }

    private double getFAdjoint(double s, double z, double lognormalVolT, double h, double mu, double lambda, double eta, double barrier, double[] firstDerivatives, double[] secondDerivatives) {
        double n1 = NORMAL.getCDF((Object)(eta * z));
        double n2 = NORMAL.getCDF((Object)(eta * (z - 2.0 * lambda * lognormalVolT)));
        double hsMuPLa = Math.pow(h / s, mu + lambda);
        double hsMuMLa = Math.pow(h / s, mu - lambda);
        double f = barrier * (hsMuPLa * n1 + hsMuMLa * n2);
        double fBar = 1.0;
        double n1df = NORMAL.getPDF((Object)(eta * z));
        double n2df = NORMAL.getPDF((Object)(eta * (z - 2.0 * lambda * lognormalVolT)));
        double hsMuPLaBar = n1 * fBar;
        double hsMuMLaBar = n2 * fBar;
        double n2Bar = hsMuMLa * fBar;
        double n1Bar = hsMuPLa * fBar;
        firstDerivatives[0] = barrier * (-(mu + lambda) * hsMuPLa / s * hsMuPLaBar - (mu - lambda) * hsMuMLa / s * hsMuMLaBar);
        firstDerivatives[1] = barrier * (n1df * eta * n1Bar + n2df * eta * n2Bar);
        firstDerivatives[2] = barrier * (-n2df * eta * 2.0 * lambda * n2Bar);
        firstDerivatives[3] = barrier * (hsMuPLa * Math.log(h / s) * hsMuPLaBar + hsMuMLa * Math.log(h / s) * hsMuMLaBar);
        firstDerivatives[4] = barrier * (hsMuPLa * Math.log(h / s) * hsMuPLaBar - hsMuMLa * Math.log(h / s) * hsMuMLaBar);
        secondDerivatives[0] = barrier * (hsMuPLa * hsMuPLaBar * (mu + lambda) * (mu + lambda + 1.0) / (s * s) + hsMuMLa * hsMuMLaBar * (mu - lambda) * (mu - lambda + 1.0) / (s * s));
        secondDerivatives[1] = barrier * (-z * n1df * eta * n1Bar - (z - 2.0 * lambda * lognormalVolT) * n2df * eta * n2Bar);
        secondDerivatives[2] = barrier * (-n1df * n1Bar * (mu + lambda) * eta / s - n2df * n2Bar * (mu - lambda) * eta / s);
        return f;
    }
}

