/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.option;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.rootfinding.BisectionSingleRootFinder;
import com.opengamma.strata.math.impl.rootfinding.BracketRoot;
import java.util.function.Function;

public class GenericImpliedVolatiltySolver {
    private static final int MAX_ITERATIONS = 20;
    private static final double VOL_TOL = 1.0E-9;
    private static final double VOL_GUESS = 0.3;
    private static final double BRACKET_STEP = 0.1;
    private static final double MAX_CHANGE = 0.5;
    private final Function<Double, Double> priceFunc;
    private final Function<Double, double[]> priceAndVegaFunc;

    public GenericImpliedVolatiltySolver(final Function<Double, double[]> priceAndVegaFunc) {
        ArgChecker.notNull(priceAndVegaFunc, (String)"priceAndVegaFunc");
        this.priceAndVegaFunc = priceAndVegaFunc;
        this.priceFunc = new Function<Double, Double>(){

            @Override
            public Double apply(Double sigma) {
                return ((double[])priceAndVegaFunc.apply(sigma))[0];
            }
        };
    }

    public GenericImpliedVolatiltySolver(final Function<Double, Double> priceFunc, final Function<Double, Double> vegaFunc) {
        ArgChecker.notNull(priceFunc, (String)"priceFunc");
        ArgChecker.notNull(vegaFunc, (String)"vegaFunc");
        this.priceFunc = priceFunc;
        this.priceAndVegaFunc = new Function<Double, double[]>(){

            @Override
            public double[] apply(Double sigma) {
                return new double[]{(Double)priceFunc.apply(sigma), (Double)vegaFunc.apply(sigma)};
            }
        };
    }

    public double impliedVolatility(double optionPrice) {
        return this.impliedVolatility(optionPrice, 0.3);
    }

    public double impliedVolatility(double optionPrice, double volGuess) {
        boolean above;
        double upperSigma;
        double lowerSigma;
        ArgChecker.isTrue((volGuess >= 0.0 ? 1 : 0) != 0, (String)"volGuess must be positive; have {}", (double)volGuess);
        ArgChecker.isTrue((boolean)Doubles.isFinite((double)volGuess), (String)"volGuess must be finite; have {} ", (double)volGuess);
        try {
            double[] temp = this.bracketRoot(optionPrice, volGuess);
            lowerSigma = temp[0];
            upperSigma = temp[1];
        }
        catch (MathException e) {
            throw new IllegalArgumentException(e.toString() + " No implied Volatility for this price. [price: " + optionPrice + "]");
        }
        double sigma = (lowerSigma + upperSigma) / 2.0;
        double[] pnv = this.priceAndVegaFunc.apply(sigma);
        if (pnv[1] == 0.0 || Double.isNaN(pnv[1])) {
            return this.solveByBisection(optionPrice, lowerSigma, upperSigma);
        }
        double diff = pnv[0] - optionPrice;
        boolean bl = above = diff > 0.0;
        if (above) {
            upperSigma = sigma;
        } else {
            lowerSigma = sigma;
        }
        double trialChange = -diff / pnv[1];
        double actChange = trialChange > 0.0 ? Math.min(0.5, Math.min(trialChange, upperSigma - sigma)) : Math.max(-0.5, Math.max(trialChange, lowerSigma - sigma));
        int count = 0;
        while (Math.abs(actChange) > 1.0E-9) {
            pnv = this.priceAndVegaFunc.apply(sigma += actChange);
            if (pnv[1] == 0.0 || Double.isNaN(pnv[1])) {
                return this.solveByBisection(optionPrice, lowerSigma, upperSigma);
            }
            diff = pnv[0] - optionPrice;
            boolean bl2 = above = diff > 0.0;
            if (above) {
                upperSigma = sigma;
            } else {
                lowerSigma = sigma;
            }
            trialChange = -diff / pnv[1];
            actChange = trialChange > 0.0 ? Math.min(0.5, Math.min(trialChange, upperSigma - sigma)) : Math.max(-0.5, Math.max(trialChange, lowerSigma - sigma));
            if (count++ <= 20) continue;
            return this.solveByBisection(optionPrice, lowerSigma, upperSigma);
        }
        return sigma + actChange;
    }

    private double[] bracketRoot(final double optionPrice, double sigma) {
        BracketRoot bracketer = new BracketRoot();
        Function<Double, Double> func = new Function<Double, Double>(){

            @Override
            public Double apply(Double volatility) {
                return (Double)GenericImpliedVolatiltySolver.this.priceFunc.apply(volatility) / optionPrice - 1.0;
            }
        };
        return bracketer.getBracketedPoints((Function)func, Math.max(0.0, sigma - 0.1), sigma + 0.1, 0.0, Double.POSITIVE_INFINITY);
    }

    private double solveByBisection(final double optionPrice, double lowerSigma, double upperSigma) {
        BisectionSingleRootFinder rootFinder = new BisectionSingleRootFinder(1.0E-9);
        Function<Double, Double> func = new Function<Double, Double>(){

            @Override
            public Double apply(Double volatility) {
                double trialPrice = (Double)GenericImpliedVolatiltySolver.this.priceFunc.apply(volatility);
                return trialPrice / optionPrice - 1.0;
            }
        };
        return rootFinder.getRoot((Function)func, Double.valueOf(lowerSigma), Double.valueOf(upperSigma));
    }
}

