/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.option;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.rootfinding.BisectionSingleRootFinder;
import com.opengamma.strata.math.impl.rootfinding.BracketRoot;
import com.opengamma.strata.math.impl.statistics.distribution.NormalDistribution;
import com.opengamma.strata.math.impl.statistics.distribution.ProbabilityDistribution;
import com.opengamma.strata.product.common.PutCall;
import java.util.function.Function;

public final class NormalFormulaRepository {
    private static final ProbabilityDistribution<Double> DISTRIBUTION = new NormalDistribution(0.0, 1.0);
    private static final double NEAR_ZERO = 1.0E-16;
    private static final int MAX_ITERATIONS = 100;
    private static final double EPS = 1.0E-15;
    private static final double ATM_LIMIT = 0.001;

    private NormalFormulaRepository() {
    }

    public static double price(double forward, double strike, double timeToExpiry, double normalVol, PutCall putCall) {
        int sign;
        double sigmaRootT = normalVol * Math.sqrt(timeToExpiry);
        int n = sign = putCall.isCall() ? 1 : -1;
        if (sigmaRootT < 1.0E-16) {
            double x = (double)sign * (forward - strike);
            return x > 0.0 ? x : 0.0;
        }
        double arg = (double)sign * (forward - strike) / sigmaRootT;
        double cdf = DISTRIBUTION.getCDF((Object)arg);
        double pdf = DISTRIBUTION.getPDF((Object)arg);
        return (double)sign * (forward - strike) * cdf + sigmaRootT * pdf;
    }

    public static ValueDerivatives priceAdjoint(double forward, double strike, double timeToExpiry, double normalVol, double numeraire, PutCall putCall) {
        double volatilityDerivative;
        double strikeDerivative;
        double forwardDerivative;
        double price;
        int sign = putCall.isCall() ? 1 : -1;
        double cdf = 0.0;
        double pdf = 0.0;
        double arg = 0.0;
        double x = 0.0;
        double sigmaRootT = normalVol * Math.sqrt(timeToExpiry);
        if (sigmaRootT < 1.0E-16) {
            x = (double)sign * (forward - strike);
            price = x > 0.0 ? numeraire * x : 0.0;
        } else {
            arg = (double)sign * (forward - strike) / sigmaRootT;
            cdf = DISTRIBUTION.getCDF((Object)arg);
            pdf = DISTRIBUTION.getPDF((Object)arg);
            price = numeraire * ((double)sign * (forward - strike) * cdf + sigmaRootT * pdf);
        }
        double priceBar = 1.0;
        if (sigmaRootT < 1.0E-16) {
            double xBar = x > 0.0 ? numeraire : 0.0;
            forwardDerivative = (double)sign * xBar;
            strikeDerivative = -forwardDerivative;
            volatilityDerivative = 0.0;
        } else {
            double cdfBar = numeraire * ((double)sign * (forward - strike)) * priceBar;
            double pdfBar = numeraire * sigmaRootT * priceBar;
            double argBar = pdf * cdfBar - pdf * arg * pdfBar;
            forwardDerivative = numeraire * (double)sign * cdf * priceBar + (double)sign / sigmaRootT * argBar;
            strikeDerivative = -forwardDerivative;
            double sigmaRootTBar = -arg / sigmaRootT * argBar + numeraire * pdf * priceBar;
            volatilityDerivative = Math.sqrt(timeToExpiry) * sigmaRootTBar;
        }
        return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)forwardDerivative, (double)volatilityDerivative, (double)strikeDerivative));
    }

    public static double delta(double forward, double strike, double timeToExpiry, double normalVol, PutCall putCall) {
        int sign = putCall.isCall() ? 1 : -1;
        double sigmaRootT = normalVol * Math.sqrt(timeToExpiry);
        if (sigmaRootT < 1.0E-16) {
            double x = (double)sign * (forward - strike);
            if (Math.abs(x) <= 1.0E-16) {
                return (double)sign * 0.5;
            }
            return x > 0.0 ? (double)sign : 0.0;
        }
        double arg = (double)sign * (forward - strike) / sigmaRootT;
        double cdf = DISTRIBUTION.getCDF((Object)arg);
        return (double)sign * cdf;
    }

    public static double gamma(double forward, double strike, double timeToExpiry, double normalVol, PutCall putCall) {
        int sign = putCall.isCall() ? 1 : -1;
        double sigmaRootT = normalVol * Math.sqrt(timeToExpiry);
        if (sigmaRootT < 1.0E-16) {
            double x = (double)sign * (forward - strike);
            return Math.abs(x) > 1.0E-16 ? 0.0 : 1.0 / Math.sqrt(Math.PI * 2) / sigmaRootT;
        }
        double arg = (forward - strike) / sigmaRootT;
        double pdf = DISTRIBUTION.getPDF((Object)arg);
        return pdf / sigmaRootT;
    }

    public static double theta(double forward, double strike, double timeToExpiry, double normalVol, PutCall putCall) {
        int sign = putCall.isCall() ? 1 : -1;
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = normalVol * rootT;
        if (sigmaRootT < 1.0E-16) {
            double x = (double)sign * (forward - strike);
            return Math.abs(x) > 1.0E-16 ? 0.0 : -0.5 * normalVol / rootT / Math.sqrt(Math.PI * 2);
        }
        double arg = (forward - strike) / sigmaRootT;
        double pdf = DISTRIBUTION.getPDF((Object)arg);
        return -0.5 * pdf * normalVol / rootT;
    }

    public static double vega(double forward, double strike, double timeToExpiry, double normalVol, PutCall putCall) {
        int sign = putCall.isCall() ? 1 : -1;
        double rootT = Math.sqrt(timeToExpiry);
        double sigmaRootT = normalVol * rootT;
        if (sigmaRootT < 1.0E-16) {
            double x = (double)sign * (forward - strike);
            return Math.abs(x) > 1.0E-16 ? 0.0 : rootT / Math.sqrt(Math.PI * 2);
        }
        double arg = (forward - strike) / sigmaRootT;
        double pdf = DISTRIBUTION.getPDF((Object)arg);
        return pdf * rootT;
    }

    public static double impliedVolatility(final double optionPrice, final double forward, final double strike, final double timeToExpiry, double initialNormalVol, final double numeraire, final PutCall putCall) {
        double intrinsicPrice = numeraire * Math.max(0.0, (double)(putCall.isCall() ? 1 : -1) * (forward - strike));
        ArgChecker.isTrue((optionPrice > intrinsicPrice || DoubleMath.fuzzyEquals((double)optionPrice, (double)intrinsicPrice, (double)1.0E-6) ? 1 : 0) != 0, (String)("Option price (" + optionPrice + ") less than intrinsic value (" + intrinsicPrice + ")"));
        if (Double.doubleToLongBits(optionPrice) == Double.doubleToLongBits(intrinsicPrice)) {
            return 0.0;
        }
        double sigma = Math.min(Math.abs(initialNormalVol), 1.0E-10);
        double maxChange = 0.5 * sigma;
        ValueDerivatives price = NormalFormulaRepository.priceAdjoint(forward, strike, timeToExpiry, sigma, numeraire, putCall);
        double vega = price.getDerivative(1);
        double change = (price.getValue() - optionPrice) / vega;
        double sign = Math.signum(change);
        if ((change = sign * Math.min(maxChange, Math.abs(change))) > 0.0 && change > sigma) {
            change = 0.9 * sigma;
        }
        int count = 0;
        while (Math.abs(change) > 1.0E-15) {
            price = NormalFormulaRepository.priceAdjoint(forward, strike, timeToExpiry, sigma -= change, numeraire, putCall);
            vega = price.getDerivative(1);
            change = (price.getValue() - optionPrice) / vega;
            sign = Math.signum(change);
            if ((change = sign * Math.min(maxChange, Math.abs(change))) > 0.0 && change > sigma) {
                change = 0.9 * sigma;
            }
            if (count++ <= 100) continue;
            BracketRoot bracketer = new BracketRoot();
            BisectionSingleRootFinder rootFinder = new BisectionSingleRootFinder(1.0E-15);
            Function<Double, Double> func = new Function<Double, Double>(){

                @Override
                public Double apply(Double volatility) {
                    return numeraire * NormalFormulaRepository.price(forward, strike, timeToExpiry, volatility, putCall) - optionPrice;
                }
            };
            double[] range = bracketer.getBracketedPoints((Function)func, 0.0, 10.0);
            return rootFinder.getRoot((Function)func, Double.valueOf(range[0]), Double.valueOf(range[1]));
        }
        return sigma;
    }

    public static double impliedVolatilityFromBlackApproximated(double forward, double strike, double timeToExpiry, double blackVolatility) {
        ArgChecker.isTrue((strike > 0.0 ? 1 : 0) != 0, (String)"strike must be strictly positive");
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"strike must be strictly positive");
        double lnFK = Math.log(forward / strike);
        double s2t = blackVolatility * blackVolatility * timeToExpiry;
        if (Math.abs((forward - strike) / strike) < 0.001) {
            double factor1 = Math.sqrt(forward * strike);
            double factor2 = (1.0 + lnFK * lnFK / 24.0) / (1.0 + s2t / 24.0 + s2t * s2t / 5670.0);
            return blackVolatility * factor1 * factor2;
        }
        double factor1 = (forward - strike) / lnFK;
        double factor2 = 1.0 / (1.0 + (1.0 - lnFK * lnFK / 120.0) / 24.0 * s2t + s2t * s2t / 5670.0);
        return blackVolatility * factor1 * factor2;
    }

    public static ValueDerivatives impliedVolatilityFromBlackApproximatedAdjoint(double forward, double strike, double timeToExpiry, double blackVolatility) {
        ArgChecker.isTrue((strike > 0.0 ? 1 : 0) != 0, (String)"strike must be strictly positive");
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"strike must be strictly positive");
        double lnFK = Math.log(forward / strike);
        double s2t = blackVolatility * blackVolatility * timeToExpiry;
        if (Math.abs((forward - strike) / strike) < 0.001) {
            double factor1 = Math.sqrt(forward * strike);
            double factor2 = (1.0 + lnFK * lnFK / 24.0) / (1.0 + s2t / 24.0 + s2t * s2t / 5670.0);
            double normalVol = blackVolatility * factor1 * factor2;
            double blackVolatilityBar = factor1 * factor2;
            double factor2Bar = blackVolatility * factor1;
            double s2tBar = -(1.0 + lnFK * lnFK / 24.0) / ((1.0 + s2t / 24.0 + s2t * s2t / 5670.0) * (1.0 + s2t / 24.0 + s2t * s2t / 5670.0)) * (0.041666666666666664 + s2t / 2835.0) * factor2Bar;
            return ValueDerivatives.of((double)normalVol, (DoubleArray)DoubleArray.of((double)(blackVolatilityBar += 2.0 * blackVolatility * timeToExpiry * s2tBar)));
        }
        double factor1 = (forward - strike) / lnFK;
        double factor2 = 1.0 / (1.0 + (1.0 - lnFK * lnFK / 120.0) / 24.0 * s2t + s2t * s2t / 5670.0);
        double normalVol = blackVolatility * factor1 * factor2;
        double blackVolatilityBar = factor1 * factor2;
        double factor2Bar = blackVolatility * factor1;
        double s2tBar = -factor2 * factor2 * ((1.0 - lnFK * lnFK / 120.0) / 24.0 + s2t / 2835.0) * factor2Bar;
        return ValueDerivatives.of((double)normalVol, (DoubleArray)DoubleArray.of((double)(blackVolatilityBar += 2.0 * blackVolatility * timeToExpiry * s2tBar)));
    }
}

