/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.IborIndexRates;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.IborAveragedFixing;
import com.opengamma.strata.product.rate.IborAveragedRateComputation;
import java.time.LocalDate;

public class ForwardIborAveragedRateComputationFn
implements RateComputationFn<IborAveragedRateComputation> {
    public static final ForwardIborAveragedRateComputationFn DEFAULT = new ForwardIborAveragedRateComputationFn();

    @Override
    public double rate(IborAveragedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        IborIndexRates rates = provider.iborIndexRates(computation.getIndex());
        double weightedRate = computation.getFixings().stream().mapToDouble(fixing -> this.weightedRate((IborAveragedFixing)fixing, rates)).sum();
        return weightedRate / computation.getTotalWeight();
    }

    private double weightedRate(IborAveragedFixing fixing, IborIndexRates rates) {
        double rate = fixing.getFixedRate().orElse(rates.rate(fixing.getObservation()));
        return rate * fixing.getWeight();
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(IborAveragedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        IborIndexRates rates = provider.iborIndexRates(computation.getIndex());
        return computation.getFixings().stream().filter(fixing -> !fixing.getFixedRate().isPresent()).map(fixing -> this.weightedSensitivity((IborAveragedFixing)fixing, computation.getTotalWeight(), rates)).reduce(PointSensitivityBuilder.none(), PointSensitivityBuilder::combinedWith);
    }

    private PointSensitivityBuilder weightedSensitivity(IborAveragedFixing fixing, double totalWeight, IborIndexRates rates) {
        return rates.ratePointSensitivity(fixing.getObservation()).multipliedBy(fixing.getWeight() / totalWeight);
    }

    @Override
    public double explainRate(IborAveragedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        IborIndexRates rates = provider.iborIndexRates(computation.getIndex());
        for (IborAveragedFixing fixing : computation.getFixings()) {
            rates.explainRate(fixing.getObservation(), builder, child -> child.put(ExplainKey.WEIGHT, (Object)fixing.getWeight()));
        }
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }
}

