/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.PriceIndexValues;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.InflationEndInterpolatedRateComputation;
import java.time.LocalDate;

public class ForwardInflationEndInterpolatedRateComputationFn
implements RateComputationFn<InflationEndInterpolatedRateComputation> {
    public static final ForwardInflationEndInterpolatedRateComputationFn DEFAULT = new ForwardInflationEndInterpolatedRateComputationFn();

    @Override
    public double rate(InflationEndInterpolatedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        PriceIndexValues values = provider.priceIndexValues(computation.getIndex());
        double indexStart = computation.getStartIndexValue();
        double indexEnd = this.interpolateEnd(computation, values);
        return indexEnd / indexStart - 1.0;
    }

    private double interpolateEnd(InflationEndInterpolatedRateComputation computation, PriceIndexValues values) {
        double weight = computation.getWeight();
        double indexValue1 = values.value(computation.getEndObservation());
        double indexValue2 = values.value(computation.getEndSecondObservation());
        return weight * indexValue1 + (1.0 - weight) * indexValue2;
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(InflationEndInterpolatedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        PriceIndexValues values = provider.priceIndexValues(computation.getIndex());
        PointSensitivityBuilder sensi = this.endSensitivity(computation, values);
        return sensi.multipliedBy(1.0 / computation.getStartIndexValue());
    }

    private PointSensitivityBuilder endSensitivity(InflationEndInterpolatedRateComputation computation, PriceIndexValues values) {
        double weight = computation.getWeight();
        PointSensitivityBuilder sensi1 = values.valuePointSensitivity(computation.getEndObservation()).multipliedBy(weight);
        PointSensitivityBuilder sensi2 = values.valuePointSensitivity(computation.getEndSecondObservation()).multipliedBy(1.0 - weight);
        return sensi1.combinedWith(sensi2);
    }

    @Override
    public double explainRate(InflationEndInterpolatedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        PriceIndexValues values = provider.priceIndexValues(computation.getIndex());
        double w1 = computation.getWeight();
        double w2 = 1.0 - w1;
        builder.addListEntry(ExplainKey.OBSERVATIONS, child -> child.put(ExplainKey.ENTRY_TYPE, (Object)"InflationObservation").put(ExplainKey.FIXING_DATE, (Object)computation.getEndObservation().getFixingMonth().atEndOfMonth()).put(ExplainKey.INDEX, (Object)computation.getIndex()).put(ExplainKey.INDEX_VALUE, (Object)values.value(computation.getEndObservation())).put(ExplainKey.WEIGHT, (Object)w1));
        builder.addListEntry(ExplainKey.OBSERVATIONS, child -> child.put(ExplainKey.ENTRY_TYPE, (Object)"InflationObservation").put(ExplainKey.FIXING_DATE, (Object)computation.getEndSecondObservation().getFixingMonth().atEndOfMonth()).put(ExplainKey.INDEX, (Object)computation.getIndex()).put(ExplainKey.INDEX_VALUE, (Object)values.value(computation.getEndSecondObservation())).put(ExplainKey.WEIGHT, (Object)w2));
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }
}

