/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndexObservation;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.PricingException;
import com.opengamma.strata.pricer.rate.OvernightIndexRates;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.OvernightCompoundedAnnualRateComputation;
import java.time.LocalDate;
import java.util.OptionalDouble;

public class ForwardOvernightCompoundedAnnualRateComputationFn
implements RateComputationFn<OvernightCompoundedAnnualRateComputation> {
    public static final ForwardOvernightCompoundedAnnualRateComputationFn DEFAULT = new ForwardOvernightCompoundedAnnualRateComputationFn();

    @Override
    public double rate(OvernightCompoundedAnnualRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        OvernightIndexRates rates = provider.overnightIndexRates(computation.getIndex());
        ObservationDetails details = new ObservationDetails(computation, rates);
        return details.calculateRate();
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(OvernightCompoundedAnnualRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        OvernightIndexRates rates = provider.overnightIndexRates(computation.getIndex());
        ObservationDetails details = new ObservationDetails(computation, rates);
        return details.calculateRateSensitivity();
    }

    @Override
    public double explainRate(OvernightCompoundedAnnualRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }

    private static final class ObservationDetails {
        private final OvernightCompoundedAnnualRateComputation computation;
        private final OvernightIndexRates rates;
        private final LocalDateDoubleTimeSeries indexFixingDateSeries;
        private final DayCount dayCount;
        private final LocalDate firstFixing;
        private final LocalDate lastFixingP1;
        private final LocalDate lastFixing;
        private LocalDate nextFixing;
        private final double accrualFactorTotal;

        private ObservationDetails(OvernightCompoundedAnnualRateComputation computation, OvernightIndexRates rates) {
            this.computation = computation;
            this.rates = rates;
            this.indexFixingDateSeries = rates.getFixings();
            this.dayCount = computation.getIndex().getDayCount();
            this.firstFixing = computation.getStartDate();
            this.lastFixingP1 = computation.getEndDate();
            this.lastFixing = computation.getFixingCalendar().previous(this.lastFixingP1);
            LocalDate startUnderlyingPeriod = computation.calculateEffectiveFromFixing(this.firstFixing);
            LocalDate endUnderlyingPeriod = computation.calculateMaturityFromFixing(this.lastFixing);
            this.accrualFactorTotal = this.dayCount.yearFraction(startUnderlyingPeriod, endUnderlyingPeriod);
        }

        private double pastCompositionFactor() {
            double compositionFactor = 1.0;
            LocalDate currentFixing = this.firstFixing;
            LocalDate currentPublication = this.computation.calculatePublicationFromFixing(currentFixing);
            while (!currentFixing.isAfter(this.lastFixing) && this.rates.getValuationDate().isAfter(currentPublication)) {
                LocalDate effectiveDate = this.computation.calculateEffectiveFromFixing(currentFixing);
                LocalDate maturityDate = this.computation.calculateMaturityFromEffective(effectiveDate);
                double accrualFactor = this.dayCount.yearFraction(effectiveDate, maturityDate);
                double rate = ObservationDetails.checkedFixing(currentFixing, this.indexFixingDateSeries, this.computation.getIndex());
                compositionFactor *= Math.pow(1.0 + rate, accrualFactor);
                currentFixing = this.computation.getFixingCalendar().next(currentFixing);
                currentPublication = this.computation.calculatePublicationFromFixing(currentFixing);
            }
            this.nextFixing = currentFixing;
            return compositionFactor;
        }

        private double valuationCompositionFactor() {
            OptionalDouble fixedRate;
            LocalDate currentFixing = this.nextFixing;
            LocalDate currentPublication = this.computation.calculatePublicationFromFixing(currentFixing);
            if (this.rates.getValuationDate().equals(currentPublication) && !currentFixing.isAfter(this.lastFixing) && (fixedRate = this.indexFixingDateSeries.get(currentFixing)).isPresent()) {
                this.nextFixing = this.computation.getFixingCalendar().next(this.nextFixing);
                LocalDate effectiveDate = this.computation.calculateEffectiveFromFixing(currentFixing);
                LocalDate maturityDate = this.computation.calculateMaturityFromEffective(effectiveDate);
                double accrualFactor = this.dayCount.yearFraction(effectiveDate, maturityDate);
                return Math.pow(1.0 + fixedRate.getAsDouble(), accrualFactor);
            }
            return 1.0;
        }

        private double futureCompositionFactor() {
            if (!this.nextFixing.isAfter(this.lastFixing)) {
                OvernightIndexObservation obs = this.computation.observeOn(this.nextFixing);
                LocalDate startDate = obs.getEffectiveDate();
                LocalDate endDate = this.computation.getEndDate();
                double accrualFactor = this.dayCount.yearFraction(startDate, endDate);
                double rate = this.rates.periodRate(obs, endDate);
                return 1.0 + accrualFactor * rate;
            }
            return 1.0;
        }

        private static double checkedFixing(LocalDate currentFixingTs, LocalDateDoubleTimeSeries indexFixingDateSeries, OvernightIndex index) {
            OptionalDouble fixedRate = indexFixingDateSeries.get(currentFixingTs);
            return fixedRate.orElseThrow(() -> new PricingException("Could not get fixing value of index " + index.getName() + " for date " + currentFixingTs));
        }

        private double calculateRate() {
            return (this.pastCompositionFactor() * this.valuationCompositionFactor() * this.futureCompositionFactor() - 1.0) / this.accrualFactorTotal;
        }

        private PointSensitivityBuilder calculateRateSensitivity() {
            double factor = this.pastCompositionFactor() * this.valuationCompositionFactor() / this.accrualFactorTotal;
            if (!this.nextFixing.isAfter(this.lastFixing)) {
                OvernightIndexObservation obs = this.computation.observeOn(this.nextFixing);
                LocalDate startDate = obs.getEffectiveDate();
                LocalDate endDate = this.computation.calculateMaturityFromFixing(this.lastFixing);
                double accrualFactor = this.dayCount.yearFraction(startDate, endDate);
                PointSensitivityBuilder rateSensitivity = this.rates.periodRatePointSensitivity(obs, endDate);
                return rateSensitivity.multipliedBy(factor * accrualFactor);
            }
            return PointSensitivityBuilder.none();
        }
    }
}

