/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndexObservation;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.collect.tuple.ObjDoublePair;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.PricingException;
import com.opengamma.strata.pricer.rate.OvernightIndexRates;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.rate.OvernightCompoundedRateComputation;
import java.time.LocalDate;
import java.util.OptionalDouble;

public class ForwardOvernightCompoundedRateComputationFn
implements RateComputationFn<OvernightCompoundedRateComputation> {
    public static final ForwardOvernightCompoundedRateComputationFn DEFAULT = new ForwardOvernightCompoundedRateComputationFn();

    @Override
    public double rate(OvernightCompoundedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        OvernightIndexRates rates = provider.overnightIndexRates(computation.getIndex());
        ObservationDetails details = new ObservationDetails(computation, rates);
        return details.calculateRate();
    }

    @Override
    public PointSensitivityBuilder rateSensitivity(OvernightCompoundedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider) {
        OvernightIndexRates rates = provider.overnightIndexRates(computation.getIndex());
        ObservationDetails details = new ObservationDetails(computation, rates);
        return details.calculateRateSensitivity();
    }

    @Override
    public double explainRate(OvernightCompoundedRateComputation computation, LocalDate startDate, LocalDate endDate, RatesProvider provider, ExplainMapBuilder builder) {
        double rate = this.rate(computation, startDate, endDate, provider);
        builder.put(ExplainKey.COMBINED_RATE, (Object)rate);
        return rate;
    }

    private static final class ObservationDetails {
        private final OvernightCompoundedRateComputation computation;
        private final OvernightIndexRates rates;
        private final LocalDateDoubleTimeSeries indexFixingDateSeries;
        private final DayCount dayCount;
        private final int cutoffOffset;
        private final LocalDate firstFixing;
        private final LocalDate lastFixingP1;
        private final LocalDate lastFixing;
        private final LocalDate lastFixingNonCutoff;
        private final double accrualFactorTotal;
        private final double[] accrualFactorCutoff;
        private LocalDate nextFixing;

        private ObservationDetails(OvernightCompoundedRateComputation computation, OvernightIndexRates rates) {
            this.computation = computation;
            this.rates = rates;
            this.indexFixingDateSeries = rates.getFixings();
            this.dayCount = computation.getIndex().getDayCount();
            this.firstFixing = computation.getStartDate();
            this.lastFixingP1 = computation.getEndDate();
            this.lastFixing = computation.getFixingCalendar().previous(this.lastFixingP1);
            this.cutoffOffset = Math.max(computation.getRateCutOffDays(), 1);
            this.accrualFactorCutoff = new double[this.cutoffOffset - 1];
            LocalDate currentFixing = this.lastFixing;
            for (int i = 0; i < this.cutoffOffset - 1; ++i) {
                currentFixing = computation.getFixingCalendar().previous(currentFixing);
                LocalDate effectiveDate = computation.calculateEffectiveFromFixing(currentFixing);
                LocalDate maturityDate = computation.calculateMaturityFromEffective(effectiveDate);
                this.accrualFactorCutoff[i] = this.dayCount.yearFraction(effectiveDate, maturityDate);
            }
            this.lastFixingNonCutoff = currentFixing;
            LocalDate startUnderlyingPeriod = computation.calculateEffectiveFromFixing(this.firstFixing);
            LocalDate endUnderlyingPeriod = computation.calculateMaturityFromFixing(this.lastFixing);
            this.accrualFactorTotal = this.dayCount.yearFraction(startUnderlyingPeriod, endUnderlyingPeriod);
        }

        private double pastCompositionFactor() {
            double compositionFactor = 1.0;
            LocalDate currentFixing = this.firstFixing;
            LocalDate currentPublication = this.computation.calculatePublicationFromFixing(currentFixing);
            while (currentFixing.isBefore(this.lastFixingNonCutoff) && this.rates.getValuationDate().isAfter(currentPublication)) {
                LocalDate effectiveDate = this.computation.calculateEffectiveFromFixing(currentFixing);
                LocalDate maturityDate = this.computation.calculateMaturityFromEffective(effectiveDate);
                double accrualFactor = this.dayCount.yearFraction(effectiveDate, maturityDate);
                compositionFactor *= 1.0 + accrualFactor * ObservationDetails.checkedFixing(currentFixing, this.indexFixingDateSeries, this.computation.getIndex());
                currentFixing = this.computation.getFixingCalendar().next(currentFixing);
                currentPublication = this.computation.calculatePublicationFromFixing(currentFixing);
            }
            if (currentFixing.equals(this.lastFixingNonCutoff) && this.rates.getValuationDate().isAfter(currentPublication)) {
                double rate = ObservationDetails.checkedFixing(currentFixing, this.indexFixingDateSeries, this.computation.getIndex());
                LocalDate effectiveDate = this.computation.calculateEffectiveFromFixing(currentFixing);
                LocalDate maturityDate = this.computation.calculateMaturityFromEffective(effectiveDate);
                double accrualFactor = this.dayCount.yearFraction(effectiveDate, maturityDate);
                compositionFactor *= 1.0 + accrualFactor * rate;
                for (int i = 0; i < this.cutoffOffset - 1; ++i) {
                    compositionFactor *= 1.0 + this.accrualFactorCutoff[i] * rate;
                }
                currentFixing = this.computation.getFixingCalendar().next(currentFixing);
            }
            this.nextFixing = currentFixing;
            return compositionFactor;
        }

        private double valuationCompositionFactor() {
            OptionalDouble fixedRate;
            LocalDate currentFixing = this.nextFixing;
            LocalDate currentPublication = this.computation.calculatePublicationFromFixing(currentFixing);
            if (this.rates.getValuationDate().equals(currentPublication) && !currentFixing.isAfter(this.lastFixingNonCutoff) && (fixedRate = this.indexFixingDateSeries.get(currentFixing)).isPresent()) {
                this.nextFixing = this.computation.getFixingCalendar().next(this.nextFixing);
                LocalDate effectiveDate = this.computation.calculateEffectiveFromFixing(currentFixing);
                LocalDate maturityDate = this.computation.calculateMaturityFromEffective(effectiveDate);
                double accrualFactor = this.dayCount.yearFraction(effectiveDate, maturityDate);
                if (currentFixing.isBefore(this.lastFixingNonCutoff)) {
                    return 1.0 + accrualFactor * fixedRate.getAsDouble();
                }
                double compositionFactor = 1.0 + accrualFactor * fixedRate.getAsDouble();
                for (int i = 0; i < this.cutoffOffset - 1; ++i) {
                    compositionFactor *= 1.0 + this.accrualFactorCutoff[i] * fixedRate.getAsDouble();
                }
                return compositionFactor;
            }
            return 1.0;
        }

        private double compositionFactorNonCutoff() {
            if (!this.nextFixing.isAfter(this.lastFixingNonCutoff)) {
                OvernightIndexObservation obs = this.computation.observeOn(this.nextFixing);
                LocalDate startDate = obs.getEffectiveDate();
                LocalDate endDate = this.computation.calculateMaturityFromFixing(this.lastFixingNonCutoff);
                double accrualFactor = this.dayCount.yearFraction(startDate, endDate);
                double rate = this.rates.periodRate(obs, endDate);
                return 1.0 + accrualFactor * rate;
            }
            return 1.0;
        }

        private ObjDoublePair<PointSensitivityBuilder> compositionFactorAndSensitivityNonCutoff() {
            if (!this.nextFixing.isAfter(this.lastFixingNonCutoff)) {
                OvernightIndexObservation obs = this.computation.observeOn(this.nextFixing);
                LocalDate startDate = obs.getEffectiveDate();
                LocalDate endDate = this.computation.calculateMaturityFromFixing(this.lastFixingNonCutoff);
                double accrualFactor = this.dayCount.yearFraction(startDate, endDate);
                double rate = this.rates.periodRate(obs, endDate);
                PointSensitivityBuilder rateSensitivity = this.rates.periodRatePointSensitivity(obs, endDate);
                rateSensitivity = rateSensitivity.multipliedBy(accrualFactor);
                return ObjDoublePair.of((Object)rateSensitivity, (double)(1.0 + accrualFactor * rate));
            }
            return ObjDoublePair.of((Object)PointSensitivityBuilder.none(), (double)1.0);
        }

        private double compositionFactorCutoff() {
            if (!this.nextFixing.isAfter(this.lastFixingNonCutoff)) {
                OvernightIndexObservation obs = this.computation.observeOn(this.lastFixingNonCutoff);
                double rate = this.rates.rate(obs);
                double compositionFactor = 1.0;
                for (int i = 0; i < this.cutoffOffset - 1; ++i) {
                    compositionFactor *= 1.0 + this.accrualFactorCutoff[i] * rate;
                }
                return compositionFactor;
            }
            return 1.0;
        }

        private ObjDoublePair<PointSensitivityBuilder> compositionFactorAndSensitivityCutoff() {
            OvernightIndexObservation obs = this.computation.observeOn(this.lastFixingNonCutoff);
            if (!this.nextFixing.isAfter(this.lastFixingNonCutoff)) {
                double rate = this.rates.rate(obs);
                double compositionFactor = 1.0;
                double compositionFactorDerivative = 0.0;
                for (int i = 0; i < this.cutoffOffset - 1; ++i) {
                    compositionFactor *= 1.0 + this.accrualFactorCutoff[i] * rate;
                    compositionFactorDerivative += this.accrualFactorCutoff[i] / (1.0 + this.accrualFactorCutoff[i] * rate);
                }
                PointSensitivityBuilder rateSensitivity = this.cutoffOffset <= 1 ? PointSensitivityBuilder.none() : this.rates.ratePointSensitivity(obs);
                rateSensitivity = rateSensitivity.multipliedBy(compositionFactorDerivative *= compositionFactor);
                return ObjDoublePair.of((Object)rateSensitivity, (double)compositionFactor);
            }
            return ObjDoublePair.of((Object)PointSensitivityBuilder.none(), (double)1.0);
        }

        private double calculateRate() {
            return (this.pastCompositionFactor() * this.valuationCompositionFactor() * this.compositionFactorNonCutoff() * this.compositionFactorCutoff() - 1.0) / this.accrualFactorTotal;
        }

        private PointSensitivityBuilder calculateRateSensitivity() {
            double factor = this.pastCompositionFactor() * this.valuationCompositionFactor() / this.accrualFactorTotal;
            ObjDoublePair<PointSensitivityBuilder> compositionFactorAndSensitivityNonCutoff = this.compositionFactorAndSensitivityNonCutoff();
            ObjDoublePair<PointSensitivityBuilder> compositionFactorAndSensitivityCutoff = this.compositionFactorAndSensitivityCutoff();
            PointSensitivityBuilder combinedPointSensitivity = ((PointSensitivityBuilder)compositionFactorAndSensitivityNonCutoff.getFirst()).multipliedBy(compositionFactorAndSensitivityCutoff.getSecond() * factor);
            combinedPointSensitivity = combinedPointSensitivity.combinedWith(((PointSensitivityBuilder)compositionFactorAndSensitivityCutoff.getFirst()).multipliedBy(compositionFactorAndSensitivityNonCutoff.getSecond() * factor));
            return combinedPointSensitivity;
        }

        private static double checkedFixing(LocalDate currentFixingTs, LocalDateDoubleTimeSeries indexFixingDateSeries, OvernightIndex index) {
            OptionalDouble fixedRate = indexFixingDateSeries.get(currentFixingTs);
            return fixedRate.orElseThrow(() -> new PricingException("Could not get fixing value of index " + index.getName() + " for date " + currentFixingTs));
        }
    }
}

