/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.rate.swap;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.rate.FixedRateComputation;
import com.opengamma.strata.product.rate.IborRateComputation;
import com.opengamma.strata.product.rate.OvernightCompoundedRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import com.opengamma.strata.product.swap.NotionalExchange;
import com.opengamma.strata.product.swap.RateAccrualPeriod;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swap.SwapPaymentEvent;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CashFlowEquivalentCalculator {
    public static ResolvedSwapLeg cashFlowEquivalentSwap(ResolvedSwap swap, RatesProvider ratesProvider) {
        ArrayList cfEquivalent = new ArrayList();
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            if (leg.getType().equals((Object)SwapLegType.FIXED)) {
                cfEquivalent.addAll(CashFlowEquivalentCalculator.cashFlowEquivalentFixedLeg(leg, ratesProvider).getPaymentEvents());
                continue;
            }
            if (leg.getType().equals((Object)SwapLegType.IBOR)) {
                cfEquivalent.addAll(CashFlowEquivalentCalculator.cashFlowEquivalentIborLeg(leg, ratesProvider).getPaymentEvents());
                continue;
            }
            if (leg.getType().equals((Object)SwapLegType.OVERNIGHT)) {
                cfEquivalent.addAll(CashFlowEquivalentCalculator.cashFlowEquivalentOnLeg(leg, ratesProvider).getPaymentEvents());
                continue;
            }
            throw new IllegalArgumentException("leg type must be FIXED, IBOR or OVERNIGHT");
        }
        ResolvedSwapLeg leg = ResolvedSwapLeg.builder().paymentEvents(cfEquivalent).payReceive(PayReceive.RECEIVE).type(SwapLegType.OTHER).build();
        return leg;
    }

    public static ResolvedSwapLeg cashFlowEquivalentIborLeg(ResolvedSwapLeg iborLeg, RatesProvider ratesProvider) {
        ArgChecker.isTrue((boolean)iborLeg.getType().equals((Object)SwapLegType.IBOR), (String)"Leg type should be IBOR");
        ArgChecker.isTrue((boolean)iborLeg.getPaymentEvents().isEmpty(), (String)"PaymentEvent should be empty");
        ArrayList<NotionalExchange> paymentEvents = new ArrayList<NotionalExchange>();
        for (SwapPaymentPeriod paymentPeriod : iborLeg.getPaymentPeriods()) {
            ArgChecker.isTrue((boolean)(paymentPeriod instanceof RatePaymentPeriod), (String)"rate payment should be RatePaymentPeriod");
            RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)paymentPeriod;
            ArgChecker.isTrue((ratePaymentPeriod.getAccrualPeriods().size() == 1 ? 1 : 0) != 0, (String)"rate payment should not be compounding");
            RateAccrualPeriod rateAccrualPeriod = (RateAccrualPeriod)ratePaymentPeriod.getAccrualPeriods().get(0);
            CurrencyAmount notional = ratePaymentPeriod.getNotionalAmount();
            LocalDate paymentDate = ratePaymentPeriod.getPaymentDate();
            IborIndexObservation obs = ((IborRateComputation)rateAccrualPeriod.getRateComputation()).getObservation();
            IborIndex index = obs.getIndex();
            LocalDate fixingStartDate = obs.getEffectiveDate();
            double fixingYearFraction = obs.getYearFraction();
            double beta = (1.0 + fixingYearFraction * ratesProvider.iborIndexRates(index).rate(obs)) * ratesProvider.discountFactor(paymentPeriod.getCurrency(), paymentPeriod.getPaymentDate()) / ratesProvider.discountFactor(paymentPeriod.getCurrency(), fixingStartDate);
            double ycRatio = rateAccrualPeriod.getYearFraction() / fixingYearFraction;
            NotionalExchange payStart = NotionalExchange.of((CurrencyAmount)notional.multipliedBy(beta * ycRatio), (LocalDate)fixingStartDate);
            NotionalExchange payEnd = NotionalExchange.of((CurrencyAmount)notional.multipliedBy(-ycRatio), (LocalDate)paymentDate);
            paymentEvents.add(payStart);
            paymentEvents.add(payEnd);
        }
        ResolvedSwapLeg leg = ResolvedSwapLeg.builder().paymentEvents(paymentEvents).payReceive(PayReceive.RECEIVE).type(SwapLegType.OTHER).build();
        return leg;
    }

    public static ResolvedSwapLeg cashFlowEquivalentFixedLeg(ResolvedSwapLeg fixedLeg, RatesProvider ratesProvider) {
        ArgChecker.isTrue((boolean)fixedLeg.getType().equals((Object)SwapLegType.FIXED), (String)"Leg type should be FIXED");
        ArgChecker.isTrue((boolean)fixedLeg.getPaymentEvents().isEmpty(), (String)"PaymentEvent should be empty");
        ArrayList<NotionalExchange> paymentEvents = new ArrayList<NotionalExchange>();
        for (SwapPaymentPeriod paymentPeriod : fixedLeg.getPaymentPeriods()) {
            ArgChecker.isTrue((boolean)(paymentPeriod instanceof RatePaymentPeriod), (String)"rate payment should be RatePaymentPeriod");
            RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)paymentPeriod;
            ArgChecker.isTrue((ratePaymentPeriod.getAccrualPeriods().size() == 1 ? 1 : 0) != 0, (String)"rate payment should not be compounding");
            RateAccrualPeriod rateAccrualPeriod = (RateAccrualPeriod)ratePaymentPeriod.getAccrualPeriods().get(0);
            double factor = rateAccrualPeriod.getYearFraction() * ((FixedRateComputation)rateAccrualPeriod.getRateComputation()).getRate();
            CurrencyAmount notional = ratePaymentPeriod.getNotionalAmount().multipliedBy(factor);
            LocalDate paymentDate = ratePaymentPeriod.getPaymentDate();
            NotionalExchange pay = NotionalExchange.of((CurrencyAmount)notional, (LocalDate)paymentDate);
            paymentEvents.add(pay);
        }
        ResolvedSwapLeg leg = ResolvedSwapLeg.builder().paymentEvents(paymentEvents).payReceive(PayReceive.RECEIVE).type(SwapLegType.OTHER).build();
        return leg;
    }

    public static ResolvedSwapLeg cashFlowEquivalentOnLeg(ResolvedSwapLeg onLeg, RatesProvider multicurve) {
        Currency ccy = onLeg.getCurrency();
        ArgChecker.isTrue((boolean)onLeg.getType().equals((Object)SwapLegType.OVERNIGHT), (String)"Leg type should be OVERNIGHT");
        ArgChecker.isTrue((boolean)onLeg.getPaymentEvents().isEmpty(), (String)"PaymentEvent should be empty");
        ArrayList<NotionalExchange> paymentEvents = new ArrayList<NotionalExchange>();
        for (SwapPaymentPeriod paymentPeriod : onLeg.getPaymentPeriods()) {
            ArgChecker.isTrue((boolean)(paymentPeriod instanceof RatePaymentPeriod), (String)"rate payment should be RatePaymentPeriod");
            RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)paymentPeriod;
            ArgChecker.isTrue((ratePaymentPeriod.getAccrualPeriods().size() == 1 ? 1 : 0) != 0, (String)"rate payment should not be compounding");
            RateAccrualPeriod rateAccrualPeriod = (RateAccrualPeriod)ratePaymentPeriod.getAccrualPeriods().get(0);
            CurrencyAmount notional = ratePaymentPeriod.getNotionalAmount();
            RateComputation rateComputation = rateAccrualPeriod.getRateComputation();
            ArgChecker.isTrue((boolean)(rateComputation instanceof OvernightCompoundedRateComputation), (String)"RateComputation should be of type OvernightCompoundedRateComputation");
            OvernightCompoundedRateComputation onComputation = (OvernightCompoundedRateComputation)rateComputation;
            LocalDate startDate = rateAccrualPeriod.getStartDate();
            LocalDate endDate = rateAccrualPeriod.getEndDate();
            double computationAccrual = onComputation.getIndex().getDayCount().yearFraction(startDate, endDate);
            LocalDate paymentDate = ratePaymentPeriod.getPaymentDate();
            double paymentAccural = rateAccrualPeriod.getYearFraction();
            double payDateRatio = multicurve.discountFactor(ccy, paymentDate) / multicurve.discountFactor(ccy, endDate);
            NotionalExchange payStart = NotionalExchange.of((CurrencyAmount)notional.multipliedBy(payDateRatio * paymentAccural / computationAccrual), (LocalDate)startDate);
            double spread = rateAccrualPeriod.getSpread();
            NotionalExchange payEnd = NotionalExchange.of((CurrencyAmount)notional.multipliedBy(-paymentAccural / computationAccrual + spread * paymentAccural), (LocalDate)paymentDate);
            paymentEvents.add(payStart);
            paymentEvents.add(payEnd);
        }
        ResolvedSwapLeg leg = ResolvedSwapLeg.builder().paymentEvents(paymentEvents).payReceive(PayReceive.RECEIVE).type(SwapLegType.OTHER).build();
        return leg;
    }

    public static ImmutableMap<Payment, PointSensitivityBuilder> cashFlowEquivalentAndSensitivitySwap(ResolvedSwap swap, RatesProvider ratesProvider) {
        ImmutableMap.Builder cfEquivalentSensitivity = ImmutableMap.builder();
        for (ResolvedSwapLeg leg : swap.getLegs()) {
            if (leg.getType().equals((Object)SwapLegType.FIXED)) {
                cfEquivalentSensitivity.putAll(CashFlowEquivalentCalculator.cashFlowEquivalentAndSensitivityFixedLeg(leg, ratesProvider));
                continue;
            }
            if (leg.getType().equals((Object)SwapLegType.IBOR)) {
                cfEquivalentSensitivity.putAll(CashFlowEquivalentCalculator.cashFlowEquivalentAndSensitivityIborLeg(leg, ratesProvider));
                continue;
            }
            if (leg.getType().equals((Object)SwapLegType.OVERNIGHT)) {
                cfEquivalentSensitivity.putAll(CashFlowEquivalentCalculator.cashFlowEquivalentAndSensitivityOnLeg(leg, ratesProvider));
                continue;
            }
            throw new IllegalArgumentException("leg type must be FIXED, IBOR or OVERNIGHT");
        }
        return cfEquivalentSensitivity.build();
    }

    public static ImmutableMap<Payment, PointSensitivityBuilder> cashFlowEquivalentAndSensitivityIborLeg(ResolvedSwapLeg iborLeg, RatesProvider ratesProvider) {
        ArgChecker.isTrue((boolean)iborLeg.getType().equals((Object)SwapLegType.IBOR), (String)"Leg type should be IBOR");
        ArgChecker.isTrue((boolean)iborLeg.getPaymentEvents().isEmpty(), (String)"PaymentEvent should be empty");
        HashMap<Payment, PointSensitivityBuilder> res = new HashMap<Payment, PointSensitivityBuilder>();
        for (SwapPaymentPeriod paymentPeriod : iborLeg.getPaymentPeriods()) {
            ArgChecker.isTrue((boolean)(paymentPeriod instanceof RatePaymentPeriod), (String)"rate payment should be RatePaymentPeriod");
            RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)paymentPeriod;
            ArgChecker.isTrue((ratePaymentPeriod.getAccrualPeriods().size() == 1 ? 1 : 0) != 0, (String)"rate payment should not be compounding");
            RateAccrualPeriod rateAccrualPeriod = (RateAccrualPeriod)ratePaymentPeriod.getAccrualPeriods().get(0);
            CurrencyAmount notional = ratePaymentPeriod.getNotionalAmount();
            LocalDate paymentDate = ratePaymentPeriod.getPaymentDate();
            IborIndexObservation obs = ((IborRateComputation)rateAccrualPeriod.getRateComputation()).getObservation();
            IborIndex index = obs.getIndex();
            LocalDate fixingStartDate = obs.getEffectiveDate();
            double fixingYearFraction = obs.getYearFraction();
            double factorIndex = 1.0 + fixingYearFraction * ratesProvider.iborIndexRates(index).rate(obs);
            double dfPayment = ratesProvider.discountFactor(paymentPeriod.getCurrency(), paymentPeriod.getPaymentDate());
            double dfStart = ratesProvider.discountFactor(paymentPeriod.getCurrency(), fixingStartDate);
            double beta = factorIndex * dfPayment / dfStart;
            double ycRatio = rateAccrualPeriod.getYearFraction() / fixingYearFraction;
            Payment payStart = Payment.of((CurrencyAmount)notional.multipliedBy(beta * ycRatio), (LocalDate)fixingStartDate);
            Payment payEnd = Payment.of((CurrencyAmount)notional.multipliedBy(-ycRatio), (LocalDate)paymentDate);
            double factor = ycRatio * notional.getAmount() / dfStart;
            PointSensitivityBuilder factorIndexSensi = ratesProvider.iborIndexRates(index).ratePointSensitivity(obs).multipliedBy(fixingYearFraction * dfPayment * factor);
            ZeroRateSensitivity dfPaymentSensitivity = ratesProvider.discountFactors(paymentPeriod.getCurrency()).zeroRatePointSensitivity(paymentPeriod.getPaymentDate()).multipliedBy(factorIndex * factor);
            ZeroRateSensitivity dfStartSensitivity = ratesProvider.discountFactors(paymentPeriod.getCurrency()).zeroRatePointSensitivity(fixingStartDate).multipliedBy(-factorIndex * dfPayment * factor / dfStart);
            res.put(payStart, factorIndexSensi.combinedWith((PointSensitivityBuilder)dfPaymentSensitivity).combinedWith((PointSensitivityBuilder)dfStartSensitivity));
            res.put(payEnd, PointSensitivityBuilder.none());
        }
        return ImmutableMap.copyOf(res);
    }

    public static ImmutableMap<Payment, PointSensitivityBuilder> cashFlowEquivalentAndSensitivityFixedLeg(ResolvedSwapLeg fixedLeg, RatesProvider ratesProvider) {
        ArgChecker.isTrue((boolean)fixedLeg.getType().equals((Object)SwapLegType.FIXED), (String)"Leg type should be FIXED");
        ArgChecker.isTrue((boolean)fixedLeg.getPaymentEvents().isEmpty(), (String)"PaymentEvent should be empty");
        HashMap<Payment, PointSensitivityBuilder> res = new HashMap<Payment, PointSensitivityBuilder>();
        for (SwapPaymentPeriod paymentPeriod : fixedLeg.getPaymentPeriods()) {
            ArgChecker.isTrue((boolean)(paymentPeriod instanceof RatePaymentPeriod), (String)"rate payment should be RatePaymentPeriod");
            RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)paymentPeriod;
            ArgChecker.isTrue((ratePaymentPeriod.getAccrualPeriods().size() == 1 ? 1 : 0) != 0, (String)"rate payment should not be compounding");
            RateAccrualPeriod rateAccrualPeriod = (RateAccrualPeriod)ratePaymentPeriod.getAccrualPeriods().get(0);
            double factor = rateAccrualPeriod.getYearFraction() * ((FixedRateComputation)rateAccrualPeriod.getRateComputation()).getRate();
            CurrencyAmount notional = ratePaymentPeriod.getNotionalAmount().multipliedBy(factor);
            LocalDate paymentDate = ratePaymentPeriod.getPaymentDate();
            Payment pay = Payment.of((CurrencyAmount)notional, (LocalDate)paymentDate);
            res.put(pay, PointSensitivityBuilder.none());
        }
        return ImmutableMap.copyOf(res);
    }

    public static ImmutableMap<Payment, PointSensitivityBuilder> cashFlowEquivalentAndSensitivityOnLeg(ResolvedSwapLeg onLeg, RatesProvider multicurve) {
        Currency ccy = onLeg.getCurrency();
        DiscountFactors df = multicurve.discountFactors(ccy);
        ArgChecker.isTrue((boolean)onLeg.getType().equals((Object)SwapLegType.OVERNIGHT), (String)"Leg type should be OVERNIGHT");
        ArgChecker.isTrue((boolean)onLeg.getPaymentEvents().isEmpty(), (String)"PaymentEvent should be empty");
        HashMap<Payment, PointSensitivityBuilder> res = new HashMap<Payment, PointSensitivityBuilder>();
        for (SwapPaymentPeriod paymentPeriod : onLeg.getPaymentPeriods()) {
            ArgChecker.isTrue((boolean)(paymentPeriod instanceof RatePaymentPeriod), (String)"rate payment should be RatePaymentPeriod");
            RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)paymentPeriod;
            ArgChecker.isTrue((ratePaymentPeriod.getAccrualPeriods().size() == 1 ? 1 : 0) != 0, (String)"rate payment should not be compounding");
            RateAccrualPeriod rateAccrualPeriod = (RateAccrualPeriod)ratePaymentPeriod.getAccrualPeriods().get(0);
            CurrencyAmount notional = ratePaymentPeriod.getNotionalAmount();
            RateComputation rateComputation = rateAccrualPeriod.getRateComputation();
            ArgChecker.isTrue((boolean)(rateComputation instanceof OvernightCompoundedRateComputation), (String)"RateComputation should be of type OvernightCompoundedRateComputation");
            OvernightCompoundedRateComputation onComputation = (OvernightCompoundedRateComputation)rateComputation;
            LocalDate startDate = rateAccrualPeriod.getStartDate();
            LocalDate endDate = rateAccrualPeriod.getEndDate();
            double computationAccrual = onComputation.getIndex().getDayCount().yearFraction(startDate, endDate);
            LocalDate paymentDate = ratePaymentPeriod.getPaymentDate();
            double paymentAccural = rateAccrualPeriod.getYearFraction();
            double dfPay = df.discountFactor(paymentDate);
            double dfEnd = df.discountFactor(endDate);
            ZeroRateSensitivity dfPayDr = df.zeroRatePointSensitivity(paymentDate);
            ZeroRateSensitivity dfEndDr = df.zeroRatePointSensitivity(endDate);
            double payDateRatio = dfPay / dfEnd;
            PointSensitivityBuilder payDateRatioDr = dfPayDr.multipliedBy(1.0 / dfEnd).combinedWith(dfEndDr.multipliedBy(-dfPay / (dfEnd * dfEnd)));
            Payment payStart = Payment.of((CurrencyAmount)notional.multipliedBy(payDateRatio * paymentAccural / computationAccrual), (LocalDate)startDate);
            double spread = rateAccrualPeriod.getSpread();
            Payment payEnd = Payment.of((CurrencyAmount)notional.multipliedBy(-paymentAccural / computationAccrual + spread * paymentAccural), (LocalDate)paymentDate);
            res.put(payStart, payDateRatioDr.multipliedBy(notional.getAmount() * paymentAccural / computationAccrual));
            res.put(payEnd, PointSensitivityBuilder.none());
        }
        return ImmutableMap.copyOf(res);
    }

    public static List<Payment> normalize(ResolvedSwapLeg input) {
        ArrayList<Payment> cfe2 = new ArrayList<Payment>();
        for (SwapPaymentEvent cf : input.getPaymentEvents()) {
            ArgChecker.isTrue((boolean)(cf instanceof NotionalExchange), (String)"the swap leg must consist of NotionalExchange");
            cfe2.add(((NotionalExchange)cf).getPayment());
        }
        return CashFlowEquivalentCalculator.normalize(cfe2);
    }

    public static List<Payment> normalize(List<Payment> input) {
        ArrayList<Payment> sorted = new ArrayList<Payment>(input);
        Collections.sort(sorted, (a, b) -> (int)(a.getDate().toEpochDay() - b.getDate().toEpochDay()));
        Payment previous = (Payment)sorted.get(0);
        for (int i = 1; i < sorted.size(); ++i) {
            Payment current = (Payment)sorted.get(i);
            if (current.getDate().equals(previous.getDate()) && current.getCurrency().equals((Object)previous.getCurrency())) {
                current = Payment.of((CurrencyAmount)CurrencyAmount.of((Currency)current.getCurrency(), (double)(current.getAmount() + previous.getAmount())), (LocalDate)current.getDate());
                sorted.set(i - 1, current);
                sorted.remove(i);
                --i;
            }
            previous = current;
        }
        return sorted;
    }

    public static Map<Payment, PointSensitivityBuilder> normalize(Map<Payment, PointSensitivityBuilder> input) {
        HashMap<Payment, PointSensitivityBuilder> output = new HashMap<Payment, PointSensitivityBuilder>(input);
        ArrayList<Payment> sortedPayments = new ArrayList<Payment>(input.keySet());
        Collections.sort(sortedPayments, (a, b) -> (int)(a.getDate().toEpochDay() - b.getDate().toEpochDay()));
        Payment previousPayment = (Payment)sortedPayments.get(0);
        for (int i = 1; i < sortedPayments.size(); ++i) {
            Payment currentPayment = (Payment)sortedPayments.get(i);
            PointSensitivityBuilder currentSensi = input.get(currentPayment);
            if (currentPayment.getDate().equals(previousPayment.getDate()) && currentPayment.getCurrency().equals((Object)previousPayment.getCurrency())) {
                output.remove(currentPayment);
                currentPayment = Payment.of((CurrencyAmount)CurrencyAmount.of((Currency)currentPayment.getCurrency(), (double)(currentPayment.getAmount() + previousPayment.getAmount())), (LocalDate)currentPayment.getDate());
                currentSensi = currentSensi.combinedWith((PointSensitivityBuilder)output.get(previousPayment));
                output.remove(previousPayment);
                output.put(currentPayment, currentSensi);
                sortedPayments.set(i - 1, currentPayment);
                sortedPayments.remove(i);
                --i;
            }
            previousPayment = currentPayment;
        }
        return output;
    }

    private CashFlowEquivalentCalculator() {
    }
}

