/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.swap;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.fx.FxIndexRates;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.SwapPaymentEventPricer;
import com.opengamma.strata.product.swap.FxResetNotionalExchange;
import java.time.LocalDate;

public class DiscountingFxResetNotionalExchangePricer
implements SwapPaymentEventPricer<FxResetNotionalExchange> {
    public static final DiscountingFxResetNotionalExchangePricer DEFAULT = new DiscountingFxResetNotionalExchangePricer();

    @Override
    public double presentValue(FxResetNotionalExchange event, RatesProvider provider) {
        double df = provider.discountFactor(event.getCurrency(), event.getPaymentDate());
        return this.forecastValue(event, provider) * df;
    }

    @Override
    public PointSensitivityBuilder presentValueSensitivity(FxResetNotionalExchange event, RatesProvider provider) {
        DiscountFactors discountFactors = provider.discountFactors(event.getCurrency());
        ZeroRateSensitivity sensiDsc = discountFactors.zeroRatePointSensitivity(event.getPaymentDate());
        sensiDsc = sensiDsc.multipliedBy(this.forecastValue(event, provider));
        PointSensitivityBuilder sensiFx = this.forecastValueSensitivity(event, provider);
        sensiFx = sensiFx.multipliedBy(discountFactors.discountFactor(event.getPaymentDate()));
        return sensiDsc.combinedWith(sensiFx);
    }

    @Override
    public double forecastValue(FxResetNotionalExchange event, RatesProvider provider) {
        return event.getNotional() * this.fxRate(event, provider);
    }

    private double fxRate(FxResetNotionalExchange event, RatesProvider provider) {
        FxIndexRates rates = provider.fxIndexRates(event.getObservation().getIndex());
        return rates.rate(event.getObservation(), event.getReferenceCurrency());
    }

    @Override
    public PointSensitivityBuilder forecastValueSensitivity(FxResetNotionalExchange event, RatesProvider provider) {
        FxIndexRates rates = provider.fxIndexRates(event.getObservation().getIndex());
        return rates.ratePointSensitivity(event.getObservation(), event.getReferenceCurrency()).multipliedBy(event.getNotional());
    }

    @Override
    public void explainPresentValue(FxResetNotionalExchange event, RatesProvider provider, ExplainMapBuilder builder) {
        Currency currency = event.getCurrency();
        LocalDate paymentDate = event.getPaymentDate();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"FxResetNotionalExchange");
        builder.put(ExplainKey.PAYMENT_DATE, (Object)paymentDate);
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)currency);
        builder.put(ExplainKey.TRADE_NOTIONAL, (Object)event.getNotionalAmount());
        if (paymentDate.isBefore(provider.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            builder.addListEntry(ExplainKey.OBSERVATIONS, child -> {
                child.put(ExplainKey.ENTRY_TYPE, (Object)"FxObservation");
                child.put(ExplainKey.INDEX, (Object)event.getObservation().getIndex());
                child.put(ExplainKey.FIXING_DATE, (Object)event.getObservation().getFixingDate());
                child.put(ExplainKey.INDEX_VALUE, (Object)this.fxRate(event, provider));
            });
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)provider.discountFactor(currency, paymentDate));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.forecastValue(event, provider)));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.presentValue(event, provider)));
        }
    }

    @Override
    public MultiCurrencyAmount currencyExposure(FxResetNotionalExchange event, RatesProvider provider) {
        LocalDate fixingDate = event.getObservation().getFixingDate();
        FxIndexRates rates = provider.fxIndexRates(event.getObservation().getIndex());
        double df = provider.discountFactor(event.getCurrency(), event.getPaymentDate());
        if (!fixingDate.isAfter(provider.getValuationDate()) && rates.getFixings().get(fixingDate).isPresent()) {
            double fxRate = rates.rate(event.getObservation(), event.getReferenceCurrency());
            return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{CurrencyAmount.of((Currency)event.getCurrency(), (double)(event.getNotional() * df * fxRate))});
        }
        LocalDate maturityDate = event.getObservation().getMaturityDate();
        double fxRateSpotSensitivity = rates.getFxForwardRates().rateFxSpotSensitivity(event.getReferenceCurrency(), maturityDate);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{CurrencyAmount.of((Currency)event.getReferenceCurrency(), (double)(event.getNotional() * df * fxRateSpotSensitivity))});
    }

    @Override
    public double currentCash(FxResetNotionalExchange event, RatesProvider provider) {
        if (provider.getValuationDate().isEqual(event.getPaymentDate())) {
            return this.forecastValue(event, provider);
        }
        return 0.0;
    }
}

