/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.swap;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.SwapPaymentPeriodPricer;
import com.opengamma.strata.product.swap.KnownAmountSwapPaymentPeriod;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class DiscountingKnownAmountPaymentPeriodPricer
implements SwapPaymentPeriodPricer<KnownAmountSwapPaymentPeriod> {
    public static final DiscountingKnownAmountPaymentPeriodPricer DEFAULT = new DiscountingKnownAmountPaymentPeriodPricer(DiscountingPaymentPricer.DEFAULT);
    private final DiscountingPaymentPricer paymentPricer;

    public DiscountingKnownAmountPaymentPeriodPricer(DiscountingPaymentPricer paymentPricer) {
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    @Override
    public double presentValue(KnownAmountSwapPaymentPeriod period, RatesProvider provider) {
        return this.paymentPricer.presentValueAmount(period.getPayment(), provider);
    }

    @Override
    public double forecastValue(KnownAmountSwapPaymentPeriod period, RatesProvider provider) {
        return this.paymentPricer.forecastValueAmount(period.getPayment(), provider);
    }

    @Override
    public double accruedInterest(KnownAmountSwapPaymentPeriod period, RatesProvider provider) {
        LocalDate valDate = provider.getValuationDate();
        if (valDate.compareTo(period.getStartDate()) <= 0 || valDate.compareTo(period.getEndDate()) > 0) {
            return 0.0;
        }
        double fv = this.forecastValue(period, provider);
        double totalDays = period.getStartDate().until(period.getEndDate(), ChronoUnit.DAYS);
        double partialDays = period.getStartDate().until(valDate, ChronoUnit.DAYS);
        return fv * (partialDays / totalDays);
    }

    @Override
    public double pvbp(KnownAmountSwapPaymentPeriod period, RatesProvider provider) {
        throw new UnsupportedOperationException("Unable to calculate PVBP for KnownAmountPaymentPeriod");
    }

    @Override
    public PointSensitivityBuilder presentValueSensitivity(KnownAmountSwapPaymentPeriod period, RatesProvider provider) {
        return this.paymentPricer.presentValueSensitivity(period.getPayment(), provider);
    }

    @Override
    public PointSensitivityBuilder forecastValueSensitivity(KnownAmountSwapPaymentPeriod period, RatesProvider provider) {
        return PointSensitivityBuilder.none();
    }

    @Override
    public PointSensitivityBuilder pvbpSensitivity(KnownAmountSwapPaymentPeriod period, RatesProvider provider) {
        throw new UnsupportedOperationException("Unable to calculate PVBP for KnownAmountPaymentPeriod");
    }

    @Override
    public void explainPresentValue(KnownAmountSwapPaymentPeriod period, RatesProvider provider, ExplainMapBuilder builder) {
        Currency currency = period.getCurrency();
        LocalDate paymentDate = period.getPaymentDate();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"KnownAmountPaymentPeriod");
        builder.put(ExplainKey.PAYMENT_DATE, (Object)paymentDate);
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)currency);
        builder.put(ExplainKey.START_DATE, (Object)period.getStartDate());
        builder.put(ExplainKey.UNADJUSTED_START_DATE, (Object)period.getUnadjustedStartDate());
        builder.put(ExplainKey.END_DATE, (Object)period.getEndDate());
        builder.put(ExplainKey.UNADJUSTED_END_DATE, (Object)period.getUnadjustedEndDate());
        builder.put(ExplainKey.DAYS, (Object)((int)ChronoUnit.DAYS.between(period.getStartDate(), period.getEndDate())));
        if (paymentDate.isBefore(provider.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)provider.discountFactor(currency, paymentDate));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.forecastValue(period, provider)));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.presentValue(period, provider)));
        }
    }

    @Override
    public MultiCurrencyAmount currencyExposure(KnownAmountSwapPaymentPeriod period, RatesProvider provider) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{CurrencyAmount.of((Currency)period.getCurrency(), (double)this.presentValue(period, provider))});
    }

    @Override
    public double currentCash(KnownAmountSwapPaymentPeriod period, RatesProvider provider) {
        if (provider.getValuationDate().isEqual(period.getPaymentDate())) {
            return this.forecastValue(period, provider);
        }
        return 0.0;
    }
}

