/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.swap;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.SwapPaymentEventPricer;
import com.opengamma.strata.product.swap.NotionalExchange;
import java.time.LocalDate;

public class DiscountingNotionalExchangePricer
implements SwapPaymentEventPricer<NotionalExchange> {
    public static final DiscountingNotionalExchangePricer DEFAULT = new DiscountingNotionalExchangePricer(DiscountingPaymentPricer.DEFAULT);
    private final DiscountingPaymentPricer paymentPricer;

    public DiscountingNotionalExchangePricer(DiscountingPaymentPricer paymentPricer) {
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    @Override
    public double presentValue(NotionalExchange event, RatesProvider provider) {
        return this.paymentPricer.presentValueAmount(event.getPayment(), provider);
    }

    @Override
    public PointSensitivityBuilder presentValueSensitivity(NotionalExchange event, RatesProvider provider) {
        return this.paymentPricer.presentValueSensitivity(event.getPayment(), provider);
    }

    @Override
    public double forecastValue(NotionalExchange event, RatesProvider provider) {
        return this.paymentPricer.forecastValueAmount(event.getPayment(), provider);
    }

    @Override
    public PointSensitivityBuilder forecastValueSensitivity(NotionalExchange event, RatesProvider provider) {
        return PointSensitivityBuilder.none();
    }

    @Override
    public void explainPresentValue(NotionalExchange event, RatesProvider provider, ExplainMapBuilder builder) {
        Currency currency = event.getCurrency();
        LocalDate paymentDate = event.getPaymentDate();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"NotionalExchange");
        builder.put(ExplainKey.PAYMENT_DATE, (Object)paymentDate);
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)currency);
        builder.put(ExplainKey.TRADE_NOTIONAL, (Object)event.getPaymentAmount());
        if (paymentDate.isBefore(provider.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)provider.discountFactor(currency, paymentDate));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.forecastValue(event, provider)));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.presentValue(event, provider)));
        }
    }

    @Override
    public MultiCurrencyAmount currencyExposure(NotionalExchange event, RatesProvider provider) {
        return this.paymentPricer.currencyExposure(event.getPayment(), provider);
    }

    @Override
    public double currentCash(NotionalExchange event, RatesProvider provider) {
        return this.paymentPricer.currentCash(event.getPayment(), provider).getAmount();
    }
}

