/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.tree;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.MathUtils;
import com.opengamma.strata.pricer.impl.tree.LatticeSpecification;

public final class CoxRossRubinsteinLatticeSpecification
implements LatticeSpecification {
    @Override
    public DoubleArray getParametersTrinomial(double volatility, double interestRate, double dt) {
        double dx = volatility * Math.sqrt(2.0 * dt);
        double upFactor = Math.exp(dx);
        double downFactor = Math.exp(-dx);
        double factor1 = Math.exp(0.5 * interestRate * dt);
        double factor2 = Math.exp(0.5 * dx);
        double factor3 = Math.exp(-0.5 * dx);
        double upProbability = MathUtils.pow2((double)((factor1 - factor3) / (factor3 - factor2)));
        double downProbability = MathUtils.pow2((double)((factor2 - factor1) / (factor3 - factor2)));
        double middleProbability = 1.0 - upProbability - downProbability;
        return DoubleArray.of((double)upFactor, (double)1.0, (double)downFactor, (double)upProbability, (double)middleProbability, (double)downProbability);
    }
}

