/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.tree;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.fxopt.RecombiningTrinomialTreeData;
import com.opengamma.strata.pricer.impl.tree.LatticeSpecification;
import com.opengamma.strata.pricer.impl.tree.OptionFunction;

public class TrinomialTree {
    public double optionPrice(OptionFunction function, LatticeSpecification lattice, double spot, double volatility, double interestRate, double dividendRate) {
        int nSteps = function.getNumberOfSteps();
        double timeToExpiry = function.getTimeToExpiry();
        double dt = timeToExpiry / (double)nSteps;
        double discount = Math.exp(-interestRate * dt);
        DoubleArray params = lattice.getParametersTrinomial(volatility, interestRate - dividendRate, dt);
        double middleFactor = params.get(1);
        double downFactor = params.get(2);
        double upProbability = params.get(3);
        double midProbability = params.get(4);
        double downProbability = params.get(5);
        ArgChecker.isTrue((upProbability > 0.0 ? 1 : 0) != 0, (String)"upProbability should be greater than 0");
        ArgChecker.isTrue((upProbability < 1.0 ? 1 : 0) != 0, (String)"upProbability should be smaller than 1");
        ArgChecker.isTrue((midProbability > 0.0 ? 1 : 0) != 0, (String)"midProbability should be greater than 0");
        ArgChecker.isTrue((midProbability < 1.0 ? 1 : 0) != 0, (String)"midProbability should be smaller than 1");
        ArgChecker.isTrue((downProbability > 0.0 ? 1 : 0) != 0, (String)"downProbability should be greater than 0");
        DoubleArray values = function.getPayoffAtExpiryTrinomial(spot, downFactor, middleFactor);
        for (int i = nSteps - 1; i > -1; --i) {
            values = function.getNextOptionValues(discount, upProbability, midProbability, downProbability, values, spot, downFactor, middleFactor, i);
        }
        return values.get(0);
    }

    public double optionPrice(OptionFunction function, RecombiningTrinomialTreeData data) {
        int nSteps = data.getNumberOfSteps();
        ArgChecker.isTrue((nSteps == function.getNumberOfSteps() ? 1 : 0) != 0, (String)"mismatch in number of steps");
        DoubleArray values = function.getPayoffAtExpiryTrinomial(data.getStateValueAtLayer(nSteps));
        for (int i = nSteps - 1; i > -1; --i) {
            values = function.getNextOptionValues(data.getDiscountFactorAtLayer(i), data.getProbabilityAtLayer(i), data.getStateValueAtLayer(i), values, i);
        }
        return values.get(0);
    }

    public ValueDerivatives optionPriceAdjoint(OptionFunction function, RecombiningTrinomialTreeData data) {
        int nSteps = data.getNumberOfSteps();
        ArgChecker.isTrue((nSteps == function.getNumberOfSteps() ? 1 : 0) != 0, (String)"mismatch in number of steps");
        DoubleArray values = function.getPayoffAtExpiryTrinomial(data.getStateValueAtLayer(nSteps));
        double delta = 0.0;
        for (int i = nSteps - 1; i > -1; --i) {
            values = function.getNextOptionValues(data.getDiscountFactorAtLayer(i), data.getProbabilityAtLayer(i), data.getStateValueAtLayer(i), values, i);
            if (i != 1) continue;
            DoubleArray stateValue = data.getStateValueAtLayer(1);
            double d1 = (values.get(2) - values.get(1)) / (stateValue.get(2) - stateValue.get(1));
            double d2 = (values.get(1) - values.get(0)) / (stateValue.get(1) - stateValue.get(0));
            delta = 0.5 * (d1 + d2);
        }
        return ValueDerivatives.of((double)values.get(0), (DoubleArray)DoubleArray.of((double)delta));
    }
}

