/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.volatility.smile;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.impl.volatility.smile.SmileModelData;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class SabrFormulaData
implements SmileModelData,
ImmutableBean,
Serializable {
    private static final int NUM_PARAMETERS = 4;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray parameters;
    private static final TypedMetaBean<SabrFormulaData> META_BEAN = LightMetaBean.of(SabrFormulaData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"parameters"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static SabrFormulaData of(double alpha, double beta, double rho, double nu) {
        return new SabrFormulaData(DoubleArray.of((double)alpha, (double)beta, (double)rho, (double)nu));
    }

    public static SabrFormulaData of(double[] parameters) {
        ArgChecker.notNull((Object)parameters, (String)"parameters");
        ArgChecker.isTrue((parameters.length == 4 ? 1 : 0) != 0, (String)"the number of parameters should be 4");
        return new SabrFormulaData(DoubleArray.copyOf((double[])parameters));
    }

    @ImmutableValidator
    private void validate() {
        for (int i = 0; i < 4; ++i) {
            ArgChecker.isTrue((boolean)this.isAllowed(i, this.parameters.get(i)), (String)"the {}-th parameter is not allowed", (long)i);
        }
    }

    public double getAlpha() {
        return this.parameters.get(0);
    }

    public double getBeta() {
        return this.parameters.get(1);
    }

    public double getRho() {
        return this.parameters.get(2);
    }

    public double getNu() {
        return this.parameters.get(3);
    }

    public SabrFormulaData withAlpha(double alpha) {
        return SabrFormulaData.of(alpha, this.getBeta(), this.getRho(), this.getNu());
    }

    public SabrFormulaData withBeta(double beta) {
        return SabrFormulaData.of(this.getAlpha(), beta, this.getRho(), this.getNu());
    }

    public SabrFormulaData withRho(double rho) {
        return SabrFormulaData.of(this.getAlpha(), this.getBeta(), rho, this.getNu());
    }

    public SabrFormulaData withNu(double nu) {
        return SabrFormulaData.of(this.getAlpha(), this.getBeta(), this.getRho(), nu);
    }

    @Override
    public int getNumberOfParameters() {
        return 4;
    }

    @Override
    public double getParameter(int index) {
        ArgChecker.inRangeExclusive((int)index, (int)-1, (int)4, (String)"index");
        return this.parameters.get(index);
    }

    @Override
    public boolean isAllowed(int index, double value) {
        switch (index) {
            case 0: 
            case 1: 
            case 3: {
                return value >= 0.0;
            }
            case 2: {
                return value >= -1.0 && value <= 1.0;
            }
        }
        throw new IllegalArgumentException("index " + index + " outside range");
    }

    @Override
    public SabrFormulaData with(int index, double value) {
        ArgChecker.inRange((int)index, (int)0, (int)4, (String)"index");
        double[] paramsCp = this.parameters.toArray();
        paramsCp[index] = value;
        return SabrFormulaData.of(paramsCp);
    }

    public static TypedMetaBean<SabrFormulaData> meta() {
        return META_BEAN;
    }

    private SabrFormulaData(DoubleArray parameters) {
        JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
        this.parameters = parameters;
        this.validate();
    }

    public TypedMetaBean<SabrFormulaData> metaBean() {
        return META_BEAN;
    }

    public DoubleArray getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SabrFormulaData other = (SabrFormulaData)obj;
            return JodaBeanUtils.equal((Object)this.parameters, (Object)other.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.parameters);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("SabrFormulaData{");
        buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

