/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.volatility.smile;

import com.google.common.math.DoubleMath;
import com.google.common.primitives.Doubles;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.math.MathUtils;
import com.opengamma.strata.pricer.impl.volatility.smile.SabrFormulaData;
import com.opengamma.strata.pricer.impl.volatility.smile.VolatilityFunctionProvider;
import com.opengamma.strata.pricer.model.SabrVolatilityFormula;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.impl.light.LightMetaBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BeanDefinition(style="light")
public final class SabrHaganVolatilityFunctionProvider
extends VolatilityFunctionProvider<SabrFormulaData>
implements SabrVolatilityFormula,
ImmutableBean,
Serializable {
    public static final SabrHaganVolatilityFunctionProvider DEFAULT = new SabrHaganVolatilityFunctionProvider();
    private static final Logger log = LoggerFactory.getLogger(SabrHaganVolatilityFunctionProvider.class);
    private static final double CUTOFF_MONEYNESS = 1.0E-12;
    private static final double SMALL_Z = 1.0E-6;
    private static final double LARGE_NEG_Z = -1000000.0;
    private static final double LARGE_POS_Z = 1.0E8;
    private static final double BETA_EPS = 1.0E-8;
    private static final double RHO_EPS = 1.0E-5;
    private static final double RHO_EPS_NEGATIVE = 1.0E-8;
    private static final double ATM_EPS = 1.0E-7;
    private static final double MIN_VOL = 1.0E-6;
    private static final TypedMetaBean<SabrHaganVolatilityFunctionProvider> META_BEAN = LightMetaBean.of(SabrHaganVolatilityFunctionProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final long serialVersionUID = 1L;

    @Override
    public ValueType getVolatilityType() {
        return ValueType.BLACK_VOLATILITY;
    }

    @Override
    public double volatility(double forward, double strike, double timeToExpiry, SabrFormulaData data) {
        ArgChecker.notNull((Object)data, (String)"data");
        double alpha = data.getAlpha();
        double beta = data.getBeta();
        double rho = data.getRho();
        double nu = data.getNu();
        return this.volatility(forward, strike, timeToExpiry, alpha, beta, rho, nu);
    }

    @Override
    public double volatility(double forward, double strike, double timeToExpiry, double alpha, double beta, double rho, double nu) {
        double vol;
        double k;
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"forward must be greater than zero");
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"strike must be greater than zero");
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"timeToExpiry must be greater than zero");
        if (alpha == 0.0) {
            return 0.0;
        }
        double cutoff = forward * 1.0E-12;
        if (strike < cutoff) {
            log.info("Given strike of {} is less than cutoff at {}, therefore the strike is taken as {}", new Object[]{strike, cutoff, cutoff});
            k = cutoff;
        } else {
            k = strike;
        }
        double beta1 = 1.0 - beta;
        if (DoubleMath.fuzzyEquals((double)forward, (double)k, (double)1.0E-7)) {
            double f1 = Math.pow(forward, beta1);
            vol = alpha * (1.0 + timeToExpiry * (beta1 * beta1 * alpha * alpha / 24.0 / f1 / f1 + rho * alpha * beta * nu / 4.0 / f1 + nu * nu * (2.0 - 3.0 * rho * rho) / 24.0)) / f1;
        } else if (MathUtils.nearZero((double)beta, (double)1.0E-8)) {
            double ln = Math.log(forward / k);
            double z = nu * Math.sqrt(forward * k) * ln / alpha;
            double zOverChi = this.getZOverChi(rho, z);
            vol = alpha * ln * zOverChi * (1.0 + timeToExpiry * (alpha * alpha / forward / k + nu * nu * (2.0 - 3.0 * rho * rho)) / 24.0) / (forward - k);
        } else if (MathUtils.nearOne((double)beta, (double)1.0E-8)) {
            double ln = Math.log(forward / k);
            double z = nu * ln / alpha;
            double zOverChi = this.getZOverChi(rho, z);
            vol = alpha * zOverChi * (1.0 + timeToExpiry * (rho * alpha * nu / 4.0 + nu * nu * (2.0 - 3.0 * rho * rho) / 24.0));
        } else {
            double ln = Math.log(forward / k);
            double f1 = Math.pow(forward * k, beta1);
            double f1Sqrt = Math.sqrt(f1);
            double lnBetaSq = MathUtils.pow2((double)(beta1 * ln));
            double z = nu * f1Sqrt * ln / alpha;
            double zOverChi = this.getZOverChi(rho, z);
            double first = alpha / (f1Sqrt * (1.0 + lnBetaSq / 24.0 + lnBetaSq * lnBetaSq / 1920.0));
            double second = zOverChi;
            double third = 1.0 + timeToExpiry * (beta1 * beta1 * alpha * alpha / 24.0 / f1 + rho * nu * beta * alpha / 4.0 / f1Sqrt + nu * nu * (2.0 - 3.0 * rho * rho) / 24.0);
            vol = first * second * third;
        }
        return Math.max(1.0E-6, vol);
    }

    @Override
    public ValueDerivatives volatilityAdjoint(double forward, double strike, double timeToExpiry, SabrFormulaData data) {
        ArgChecker.notNull((Object)data, (String)"data");
        double alpha = data.getAlpha();
        double beta = data.getBeta();
        double rho = data.getRho();
        double nu = data.getNu();
        return this.volatilityAdjoint(forward, strike, timeToExpiry, alpha, beta, rho, nu);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ValueDerivatives volatilityAdjoint(double forward, double strike, double timeToExpiry, double alpha, double beta, double rho, double nu) {
        double rhoBar;
        double zBar;
        double rzxz;
        ArgChecker.isTrue((forward > 0.0 ? 1 : 0) != 0, (String)"forward must be greater than zero");
        ArgChecker.isTrue((strike >= 0.0 ? 1 : 0) != 0, (String)"strike must be greater than zero");
        ArgChecker.isTrue((timeToExpiry >= 0.0 ? 1 : 0) != 0, (String)"timeToExpiry must be greater than zero");
        double cutoff = forward * 1.0E-12;
        double k = strike;
        if (k < cutoff) {
            log.info("Given strike of {} is less than cutoff at {}, therefore the strike is taken as {}", new Object[]{k, cutoff, cutoff});
            k = cutoff;
        }
        double betaStar = 1.0 - beta;
        double rhoRhoNuFactor = (2.0 - 3.0 * rho * rho) * nu / 24.0;
        if (alpha == 0.0) {
            double alphaBar = DoubleMath.fuzzyEquals((double)forward, (double)k, (double)1.0E-7) ? (1.0 + rhoRhoNuFactor * nu * timeToExpiry) / Math.pow(forward, betaStar) : 1.0E7;
            return ValueDerivatives.of((double)0.0, (DoubleArray)DoubleArray.of((double)0.0, (double)0.0, (double)alphaBar, (double)0.0, (double)0.0, (double)0.0));
        }
        double sfK = Math.pow(forward * k, betaStar / 2.0);
        double lnrfK = Math.log(forward / k);
        double z = nu / alpha * sfK * lnrfK;
        double betaStarPow2 = betaStar * betaStar;
        double betaStarPow4Div1920 = betaStarPow2 * betaStarPow2 / 1920.0;
        double lnrfKPow2 = lnrfK * lnrfK;
        double lnrfKPow4 = lnrfKPow2 * lnrfKPow2;
        double sfKMul4 = 4.0 * sfK;
        double sfKPow2 = sfK * sfK;
        double rhoStar = 1.0 - rho;
        boolean rhoNearZero = MathUtils.nearZero((double)rhoStar, (double)1.0E-5);
        boolean zNearZero = MathUtils.nearZero((double)z, (double)1.0E-6);
        double xz = 0.0;
        double zRhoFactorSqrtFactor = rhoStar;
        double zRhoFactorInvSqrt = 1.0;
        if (zNearZero) {
            rzxz = 1.0 - 0.5 * z * rho;
        } else if (rhoNearZero) {
            if (!(z < 1.0)) throw new IllegalArgumentException("can't handle z>=1, rho=0");
            xz = -Math.log(1.0 - z);
            rzxz = z / xz;
        } else {
            double zRhoFactorSqrt = Math.sqrt(1.0 - 2.0 * rho * z + z * z);
            zRhoFactorSqrtFactor = zRhoFactorSqrt + z - rho;
            zRhoFactorInvSqrt = 1.0 / zRhoFactorSqrt;
            double arg = z < -1000000.0 ? (rho * rho - 1.0) / 2.0 / z : (z > 1.0E8 ? 2.0 * (z - rho) : zRhoFactorSqrtFactor);
            if (arg <= 0.0) {
                rzxz = 0.0;
            } else {
                xz = Math.log(arg / (1.0 - rho));
                rzxz = z / xz;
            }
        }
        double sf1 = sfK * (1.0 + betaStarPow2 / 24.0 * lnrfKPow2 + betaStarPow4Div1920 * lnrfKPow4);
        double sf2 = 1.0 + (MathUtils.pow2((double)(betaStar * alpha / sfK)) / 24.0 + rho * beta * nu * alpha / sfKMul4 + rhoRhoNuFactor * nu) * timeToExpiry;
        double volatility = Math.max(1.0E-6, alpha / sf1 * rzxz * sf2);
        double vBar = 1.0;
        double sf2Bar = alpha / sf1 * rzxz * vBar;
        double sf1Bar = -alpha / (sf1 * sf1) * rzxz * sf2 * vBar;
        double rzxzBar = alpha / sf1 * sf2 * vBar;
        double xzBar = 0.0;
        if (zNearZero) {
            zBar = -rho / 2.0 * rzxzBar;
        } else if (rhoNearZero) {
            if (!(z < 1.0)) throw new IllegalArgumentException("can't handle z>=1, rho=0");
            xzBar = -z / (xz * xz) * rzxzBar;
            zBar = 1.0 / xz * rzxzBar + 1.0 / (1.0 - z) * xzBar;
        } else if (z < -1000000.0) {
            zBar = 1.0 / xz * rzxzBar + xzBar / (xz * xz) * rzxzBar;
        } else if (z > 1.0E8) {
            zBar = 1.0 / xz * rzxzBar - xzBar / (xz * xz) * rzxzBar;
        } else {
            xzBar = -z / (xz * xz) * rzxzBar;
            zBar = 1.0 / xz * rzxzBar + 1.0 / zRhoFactorSqrtFactor * (0.5 * zRhoFactorInvSqrt * (-2.0 * rho + 2.0 * z) + 1.0) * xzBar;
        }
        double lnrfKBar = sfK * (betaStarPow2 / 12.0 * lnrfK + betaStarPow4Div1920 * 4.0 * lnrfKPow2 * lnrfK) * sf1Bar + nu / alpha * sfK * zBar;
        double sfKBar = nu / alpha * lnrfK * zBar + sf1 / sfK * sf1Bar - (MathUtils.pow2((double)(betaStar * alpha)) / (sfKPow2 * sfK) / 12.0 + rho * beta * nu * alpha * 0.25 / sfKPow2) * timeToExpiry * sf2Bar;
        double strikeBar = -1.0 / k * lnrfKBar + betaStar * sfK / (2.0 * k) * sfKBar;
        double forwardBar = 1.0 / forward * lnrfKBar + betaStar * sfK / (2.0 * forward) * sfKBar;
        double nuBar = 1.0 / alpha * sfK * lnrfK * zBar + (rho * beta * alpha / sfKMul4 + rhoRhoNuFactor * 2.0) * timeToExpiry * sf2Bar;
        if (Math.abs(forward - k) < 1.0E-7) {
            rhoBar = -z / 2.0 * rzxzBar;
        } else if (rhoNearZero) {
            if (z >= 1.0) {
                rhoBar = rhoStar == 0.0 ? Double.NEGATIVE_INFINITY : xzBar * (1.0 / rhoStar + (0.5 - z) / (z - 1.0) / (z - 1.0));
            } else {
                double zStar = 1.0 - z;
                double zDivZStar = z / zStar;
                rhoBar = (0.5 * MathUtils.pow2((double)zDivZStar) + 0.25 * (z - 4.0) * MathUtils.pow3((double)zDivZStar) / zStar * rhoStar) * xzBar;
            }
        } else {
            rhoBar = (1.0 / zRhoFactorSqrtFactor * (-zRhoFactorInvSqrt * z - 1.0) + 1.0 / rhoStar) * xzBar;
        }
        double alphaPow2 = alpha * alpha;
        double alphaBar = -nu / alphaPow2 * sfK * lnrfK * zBar + (betaStar * alpha / sfK * (betaStar / sfK) / 12.0 + rho * beta * nu / sfKMul4) * timeToExpiry * sf2Bar + 1.0 / sf1 * rzxz * sf2 * vBar;
        double betaBar = -0.5 * Math.log(forward * k) * sfK * sfKBar - sfK * (betaStar / 12.0 * lnrfKPow2 + MathUtils.pow3((double)betaStar) / 480.0 * lnrfKPow4) * sf1Bar + (-betaStar * alphaPow2 / (sfKPow2 * 12.0) + rho * nu * alpha / sfKMul4) * timeToExpiry * sf2Bar;
        return ValueDerivatives.of((double)volatility, (DoubleArray)DoubleArray.of((double)forwardBar, (double)strikeBar, (double)alphaBar, (double)betaBar, (double)(rhoBar += (beta * nu * alpha / sfKMul4 - rho * nu * nu * 0.25) * timeToExpiry * sf2Bar), (double)nuBar));
    }

    @Override
    public double volatilityAdjoint2(double forward, double strike, double timeToExpiry, SabrFormulaData data, double[] volatilityD, double[][] volatilityD2) {
        double k = Math.max(strike, 1.0E-6);
        double alpha = data.getAlpha();
        double beta = data.getBeta();
        double rho = data.getRho();
        double nu = data.getNu();
        double h0 = (1.0 - beta) / 2.0;
        double h1 = forward * k;
        double h1h0 = Math.pow(h1, h0);
        double h12 = h1h0 * h1h0;
        double h2 = Math.log(forward / k);
        double h22 = h2 * h2;
        double h23 = h22 * h2;
        double h24 = h23 * h2;
        double f1 = h1h0 * (1.0 + h0 * h0 / 6.0 * (h22 + h0 * h0 / 20.0 * h24));
        double f2 = nu / alpha * h1h0 * h2;
        double f3 = h0 * h0 / 6.0 * alpha * alpha / h12 + rho * beta * nu * alpha / 4.0 / h1h0 + (2.0 - 3.0 * rho * rho) / 24.0 * nu * nu;
        double sqrtf2 = Math.sqrt(1.0 - 2.0 * rho * f2 + f2 * f2);
        double f2x = 0.0;
        double x = 0.0;
        double xp = 0.0;
        double xpp = 0.0;
        if (MathUtils.nearZero((double)f2, (double)1.0E-6)) {
            f2x = 1.0 - 0.5 * f2 * rho;
        } else {
            x = MathUtils.nearOne((double)rho, (double)1.0E-5) ? (f2 < 1.0 ? -Math.log(1.0 - f2) - 0.5 * MathUtils.pow2((double)(f2 / (f2 - 1.0))) * (1.0 - rho) : Math.log(2.0 * f2 - 2.0) - Math.log(1.0 - rho)) : Math.log((sqrtf2 + f2 - rho) / (1.0 - rho));
            xp = 1.0 / sqrtf2;
            xpp = (rho - f2) / MathUtils.pow3((double)sqrtf2);
            f2x = f2 / x;
        }
        double sigma = Math.max(1.0E-6, alpha / f1 * f2x * (1.0 + f3 * timeToExpiry));
        double h0Dbeta = -0.5;
        double sigmaDf1 = -sigma / f1;
        double sigmaDf2 = 0.0;
        sigmaDf2 = MathUtils.nearZero((double)f2, (double)1.0E-6) ? alpha / f1 * (1.0 + f3 * timeToExpiry) * -0.5 * rho : alpha / f1 * (1.0 + f3 * timeToExpiry) * (1.0 / x - f2 * xp / (x * x));
        double sigmaDf3 = alpha / f1 * f2x * timeToExpiry;
        double sigmaDf4 = f2x / f1 * (1.0 + f3 * timeToExpiry);
        double sigmaDx = -alpha / f1 * f2 / (x * x) * (1.0 + f3 * timeToExpiry);
        double[][] sigmaD2ff = new double[3][3];
        sigmaD2ff[0][0] = -sigmaDf1 / f1 + sigma / (f1 * f1);
        sigmaD2ff[0][1] = -sigmaDf2 / f1;
        sigmaD2ff[0][2] = -sigmaDf3 / f1;
        if (MathUtils.nearZero((double)f2, (double)1.0E-6)) {
            sigmaD2ff[1][2] = alpha / f1 * -0.5 * rho * timeToExpiry;
        } else {
            sigmaD2ff[1][1] = alpha / f1 * (1.0 + f3 * timeToExpiry) * (-2.0 * xp / (x * x) - f2 * xpp / (x * x) + 2.0 * f2 * xp * xp / (x * x * x));
            sigmaD2ff[1][2] = alpha / f1 * timeToExpiry * (1.0 / x - f2 * xp / (x * x));
        }
        sigmaD2ff[2][2] = 0.0;
        double[] f1Dh = new double[3];
        double[] f2Dh = new double[3];
        double[] f3Dh = new double[3];
        f1Dh[0] = h1h0 * (h0 * (h22 / 3.0 + h0 * h0 / 40.0 * h24)) + Math.log(h1) * f1;
        f1Dh[1] = h0 * f1 / h1;
        f1Dh[2] = h1h0 * (h0 * h0 / 6.0 * (2.0 * h2 + h0 * h0 / 5.0 * h23));
        f2Dh[0] = Math.log(h1) * f2;
        f2Dh[1] = h0 * f2 / h1;
        f2Dh[2] = nu / alpha * h1h0;
        f3Dh[0] = h0 / 3.0 * alpha * alpha / h12 - 2.0 * h0 * h0 / 6.0 * alpha * alpha / h12 * Math.log(h1) - rho * beta * nu * alpha / 4.0 / h1h0 * Math.log(h1);
        f3Dh[1] = -2.0 * h0 * h0 / 6.0 * alpha * alpha / h12 * h0 / h1 - rho * beta * nu * alpha / 4.0 / h1h0 * h0 / h1;
        f3Dh[2] = 0.0;
        double[] f1Dp = new double[4];
        double[] f2Dp = new double[4];
        double[] f3Dp = new double[4];
        double[] f4Dp = new double[4];
        f1Dp[0] = 0.0;
        f1Dp[1] = f1Dh[0] * h0Dbeta;
        f1Dp[2] = 0.0;
        f1Dp[3] = 0.0;
        f2Dp[0] = -f2 / alpha;
        f2Dp[1] = f2Dh[0] * h0Dbeta;
        f2Dp[2] = 0.0;
        f2Dp[3] = h1h0 * h2 / alpha;
        f3Dp[0] = h0 * h0 / 3.0 * alpha / h12 + rho * beta * nu / 4.0 / h1h0;
        f3Dp[1] = rho * nu * alpha / 4.0 / h1h0 + f3Dh[0] * h0Dbeta;
        f3Dp[2] = beta * nu * alpha / 4.0 / h1h0 - rho / 4.0 * nu * nu;
        f3Dp[3] = rho * beta * alpha / 4.0 / h1h0 + (2.0 - 3.0 * rho * rho) / 12.0 * nu;
        f4Dp[0] = 1.0;
        f4Dp[1] = 0.0;
        f4Dp[2] = 0.0;
        f4Dp[3] = 0.0;
        double sigmaDh1 = sigmaDf1 * f1Dh[1] + sigmaDf2 * f2Dh[1] + sigmaDf3 * f3Dh[1];
        double sigmaDh2 = sigmaDf1 * f1Dh[2] + sigmaDf2 * f2Dh[2] + sigmaDf3 * f3Dh[2];
        double[][] f1D2hh = new double[2][2];
        double[][] f2D2hh = new double[2][2];
        double[][] f3D2hh = new double[2][2];
        f1D2hh[0][0] = h0 * (h0 - 1.0) * f1 / (h1 * h1);
        f1D2hh[0][1] = h0 * h1h0 / h1 * h0 * h0 / 6.0 * (2.0 * h2 + 4.0 * h0 * h0 / 20.0 * h23);
        f1D2hh[1][1] = h1h0 * (h0 * h0 / 6.0 * (2.0 + 12.0 * h0 * h0 / 20.0 * h2));
        f2D2hh[0][0] = h0 * (h0 - 1.0) * f2 / (h1 * h1);
        f2D2hh[0][1] = nu / alpha * h0 * h1h0 / h1;
        f2D2hh[1][1] = 0.0;
        f3D2hh[0][0] = 2.0 * h0 * (2.0 * h0 + 1.0) * h0 * h0 / 6.0 * alpha * alpha / (h12 * h1 * h1) + h0 * (h0 + 1.0) * rho * beta * nu * alpha / 4.0 / (h1h0 * h1 * h1);
        f3D2hh[0][1] = 0.0;
        f3D2hh[1][1] = 0.0;
        double[][] sigmaD2hh = new double[2][2];
        for (int loopx = 0; loopx < 2; ++loopx) {
            for (int loopy = loopx; loopy < 2; ++loopy) {
                sigmaD2hh[loopx][loopy] = (sigmaD2ff[0][0] * f1Dh[loopy + 1] + sigmaD2ff[0][1] * f2Dh[loopy + 1] + sigmaD2ff[0][2] * f3Dh[loopy + 1]) * f1Dh[loopx + 1] + sigmaDf1 * f1D2hh[loopx][loopy] + (sigmaD2ff[0][1] * f1Dh[loopy + 1] + sigmaD2ff[1][1] * f2Dh[loopy + 1] + sigmaD2ff[1][2] * f3Dh[loopy + 1]) * f2Dh[loopx + 1] + sigmaDf2 * f2D2hh[loopx][loopy] + (sigmaD2ff[0][2] * f1Dh[loopy + 1] + sigmaD2ff[1][2] * f2Dh[loopy + 1] + sigmaD2ff[2][2] * f3Dh[loopy + 1]) * f3Dh[loopx + 1] + sigmaDf3 * f3D2hh[loopx][loopy];
            }
        }
        double h1Df = k;
        double h1Dk = forward;
        double h1D2ff = 0.0;
        double h1D2kf = 1.0;
        double h1D2kk = 0.0;
        double h2Df = 1.0 / forward;
        double h2Dk = -1.0 / k;
        double h2D2ff = -1.0 / (forward * forward);
        double h2D2fk = 0.0;
        double h2D2kk = 1.0 / (k * k);
        volatilityD[0] = sigmaDh1 * h1Df + sigmaDh2 * h2Df;
        volatilityD[1] = sigmaDh1 * h1Dk + sigmaDh2 * h2Dk;
        volatilityD[2] = sigmaDf1 * f1Dp[0] + sigmaDf2 * f2Dp[0] + sigmaDf3 * f3Dp[0] + sigmaDf4 * f4Dp[0];
        volatilityD[3] = sigmaDf1 * f1Dp[1] + sigmaDf2 * f2Dp[1] + sigmaDf3 * f3Dp[1] + sigmaDf4 * f4Dp[1];
        if (MathUtils.nearZero((double)f2, (double)1.0E-6)) {
            volatilityD[4] = -0.5 * f2 + sigmaDf3 * f3Dp[2];
        } else if (MathUtils.nearOne((double)rho, (double)1.0E-5)) {
            double xDr;
            double d = xDr = f2 > 1.0 ? 1.0 / (1.0 - rho) + (0.5 - f2) / (f2 - 1.0) / (f2 - 1.0) : 0.5 * MathUtils.pow2((double)(f2 / (1.0 - f2))) + 0.25 * (f2 - 4.0) * MathUtils.pow3((double)(f2 / (f2 - 1.0))) / (f2 - 1.0) * (1.0 - rho);
            volatilityD[4] = Doubles.isFinite((double)xDr) ? sigmaDf1 * f1Dp[2] + sigmaDx * xDr + sigmaDf3 * f3Dp[2] + sigmaDf4 * f4Dp[2] : Double.NEGATIVE_INFINITY;
        } else {
            double xDr = (-f2 / sqrtf2 - 1.0 + (sqrtf2 + f2 - rho) / (1.0 - rho)) / (sqrtf2 + f2 - rho);
            volatilityD[4] = sigmaDf1 * f1Dp[2] + sigmaDx * xDr + sigmaDf3 * f3Dp[2] + sigmaDf4 * f4Dp[2];
        }
        volatilityD[5] = sigmaDf1 * f1Dp[3] + sigmaDf2 * f2Dp[3] + sigmaDf3 * f3Dp[3] + sigmaDf4 * f4Dp[3];
        volatilityD2[0][0] = (sigmaD2hh[0][0] * h1Df + sigmaD2hh[0][1] * h2Df) * h1Df + sigmaDh1 * h1D2ff + (sigmaD2hh[0][1] * h1Df + sigmaD2hh[1][1] * h2Df) * h2Df + sigmaDh2 * h2D2ff;
        volatilityD2[0][1] = (sigmaD2hh[0][0] * h1Dk + sigmaD2hh[0][1] * h2Dk) * h1Df + sigmaDh1 * h1D2kf + (sigmaD2hh[0][1] * h1Dk + sigmaD2hh[1][1] * h2Dk) * h2Df + sigmaDh2 * h2D2fk;
        volatilityD2[1][0] = volatilityD2[0][1];
        volatilityD2[1][1] = (sigmaD2hh[0][0] * h1Dk + sigmaD2hh[0][1] * h2Dk) * h1Dk + sigmaDh1 * h1D2kk + (sigmaD2hh[0][1] * h1Dk + sigmaD2hh[1][1] * h2Dk) * h2Dk + sigmaDh2 * h2D2kk;
        return sigma;
    }

    private double getZOverChi(double rho, double z) {
        double arg;
        if (MathUtils.nearZero((double)z, (double)1.0E-6)) {
            return 1.0 - rho * z / 2.0;
        }
        double rhoStar = 1.0 - rho;
        if (MathUtils.nearZero((double)rhoStar, (double)1.0E-5)) {
            if (z < 1.0) {
                return -z / Math.log(1.0 - z);
            }
            throw new IllegalArgumentException("can't handle z>=1, rho=1");
        }
        double rhoHat = 1.0 + rho;
        if (MathUtils.nearZero((double)rhoHat, (double)1.0E-8)) {
            if (z > -1.0) {
                return z / Math.log(1.0 + z);
            }
            if (z < -1.0) {
                if (rhoHat == 0.0) {
                    return 0.0;
                }
                double chi = Math.log(rhoHat) - Math.log(-(1.0 + z) / rhoStar);
                return z / chi;
            }
            return 0.0;
        }
        if (z < -1000000.0) {
            arg = (rho * rho - 1.0) / 2.0 / z;
        } else if (z > 1.0E8) {
            arg = 2.0 * (z - rho);
        } else {
            arg = Math.sqrt(1.0 - 2.0 * rho * z + z * z) + z - rho;
            if (arg <= 0.0) {
                return 0.0;
            }
        }
        double chi = Math.log(arg) - Math.log(rhoStar);
        return z / chi;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.getClass() == obj.getClass();
    }

    public String toString() {
        return "SABR (Hagan)";
    }

    public static TypedMetaBean<SabrHaganVolatilityFunctionProvider> meta() {
        return META_BEAN;
    }

    private SabrHaganVolatilityFunctionProvider() {
    }

    public TypedMetaBean<SabrHaganVolatilityFunctionProvider> metaBean() {
        return META_BEAN;
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

