/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.volatility.smile;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.impl.volatility.smile.SabrFormulaData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(factoryName="of")
public final class SabrInArrearsVolatilityFunction
implements ImmutableBean,
Serializable {
    private static final double DEFAULT_Q = 1.0;
    @PropertyDefinition
    private final double q;
    public static final SabrInArrearsVolatilityFunction DEFAULT = new SabrInArrearsVolatilityFunction(1.0);
    private static final long serialVersionUID = 1L;

    public SabrFormulaData effectiveSabrBeforeStart(SabrFormulaData parameters, double tau0, double tau1) {
        double alpha = parameters.getAlpha();
        double beta = parameters.getBeta();
        double rho = parameters.getRho();
        double nu = parameters.getNu();
        double tau = 2.0 * this.q * tau0 + tau1;
        double tauP2 = tau * tau;
        double tauP3 = tauP2 * tau;
        double tau0P2 = tau0 * tau0;
        double tau0P3 = tau0P2 * tau0;
        double tau1P2 = tau1 * tau1;
        double tau1P3 = tau1P2 * tau1;
        double gamma1 = tau * (2.0 * tauP3 + tau1P3 + this.q * (4.0 * this.q - 2.0) * tau0P3 + 6.0 * this.q * tau0P2 * tau1) / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0));
        double gamma2 = 3.0 * this.q * rho * rho * (tau1 - tau0) * (tau1 - tau0) * (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) / ((4.0 * this.q + 3.0) * (3.0 * this.q + 2.0) * (3.0 * this.q + 2.0));
        double gamma = gamma1 + gamma2;
        double rhoHat = rho * (3.0 * tauP2 + 2.0 * this.q * tau0P2 + tau1P2) / (Math.sqrt(gamma) * (6.0 * this.q + 4.0));
        double nuHatP2 = nu * nu * gamma * (2.0 * this.q + 1.0) / (tauP3 * tau1);
        double nuHat = Math.sqrt(nuHatP2);
        double h = nu * nu * (tauP2 + 2.0 * this.q * tau0P2 + tau1P2) / (2.0 * tau1 * tau * (this.q + 1.0)) - nuHatP2;
        double alphaHatP2 = alpha * alpha / (2.0 * this.q + 1.0) * tau / tau1 * Math.exp(0.5 * h * tau1);
        double alphaHat = Math.sqrt(alphaHatP2);
        return SabrFormulaData.of(alphaHat, beta, rhoHat, nuHat);
    }

    public SabrFormulaData effectiveSabrAfterStart(SabrFormulaData parameters, double tau0, double tau1) {
        double alpha = parameters.getAlpha();
        double beta = parameters.getBeta();
        double rho = parameters.getRho();
        double nu = parameters.getNu();
        double zeta = 3.0 / (4.0 * this.q + 3.0) * (1.0 / (2.0 * this.q + 1.0) + rho * rho * 2.0 * this.q / ((3.0 * this.q + 2.0) * (3.0 * this.q + 2.0)));
        double rhoHat = 2.0 * rho / (Math.sqrt(zeta) * (3.0 * this.q + 2.0));
        double nuHat2 = nu * nu * zeta * (2.0 * this.q + 1.0);
        double nuHat = Math.sqrt(nuHat2);
        double alphaHat2 = alpha * alpha / (2.0 * this.q + 1.0) * Math.pow(tau1 / (tau1 - tau0), 2.0 * this.q) * Math.exp(0.5 * (nu * nu / (this.q + 1.0) - nuHat2) * tau1);
        double alphaHat = Math.sqrt(alphaHat2);
        return SabrFormulaData.of(alphaHat, beta, rhoHat, nuHat);
    }

    public SabrFormulaData effectiveSabr(SabrFormulaData parameters, double tau0, double tau1) {
        if (tau0 <= 0.0) {
            return this.effectiveSabrAfterStart(parameters, tau0, tau1);
        }
        return this.effectiveSabrBeforeStart(parameters, tau0, tau1);
    }

    public List<ValueDerivatives> effectiveSabrAfterStartAd(SabrFormulaData parameters, double tau0, double tau1) {
        double alpha = parameters.getAlpha();
        double beta = parameters.getBeta();
        double rho = parameters.getRho();
        double nu = parameters.getNu();
        double zeta = 3.0 / (4.0 * this.q + 3.0) * (1.0 / (2.0 * this.q + 1.0) + rho * rho * 2.0 * this.q / ((3.0 * this.q + 2.0) * (3.0 * this.q + 2.0)));
        double rhoHat = 2.0 * rho / (Math.sqrt(zeta) * (3.0 * this.q + 2.0));
        double nuHat2 = nu * nu * zeta * (2.0 * this.q + 1.0);
        double nuHat = Math.sqrt(nuHat2);
        double alphaHat2 = alpha * alpha / (2.0 * this.q + 1.0) * Math.pow(tau1 / (tau1 - tau0), 2.0 * this.q) * Math.exp(0.5 * (nu * nu / (this.q + 1.0) - nuHat2) * tau1);
        double alphaHat = Math.sqrt(alphaHat2);
        ArrayList<ValueDerivatives> results = new ArrayList<ValueDerivatives>();
        double alphaHatBarAlpha = 1.0;
        double alphaHat2BarAlpha = 0.5 / alphaHat * alphaHatBarAlpha;
        double alphaBarAlpha = 2.0 * alphaHat2 / alpha * alphaHat2BarAlpha;
        double tau1BarAlpha = alphaHat2 * 0.5 * (nu * nu / (this.q + 1.0) - nuHat2) * alphaHat2BarAlpha;
        tau1BarAlpha += alpha * alpha / (2.0 * this.q + 1.0) * Math.exp(0.5 * (nu * nu / (this.q + 1.0) - nuHat2) * tau1) * 2.0 * this.q * Math.pow(tau1 / (tau1 - tau0), 2.0 * this.q - 1.0) * (1.0 / (tau1 - tau0) - tau1 / ((tau1 - tau0) * (tau1 - tau0))) * alphaHat2BarAlpha;
        double tau0BarAlpha = 2.0 * this.q * alphaHat2 / (tau1 / (tau1 - tau0)) * tau1 / ((tau1 - tau0) * (tau1 - tau0)) * alphaHat2BarAlpha;
        double nuBarAlpha = alphaHat2 * nu / (this.q + 1.0) * tau1 * alphaHat2BarAlpha;
        double nuHat2BarAlpha = alphaHat2 * -0.5 * tau1 * alphaHat2BarAlpha;
        double zetaBarAlpha = nuHat2 / zeta * nuHat2BarAlpha;
        double rhoBarAlpha = 3.0 / (4.0 * this.q + 3.0) * rho * 4.0 * this.q / ((3.0 * this.q + 2.0) * (3.0 * this.q + 2.0)) * zetaBarAlpha;
        results.add(ValueDerivatives.of((double)alphaHat, (DoubleArray)DoubleArray.of((double)alphaBarAlpha, (double)0.0, (double)rhoBarAlpha, (double)(nuBarAlpha += nuHat2 * 2.0 / nu * nuHat2BarAlpha), (double)tau0BarAlpha, (double)tau1BarAlpha)));
        results.add(ValueDerivatives.of((double)beta, (DoubleArray)DoubleArray.of((double)0.0, (double)1.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        double rhoHatBarRho = 1.0;
        double rhoBarRho = rhoHat / rho * rhoHatBarRho;
        double zetaBarRho = -0.5 * rhoHat / zeta * rhoHatBarRho;
        results.add(ValueDerivatives.of((double)rhoHat, (DoubleArray)DoubleArray.of((double)0.0, (double)0.0, (double)(rhoBarRho += 3.0 / (4.0 * this.q + 3.0) * rho * 4.0 * this.q / ((3.0 * this.q + 2.0) * (3.0 * this.q + 2.0)) * zetaBarRho), (double)0.0, (double)0.0, (double)0.0)));
        double nuHatBarNu = 1.0;
        double nuHat2BarNu = 0.5 / nuHat * nuHatBarNu;
        double nuBarNu = 2.0 * nuHat2 / nu * nuHat2BarNu;
        double zetaBarNu = nuHat2 / zeta * nuHat2BarNu;
        double rhoBarNu = 3.0 / (4.0 * this.q + 3.0) * rho * 4.0 * this.q / ((3.0 * this.q + 2.0) * (3.0 * this.q + 2.0)) * zetaBarNu;
        results.add(ValueDerivatives.of((double)nuHat, (DoubleArray)DoubleArray.of((double)0.0, (double)0.0, (double)rhoBarNu, (double)nuBarNu, (double)0.0, (double)0.0)));
        return results;
    }

    public List<ValueDerivatives> effectiveSabrBeforeStartAd(SabrFormulaData parameters, double tau0, double tau1) {
        double gammaBarRho;
        double alpha = parameters.getAlpha();
        double beta = parameters.getBeta();
        double rho = parameters.getRho();
        double nu = parameters.getNu();
        double tau = 2.0 * this.q * tau0 + tau1;
        double tauP2 = tau * tau;
        double tauP3 = tauP2 * tau;
        double tau0P2 = tau0 * tau0;
        double tau0P3 = tau0P2 * tau0;
        double tau1P2 = tau1 * tau1;
        double tau1P3 = tau1P2 * tau1;
        double gamma1 = tau * (2.0 * tauP3 + tau1P3 + this.q * (4.0 * this.q - 2.0) * tau0P3 + 6.0 * this.q * tau0P2 * tau1) / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0));
        double gamma2 = 3.0 * this.q * rho * rho * (tau1 - tau0) * (tau1 - tau0) * (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) / ((4.0 * this.q + 3.0) * (3.0 * this.q + 2.0) * (3.0 * this.q + 2.0));
        double gamma = gamma1 + gamma2;
        double rhoHat = rho * (3.0 * tauP2 + 2.0 * this.q * tau0P2 + tau1P2) / (Math.sqrt(gamma) * (6.0 * this.q + 4.0));
        double nuHatP2 = nu * nu * gamma * (2.0 * this.q + 1.0) / (tauP3 * tau1);
        double nuHat = Math.sqrt(nuHatP2);
        double h = nu * nu * (tauP2 + 2.0 * this.q * tau0P2 + tau1P2) / (2.0 * tau1 * tau * (this.q + 1.0)) - nuHatP2;
        double alphaHat2 = alpha * alpha / (2.0 * this.q + 1.0) * tau / tau1 * Math.exp(0.5 * h * tau1);
        double alphaHat = Math.sqrt(alphaHat2);
        ArrayList<ValueDerivatives> results = new ArrayList<ValueDerivatives>();
        double alphaHatBarAlpha = 1.0;
        double alphaHat2BarAlpha = 0.5 / alphaHat * alphaHatBarAlpha;
        double alphaBarAlpha = 2.0 * alphaHat2 / alpha * alphaHat2BarAlpha;
        double tauBarAlpha = alphaHat2 / tau * alphaHat2BarAlpha;
        double tau1BarAlpha = -alphaHat2 / tau1 * alphaHat2BarAlpha;
        tau1BarAlpha += alphaHat2 * 0.5 * h * alphaHat2BarAlpha;
        double hBarAlpha = alphaHat2 * 0.5 * tau1 * alphaHat2BarAlpha;
        double nuBarAlpha = 2.0 * (h + nuHatP2) / nu * hBarAlpha;
        double tauP2BarAlpha = nu * nu / (2.0 * tau1 * tau * (this.q + 1.0)) * hBarAlpha;
        double tau0P2BarAlpha = nu * nu * 2.0 * this.q / (2.0 * tau1 * tau * (this.q + 1.0)) * hBarAlpha;
        double tau1P2BarAlpha = nu * nu / (2.0 * tau1 * tau * (this.q + 1.0)) * hBarAlpha;
        tau1BarAlpha += -(h + nuHatP2) / tau1 * hBarAlpha;
        tauBarAlpha += -(h + nuHatP2) / tau * hBarAlpha;
        double nuHat2BarAlpha = -hBarAlpha;
        nuBarAlpha += 2.0 * nuHatP2 / nu * nuHat2BarAlpha;
        double gammaBarAlpha = nuHatP2 / gamma * nuHat2BarAlpha;
        double tauP3BarAlpha = -nuHatP2 / tauP3 * nuHat2BarAlpha;
        tau1BarAlpha += -nuHatP2 / tau1 * nuHat2BarAlpha;
        double gamma1BarAlpha = gammaBarAlpha;
        double gamma2BarAlpha = gammaBarAlpha;
        double rhoBarAlpha = 2.0 * gamma2 / rho * gamma2BarAlpha;
        tau1BarAlpha += 2.0 * gamma2 / (tau1 - tau0) * gamma2BarAlpha;
        tau1BarAlpha += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 4.0 * tau0 * gamma2BarAlpha;
        double tau0BarAlpha = -2.0 * gamma2 / (tau1 - tau0) * gamma2BarAlpha;
        tauP2BarAlpha += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 3.0 * gamma2BarAlpha;
        tau1P2BarAlpha += -gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * gamma2BarAlpha;
        tau0P2BarAlpha += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 5.0 * this.q * gamma2BarAlpha;
        tau0BarAlpha += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 4.0 * tau1 * gamma2BarAlpha;
        tauBarAlpha += gamma1 / tau * gamma1BarAlpha;
        tauP3BarAlpha += tau * 2.0 / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarAlpha;
        double tau1P3BarAlpha = tau / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarAlpha;
        double tau0P3BarAlpha = tau * this.q * (4.0 * this.q - 2.0) / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarAlpha;
        tau0P2BarAlpha += tau * 6.0 * this.q * tau1 / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarAlpha;
        tau1BarAlpha += tau * 6.0 * this.q * tau0P2 / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarAlpha;
        tau1BarAlpha += tau1P2 * tau1P3BarAlpha;
        tau1BarAlpha += 2.0 * tau1 * (tau1P2BarAlpha += tau1 * tau1P3BarAlpha);
        tau0BarAlpha += tau0P2 * tau0P3BarAlpha;
        tau0BarAlpha += 2.0 * tau0 * (tau0P2BarAlpha += tau0 * tau0P3BarAlpha);
        tauBarAlpha += tauP2 * tauP3BarAlpha;
        results.add(ValueDerivatives.of((double)alphaHat, (DoubleArray)DoubleArray.of((double)alphaBarAlpha, (double)0.0, (double)rhoBarAlpha, (double)nuBarAlpha, (double)(tau0BarAlpha += 2.0 * this.q * (tauBarAlpha += 2.0 * tau * (tauP2BarAlpha += tau * tauP3BarAlpha))), (double)(tau1BarAlpha += tauBarAlpha))));
        results.add(ValueDerivatives.of((double)beta, (DoubleArray)DoubleArray.of((double)0.0, (double)1.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        double rhoHatBarRho = 1.0;
        double rhoBarRho = rhoHat / rho * rhoHatBarRho;
        double tau2BarRho = rho * 3.0 / (Math.sqrt(gamma) * (6.0 * this.q + 4.0)) * rhoHatBarRho;
        double tau0P2BarRho = rho * 2.0 * this.q / (Math.sqrt(gamma) * (6.0 * this.q + 4.0)) * rhoHatBarRho;
        double tau1P2BarRho = rho / (Math.sqrt(gamma) * (6.0 * this.q + 4.0)) * rhoHatBarRho;
        double gamma1BarRho = gammaBarRho = -0.5 * rhoHat / gamma * rhoHatBarRho;
        double gamma2BarRho = gammaBarRho;
        rhoBarRho += 2.0 * gamma2 / rho * gamma2BarRho;
        double tau1BarRho = 2.0 * gamma2 / (tau1 - tau0) * gamma2BarRho;
        tau1BarRho += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 4.0 * tau0 * gamma2BarRho;
        double tau0BarRho = -2.0 * gamma2 / (tau1 - tau0) * gamma2BarRho;
        tau2BarRho += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 3.0 * gamma2BarRho;
        tau1P2BarRho += -gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * gamma2BarRho;
        tau0P2BarRho += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 5.0 * this.q * gamma2BarRho;
        tau0BarRho += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 4.0 * tau1 * gamma2BarRho;
        double tauBarRho = gamma1 / tau * gamma1BarRho;
        double tau3BarRho = tau * 2.0 / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarRho;
        double tau13BarRho = tau / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarRho;
        double tau03BarRho = tau * this.q * (4.0 * this.q - 2.0) / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarRho;
        tau0P2BarRho += tau * 6.0 * this.q * tau1 / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarRho;
        tau1BarRho += tau * 6.0 * this.q * tau0P2 / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarRho;
        tau1BarRho += tau1P2 * tau13BarRho;
        tau1BarRho += 2.0 * tau1 * (tau1P2BarRho += tau1 * tau13BarRho);
        tau0BarRho += tau0P2 * tau03BarRho;
        tau0BarRho += 2.0 * tau0 * (tau0P2BarRho += tau0 * tau03BarRho);
        tauBarRho += tauP2 * tau3BarRho;
        results.add(ValueDerivatives.of((double)rhoHat, (DoubleArray)DoubleArray.of((double)0.0, (double)0.0, (double)rhoBarRho, (double)0.0, (double)(tau0BarRho += 2.0 * this.q * (tauBarRho += 2.0 * tau * (tau2BarRho += tau * tau3BarRho))), (double)(tau1BarRho += tauBarRho))));
        double nuHatBarNu = 1.0;
        double nuHat2BarNu = 0.5 / nuHat * nuHatBarNu;
        double nuBarNu = 2.0 * nuHatP2 / nu * nuHat2BarNu;
        double gammaBarNu = nuHatP2 / gamma * nuHat2BarNu;
        double tau1BarNu = -nuHatP2 / tau1 * nuHat2BarNu;
        double tauP3BarNu = -nuHatP2 / tauP3 * nuHat2BarNu;
        double gamma1BarNu = gammaBarNu;
        double gamma2BarNu = gammaBarNu;
        double rhoBarNu = 2.0 * gamma2 / rho * gamma2BarNu;
        tau1BarNu += 2.0 * gamma2 / (tau1 - tau0) * gamma2BarNu;
        tau1BarNu += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 4.0 * tau0 * gamma2BarNu;
        double tau0BarNu = -2.0 * gamma2 / (tau1 - tau0) * gamma2BarNu;
        double tauP2BarNu = gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 3.0 * gamma2BarNu;
        double tau1P2BarNu = -gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * gamma2BarNu;
        double tau0P2BarNu = gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 5.0 * this.q * gamma2BarNu;
        tau0BarNu += gamma2 / (3.0 * tauP2 - tau1P2 + 5.0 * this.q * tau0P2 + 4.0 * tau0 * tau1) * 4.0 * tau1 * gamma2BarNu;
        double tauBarNu = gamma1 / tau * gamma1BarNu;
        tauP3BarNu += tau * 2.0 / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarNu;
        double tau1P3BarNu = tau / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarNu;
        double tau0P3BarNu = tau * this.q * (4.0 * this.q - 2.0) / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarNu;
        tau0P2BarNu += tau * 6.0 * this.q * tau1 / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarNu;
        tau1BarNu += tau * 6.0 * this.q * tau0P2 / ((4.0 * this.q + 3.0) * (2.0 * this.q + 1.0)) * gamma1BarNu;
        tau1BarNu += tau1P2 * tau1P3BarNu;
        tau1BarNu += 2.0 * tau1 * (tau1P2BarNu += tau1 * tau1P3BarNu);
        tau0BarNu += tau0P2 * tau0P3BarNu;
        tau0BarNu += 2.0 * tau0 * (tau0P2BarNu += tau0 * tau0P3BarNu);
        tauBarNu += tauP2 * tauP3BarNu;
        results.add(ValueDerivatives.of((double)nuHat, (DoubleArray)DoubleArray.of((double)0.0, (double)0.0, (double)rhoBarNu, (double)nuBarNu, (double)(tau0BarNu += 2.0 * this.q * (tauBarNu += 2.0 * tau * (tauP2BarNu += tau * tauP3BarNu))), (double)(tau1BarNu += tauBarNu))));
        return results;
    }

    public List<ValueDerivatives> effectiveSabrAd(SabrFormulaData parameters, double tau0, double tau1) {
        if (tau0 <= 0.0) {
            return this.effectiveSabrAfterStartAd(parameters, tau0, tau1);
        }
        return this.effectiveSabrBeforeStartAd(parameters, tau0, tau1);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static SabrInArrearsVolatilityFunction of(double q) {
        return new SabrInArrearsVolatilityFunction(q);
    }

    public static Builder builder() {
        return new Builder();
    }

    private SabrInArrearsVolatilityFunction(double q) {
        this.q = q;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getQ() {
        return this.q;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SabrInArrearsVolatilityFunction other = (SabrInArrearsVolatilityFunction)obj;
            return JodaBeanUtils.equal((double)this.q, (double)other.q);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.q);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("SabrInArrearsVolatilityFunction{");
        buf.append("q").append('=').append(JodaBeanUtils.toString((Object)this.q));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SabrInArrearsVolatilityFunction> {
        private double q;

        private Builder() {
        }

        private Builder(SabrInArrearsVolatilityFunction beanToCopy) {
            this.q = beanToCopy.getQ();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113: {
                    return this.q;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 113: {
                    this.q = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SabrInArrearsVolatilityFunction build() {
            return new SabrInArrearsVolatilityFunction(this.q);
        }

        public Builder q(double q) {
            this.q = q;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("SabrInArrearsVolatilityFunction.Builder{");
            buf.append("q").append('=').append(JodaBeanUtils.toString((Object)this.q));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> q = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"q", SabrInArrearsVolatilityFunction.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"q"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113: {
                    return this.q;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SabrInArrearsVolatilityFunction> beanType() {
            return SabrInArrearsVolatilityFunction.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> q() {
            return this.q;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 113: {
                    return ((SabrInArrearsVolatilityFunction)bean).getQ();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

