/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.volatility.smile;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.math.impl.minimization.DoubleRangeLimitTransform;
import com.opengamma.strata.math.impl.minimization.NonLinearParameterTransforms;
import com.opengamma.strata.math.impl.minimization.ParameterLimitsTransform;
import com.opengamma.strata.math.impl.minimization.SingleRangeLimitTransform;
import com.opengamma.strata.math.impl.minimization.UncoupledParameterTransforms;
import com.opengamma.strata.pricer.impl.volatility.smile.SabrFormulaData;
import com.opengamma.strata.pricer.impl.volatility.smile.SmileModelFitter;
import com.opengamma.strata.pricer.impl.volatility.smile.VolatilityFunctionProvider;
import com.opengamma.strata.pricer.model.SabrVolatilityFormula;
import java.util.BitSet;

public final class SabrModelFitter
extends SmileModelFitter<SabrFormulaData> {
    private static final double RHO_LIMIT = 0.999;
    private static final ParameterLimitsTransform[] DEFAULT_TRANSFORMS = new ParameterLimitsTransform[4];

    public SabrModelFitter(double forward, DoubleArray strikes, double timeToExpiry, DoubleArray impliedVols, DoubleArray error, SabrVolatilityFormula sabrVolatilityFormula) {
        super(forward, strikes, timeToExpiry, impliedVols, error, (VolatilityFunctionProvider)((Object)sabrVolatilityFormula));
    }

    public SabrModelFitter(double forward, DoubleArray strikes, double timeToExpiry, DoubleArray impliedVols, DoubleArray error, VolatilityFunctionProvider<SabrFormulaData> model) {
        super(forward, strikes, timeToExpiry, impliedVols, error, model);
    }

    @Override
    public SabrFormulaData toSmileModelData(DoubleArray modelParameters) {
        return SabrFormulaData.of(modelParameters.toArray());
    }

    @Override
    protected NonLinearParameterTransforms getTransform(DoubleArray start) {
        BitSet fixed = new BitSet();
        return new UncoupledParameterTransforms(start, DEFAULT_TRANSFORMS, fixed);
    }

    @Override
    protected NonLinearParameterTransforms getTransform(DoubleArray start, BitSet fixed) {
        return new UncoupledParameterTransforms(start, DEFAULT_TRANSFORMS, fixed);
    }

    @Override
    protected DoubleArray getMaximumStep() {
        return null;
    }

    static {
        SabrModelFitter.DEFAULT_TRANSFORMS[0] = new SingleRangeLimitTransform(0.0, ParameterLimitsTransform.LimitType.GREATER_THAN);
        SabrModelFitter.DEFAULT_TRANSFORMS[1] = new DoubleRangeLimitTransform(0.0, 1.0);
        SabrModelFitter.DEFAULT_TRANSFORMS[2] = new DoubleRangeLimitTransform(-0.999, 0.999);
        SabrModelFitter.DEFAULT_TRANSFORMS[3] = new DoubleRangeLimitTransform(0.01, 2.5);
    }
}

