/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.volatility.smile;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.impl.volatility.smile.SmileModelData;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class SsviFormulaData
implements SmileModelData,
ImmutableBean,
Serializable {
    private static final int NUM_PARAMETERS = 3;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray parameters;
    private static final TypedMetaBean<SsviFormulaData> META_BEAN = LightMetaBean.of(SsviFormulaData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"parameters"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static SsviFormulaData of(double sigma, double rho, double eta) {
        return new SsviFormulaData(DoubleArray.of((double)sigma, (double)rho, (double)eta));
    }

    public static SsviFormulaData of(double[] parameters) {
        ArgChecker.notNull((Object)parameters, (String)"parameters");
        ArgChecker.isTrue((parameters.length == 3 ? 1 : 0) != 0, (String)"the number of parameters should be 3");
        return new SsviFormulaData(DoubleArray.copyOf((double[])parameters));
    }

    @ImmutableValidator
    private void validate() {
        for (int i = 0; i < 3; ++i) {
            ArgChecker.isTrue((boolean)this.isAllowed(i, this.parameters.get(i)), (String)"the {}-th parameter is not allowed", (long)i);
        }
    }

    public double getSigma() {
        return this.parameters.get(0);
    }

    public double getRho() {
        return this.parameters.get(1);
    }

    public double getEta() {
        return this.parameters.get(2);
    }

    public SsviFormulaData withSigma(double sigma) {
        return SsviFormulaData.of(sigma, this.getRho(), this.getEta());
    }

    public SsviFormulaData withRho(double rho) {
        return SsviFormulaData.of(this.getSigma(), rho, this.getEta());
    }

    public SsviFormulaData withEta(double eta) {
        return SsviFormulaData.of(this.getSigma(), this.getRho(), eta);
    }

    @Override
    public int getNumberOfParameters() {
        return 3;
    }

    @Override
    public double getParameter(int index) {
        ArgChecker.inRangeExclusive((int)index, (int)-1, (int)3, (String)"index");
        return this.parameters.get(index);
    }

    @Override
    public boolean isAllowed(int index, double value) {
        switch (index) {
            case 0: {
                return value > 0.0;
            }
            case 1: {
                return value >= -1.0 && value <= 1.0;
            }
            case 2: {
                return value > 0.0;
            }
        }
        throw new IllegalArgumentException("index " + index + " outside range");
    }

    @Override
    public SsviFormulaData with(int index, double value) {
        ArgChecker.inRange((int)index, (int)0, (int)3, (String)"index");
        double[] paramsCp = this.parameters.toArray();
        paramsCp[index] = value;
        return SsviFormulaData.of(paramsCp);
    }

    public static TypedMetaBean<SsviFormulaData> meta() {
        return META_BEAN;
    }

    private SsviFormulaData(DoubleArray parameters) {
        JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
        this.parameters = parameters;
        this.validate();
    }

    public TypedMetaBean<SsviFormulaData> metaBean() {
        return META_BEAN;
    }

    public DoubleArray getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SsviFormulaData other = (SsviFormulaData)obj;
            return JodaBeanUtils.equal((Object)this.parameters, (Object)other.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.parameters);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("SsviFormulaData{");
        buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

