/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.volatility.smile;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.impl.volatility.smile.SsviFormulaData;
import com.opengamma.strata.pricer.impl.volatility.smile.VolatilityFunctionProvider;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class SsviVolatilityFunction
extends VolatilityFunctionProvider<SsviFormulaData>
implements ImmutableBean,
Serializable {
    public static final SsviVolatilityFunction DEFAULT = new SsviVolatilityFunction();
    public static final double MIN_TIME_TO_EXPIRY = 0.001;
    private static final TypedMetaBean<SsviVolatilityFunction> META_BEAN = LightMetaBean.of(SsviVolatilityFunction.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final long serialVersionUID = 1L;

    @Override
    public double volatility(double forward, double strike, double timeToExpiry, SsviFormulaData data) {
        ArgChecker.isTrue((timeToExpiry > 0.001 ? 1 : 0) != 0, (String)"time to expiry must not be zero to be able to compute volatility");
        double volatilityAtm = data.getSigma();
        double rho = data.getRho();
        double eta = data.getEta();
        double theta = volatilityAtm * volatilityAtm * timeToExpiry;
        double phi = eta / Math.sqrt(theta);
        double k = Math.log(strike / forward);
        double w = 0.5 * theta * (1.0 + rho * phi * k + Math.sqrt(1.0 + 2.0 * rho * phi * k + phi * k * phi * k));
        return Math.sqrt(w / timeToExpiry);
    }

    @Override
    public ValueDerivatives volatilityAdjoint(double forward, double strike, double timeToExpiry, SsviFormulaData data) {
        ArgChecker.isTrue((timeToExpiry > 0.001 ? 1 : 0) != 0, (String)"time to expiry must not be zero to be able to compute volatility");
        double volatilityAtm = data.getSigma();
        double rho = data.getRho();
        double eta = data.getEta();
        double theta = volatilityAtm * volatilityAtm * timeToExpiry;
        double stheta = Math.sqrt(theta);
        double phi = eta / stheta;
        double k = Math.log(strike / forward);
        double s = Math.sqrt(1.0 + 2.0 * rho * phi * k + phi * k * phi * k);
        double w = 0.5 * theta * (1.0 + rho * phi * k + s);
        double volatility = Math.sqrt(w / timeToExpiry);
        double[] derivatives = new double[6];
        double volatilityBar = 1.0;
        double wBar = 0.5 * volatility / w * volatilityBar;
        derivatives[2] = derivatives[2] + -0.5 * volatility / timeToExpiry * volatilityBar;
        double thetaBar = w / theta * wBar;
        derivatives[4] = derivatives[4] + 0.5 * theta * phi * k * wBar;
        double phiBar = 0.5 * theta * rho * k * wBar;
        double kBar = 0.5 * theta * rho * phi * wBar;
        double sBar = 0.5 * theta * wBar;
        derivatives[4] = derivatives[4] + phi * k / s * sBar;
        derivatives[1] = derivatives[1] + 1.0 / strike * (kBar += (rho * phi + phi * phi * k) / s * sBar);
        derivatives[0] = derivatives[0] + -1.0 / forward * kBar;
        derivatives[5] = derivatives[5] + (phiBar += (rho * k + phi * k * k) / s * sBar) / stheta;
        double sthetaBar = -eta / (stheta * stheta) * phiBar;
        derivatives[3] = derivatives[3] + 2.0 * volatilityAtm * timeToExpiry * (thetaBar += 0.5 / stheta * sthetaBar);
        derivatives[2] = derivatives[2] + volatilityAtm * volatilityAtm * thetaBar;
        return ValueDerivatives.of((double)volatility, (DoubleArray)DoubleArray.ofUnsafe((double[])derivatives));
    }

    @Override
    public double volatilityAdjoint2(double forward, double strike, double timeToExpiry, SsviFormulaData data, double[] volatilityD, double[][] volatilityD2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static TypedMetaBean<SsviVolatilityFunction> meta() {
        return META_BEAN;
    }

    private SsviVolatilityFunction() {
    }

    public TypedMetaBean<SsviVolatilityFunction> metaBean() {
        return META_BEAN;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append("SsviVolatilityFunction{");
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

