/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.impl.volatility.smile;

import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.impl.volatility.smile.SmileModelData;
import java.util.function.Function;

public abstract class VolatilityFunctionProvider<T extends SmileModelData> {
    private static final double EPS = 1.0E-6;

    public abstract double volatility(double var1, double var3, double var5, T var7);

    public ValueDerivatives volatilityAdjoint(double forward, double strike, double timeToExpiry, T data) {
        ArgChecker.isTrue((forward >= 0.0 ? 1 : 0) != 0, (String)"forward must be greater than zero");
        double[] res = new double[2 + data.getNumberOfParameters()];
        double volatility = this.volatility(forward, strike, timeToExpiry, data);
        res[0] = this.forwardBar(forward, strike, timeToExpiry, data);
        res[1] = this.strikeBar(forward, strike, timeToExpiry, data);
        Function<T, Double> func = this.getVolatilityFunction(forward, strike, timeToExpiry);
        double[] modelAdjoint = this.paramBar(func, data);
        System.arraycopy(modelAdjoint, 0, res, 2, data.getNumberOfParameters());
        return ValueDerivatives.of((double)volatility, (DoubleArray)DoubleArray.ofUnsafe((double[])res));
    }

    public abstract double volatilityAdjoint2(double var1, double var3, double var5, T var7, double[] var8, double[][] var9);

    private double forwardBar(double forward, double strike, double timeToExpiry, T data) {
        double volUp = this.volatility(forward + 1.0E-6, strike, timeToExpiry, data);
        double volDown = this.volatility(forward - 1.0E-6, strike, timeToExpiry, data);
        return 0.5 * (volUp - volDown) / 1.0E-6;
    }

    private double strikeBar(double forward, double strike, double timeToExpiry, T data) {
        double volUp = this.volatility(forward, strike + 1.0E-6, timeToExpiry, data);
        double volDown = this.volatility(forward, strike - 1.0E-6, timeToExpiry, data);
        return 0.5 * (volUp - volDown) / 1.0E-6;
    }

    private Function<T, Double> getVolatilityFunction(final double forward, final double strike, final double timeToExpiry) {
        return new Function<T, Double>(){

            @Override
            public Double apply(T data) {
                ArgChecker.notNull(data, (String)"data");
                return VolatilityFunctionProvider.this.volatility(forward, strike, timeToExpiry, data);
            }
        };
    }

    private double[] paramBar(Function<T, Double> func, T data) {
        int n = data.getNumberOfParameters();
        double[] res = new double[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.paramBar(func, data, i);
        }
        return res;
    }

    private double paramBar(Function<T, Double> func, T data, int index) {
        double mid = data.getParameter(index);
        double up = mid + 1.0E-6;
        double down = mid - 1.0E-6;
        if (data.isAllowed(index, down)) {
            if (data.isAllowed(index, up)) {
                SmileModelData dUp = data.with(index, up);
                SmileModelData dDown = data.with(index, down);
                return 0.5 * (func.apply(dUp) - func.apply(dDown)) / 1.0E-6;
            }
            SmileModelData dDown = data.with(index, down);
            return (func.apply((SmileModelData)data) - func.apply(dDown)) / 1.0E-6;
        }
        ArgChecker.isTrue((boolean)data.isAllowed(index, up), (String)"No values and index {} = {} are allowed", (Object[])new Object[]{index, mid});
        SmileModelData dUp = data.with(index, up);
        return (func.apply(dUp) - func.apply((SmileModelData)data)) / 1.0E-6;
    }
}

