/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.rate.IborIndexRates;
import com.opengamma.strata.pricer.rate.IborRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedIborFuture;

public class DiscountingIborFutureProductPricer {
    public static final DiscountingIborFutureProductPricer DEFAULT = new DiscountingIborFutureProductPricer();

    double marginIndex(ResolvedIborFuture future, double price) {
        return price * future.getNotional() * future.getAccrualFactor();
    }

    PointSensitivities marginIndexSensitivity(ResolvedIborFuture future, PointSensitivities priceSensitivity) {
        return priceSensitivity.multipliedBy(future.getNotional() * future.getAccrualFactor());
    }

    public double price(ResolvedIborFuture future, RatesProvider ratesProvider) {
        double forward = this.forwardRate(future, ratesProvider);
        return 1.0 - forward;
    }

    public PointSensitivities priceSensitivity(ResolvedIborFuture future, RatesProvider ratesProvider) {
        IborRateSensitivity sensi = IborRateSensitivity.of(future.getIborRate().getObservation(), -1.0);
        return PointSensitivities.of((PointSensitivity[])new PointSensitivity[]{sensi});
    }

    public double forwardRate(ResolvedIborFuture future, RatesProvider ratesProvider) {
        IborIndexRates rates = ratesProvider.iborIndexRates(future.getIndex());
        return rates.rate(future.getIborRate().getObservation());
    }
}

