/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.index.DiscountingIborFutureProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedIborFuture;
import com.opengamma.strata.product.index.ResolvedIborFutureTrade;
import java.time.LocalDate;

public class DiscountingIborFutureTradePricer {
    public static final DiscountingIborFutureTradePricer DEFAULT = new DiscountingIborFutureTradePricer(DiscountingIborFutureProductPricer.DEFAULT);
    private final DiscountingIborFutureProductPricer productPricer;

    public DiscountingIborFutureTradePricer(DiscountingIborFutureProductPricer productPricer) {
        this.productPricer = (DiscountingIborFutureProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public double price(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.price(trade.getProduct(), ratesProvider);
    }

    public PointSensitivities priceSensitivity(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.priceSensitivity(trade.getProduct(), ratesProvider);
    }

    double referencePrice(ResolvedIborFutureTrade trade, LocalDate valuationDate, double lastSettlementPrice) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        return trade.getTradedPrice().filter(tp -> tp.getTradeDate().equals(valuationDate)).map(tp -> tp.getPrice()).orElse(lastSettlementPrice);
    }

    CurrencyAmount presentValue(ResolvedIborFutureTrade trade, double currentPrice, double referencePrice) {
        ResolvedIborFuture future = trade.getProduct();
        double priceIndex = this.productPricer.marginIndex(future, currentPrice);
        double referenceIndex = this.productPricer.marginIndex(future, referencePrice);
        double pv = (priceIndex - referenceIndex) * trade.getQuantity();
        return CurrencyAmount.of((Currency)future.getCurrency(), (double)pv);
    }

    public CurrencyAmount presentValue(ResolvedIborFutureTrade trade, RatesProvider ratesProvider, double lastSettlementPrice) {
        double referencePrice = this.referencePrice(trade, ratesProvider.getValuationDate(), lastSettlementPrice);
        double price = this.price(trade, ratesProvider);
        return this.presentValue(trade, price, referencePrice);
    }

    public PointSensitivities presentValueSensitivity(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        ResolvedIborFuture product = trade.getProduct();
        PointSensitivities priceSensi = this.productPricer.priceSensitivity(product, ratesProvider);
        PointSensitivities marginIndexSensi = this.productPricer.marginIndexSensitivity(product, priceSensi);
        return marginIndexSensi.multipliedBy(trade.getQuantity());
    }

    public double parSpread(ResolvedIborFutureTrade trade, RatesProvider ratesProvider, double lastSettlementPrice) {
        double referencePrice = this.referencePrice(trade, ratesProvider.getValuationDate(), lastSettlementPrice);
        return this.price(trade, ratesProvider) - referencePrice;
    }

    public PointSensitivities parSpreadSensitivity(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.priceSensitivity(trade.getProduct(), ratesProvider);
    }

    public double forwardRate(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.forwardRate(trade.getProduct(), ratesProvider);
    }
}

