/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedOvernightFuture;
import com.opengamma.strata.product.rate.OvernightRateComputation;
import com.opengamma.strata.product.rate.RateComputation;

public class DiscountingOvernightFutureProductPricer {
    public static final DiscountingOvernightFutureProductPricer DEFAULT = new DiscountingOvernightFutureProductPricer(RateComputationFn.standard());
    private final RateComputationFn<RateComputation> rateComputationFn;

    public DiscountingOvernightFutureProductPricer(RateComputationFn<RateComputation> rateComputationFn) {
        this.rateComputationFn = (RateComputationFn)ArgChecker.notNull(rateComputationFn, (String)"rateComputationFn");
    }

    double marginIndex(ResolvedOvernightFuture future, double price) {
        return price * future.getNotional() * future.getAccrualFactor();
    }

    PointSensitivities marginIndexSensitivity(ResolvedOvernightFuture future, PointSensitivities priceSensitivity) {
        return priceSensitivity.multipliedBy(future.getNotional() * future.getAccrualFactor());
    }

    public double price(ResolvedOvernightFuture future, RatesProvider ratesProvider) {
        double forwardRate = this.forwardRate(future, ratesProvider);
        return 1.0 - forwardRate;
    }

    public PointSensitivities priceSensitivity(ResolvedOvernightFuture future, RatesProvider ratesProvider) {
        PointSensitivityBuilder forwardRateSensitivity = this.rateComputationFn.rateSensitivity((RateComputation)future.getOvernightRate(), future.getOvernightRate().getStartDate(), future.getOvernightRate().getEndDate(), ratesProvider);
        return forwardRateSensitivity.build().multipliedBy(-1.0);
    }

    public double forwardRate(ResolvedOvernightFuture future, RatesProvider ratesProvider) {
        OvernightRateComputation computation = future.getOvernightRate();
        return this.rateComputationFn.rate((RateComputation)computation, computation.getStartDate(), computation.getEndDate(), ratesProvider);
    }
}

