/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.index.DiscountingOvernightFutureProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedOvernightFuture;
import com.opengamma.strata.product.index.ResolvedOvernightFutureTrade;
import java.time.LocalDate;

public class DiscountingOvernightFutureTradePricer {
    public static final DiscountingOvernightFutureTradePricer DEFAULT = new DiscountingOvernightFutureTradePricer(DiscountingOvernightFutureProductPricer.DEFAULT);
    private final DiscountingOvernightFutureProductPricer productPricer;

    public DiscountingOvernightFutureTradePricer(DiscountingOvernightFutureProductPricer productPricer) {
        this.productPricer = (DiscountingOvernightFutureProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public double price(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.price(trade.getProduct(), ratesProvider);
    }

    public PointSensitivities priceSensitivity(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.priceSensitivity(trade.getProduct(), ratesProvider);
    }

    double referencePrice(ResolvedOvernightFutureTrade trade, LocalDate valuationDate, double lastSettlementPrice) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        return trade.getTradedPrice().filter(tp -> tp.getTradeDate().equals(valuationDate)).map(tp -> tp.getPrice()).orElse(lastSettlementPrice);
    }

    CurrencyAmount presentValue(ResolvedOvernightFutureTrade trade, double currentPrice, double referencePrice) {
        ResolvedOvernightFuture future = trade.getProduct();
        double priceIndex = this.productPricer.marginIndex(future, currentPrice);
        double referenceIndex = this.productPricer.marginIndex(future, referencePrice);
        double pv = (priceIndex - referenceIndex) * trade.getQuantity();
        return CurrencyAmount.of((Currency)future.getCurrency(), (double)pv);
    }

    public CurrencyAmount presentValue(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider, double lastSettlementPrice) {
        double referencePrice = this.referencePrice(trade, ratesProvider.getValuationDate(), lastSettlementPrice);
        double price = this.price(trade, ratesProvider);
        return this.presentValue(trade, price, referencePrice);
    }

    public PointSensitivities presentValueSensitivity(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        ResolvedOvernightFuture product = trade.getProduct();
        PointSensitivities priceSensi = this.productPricer.priceSensitivity(product, ratesProvider);
        PointSensitivities marginIndexSensi = this.productPricer.marginIndexSensitivity(product, priceSensi);
        return marginIndexSensi.multipliedBy(trade.getQuantity());
    }

    public double parSpread(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider, double lastSettlementPrice) {
        double referencePrice = this.referencePrice(trade, ratesProvider.getValuationDate(), lastSettlementPrice);
        return this.price(trade, ratesProvider) - referencePrice;
    }

    public PointSensitivities parSpreadSensitivity(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.priceSensitivity(trade.getProduct(), ratesProvider);
    }

    public double forwardRate(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.productPricer.forwardRate(trade.getProduct(), ratesProvider);
    }
}

