/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.model.HullWhiteOneFactorPiecewiseConstantParametersProvider;
import com.opengamma.strata.pricer.rate.IborRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedIborFuture;
import java.time.LocalDate;

public class HullWhiteIborFutureProductPricer {
    public static final HullWhiteIborFutureProductPricer DEFAULT = new HullWhiteIborFutureProductPricer();

    double marginIndex(ResolvedIborFuture future, double price) {
        return price * future.getNotional() * future.getAccrualFactor();
    }

    PointSensitivities marginIndexSensitivity(ResolvedIborFuture future, PointSensitivities priceSensitivity) {
        return priceSensitivity.multipliedBy(future.getNotional() * future.getAccrualFactor());
    }

    public double price(ResolvedIborFuture future, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        double parRate = this.parRate(future, ratesProvider, hwProvider);
        return 1.0 - parRate;
    }

    public double convexityAdjustment(ResolvedIborFuture future, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        IborIndexObservation obs = future.getIborRate().getObservation();
        double forward = ratesProvider.iborIndexRates(future.getIndex()).rate(obs);
        double parRate = this.parRate(future, ratesProvider, hwProvider);
        return forward - parRate;
    }

    public double parRate(ResolvedIborFuture future, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        IborIndexObservation obs = future.getIborRate().getObservation();
        double forward = ratesProvider.iborIndexRates(future.getIndex()).rate(obs);
        LocalDate fixingStartDate = obs.getEffectiveDate();
        LocalDate fixingEndDate = obs.getMaturityDate();
        double fixingYearFraction = obs.getYearFraction();
        double convexity = hwProvider.futuresConvexityFactor(future.getLastTradeDate(), fixingStartDate, fixingEndDate);
        return convexity * forward - (1.0 - convexity) / fixingYearFraction;
    }

    public PointSensitivities priceSensitivityRates(ResolvedIborFuture future, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        IborIndexObservation obs = future.getIborRate().getObservation();
        LocalDate fixingStartDate = obs.getEffectiveDate();
        LocalDate fixingEndDate = obs.getMaturityDate();
        double convexity = hwProvider.futuresConvexityFactor(future.getLastTradeDate(), fixingStartDate, fixingEndDate);
        IborRateSensitivity sensi = IborRateSensitivity.of(obs, -convexity);
        return PointSensitivities.of((PointSensitivity[])new PointSensitivity[]{sensi});
    }

    public DoubleArray priceSensitivityModelParamsHullWhite(ResolvedIborFuture future, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        IborIndexObservation obs = future.getIborRate().getObservation();
        double forward = ratesProvider.iborIndexRates(future.getIndex()).rate(obs);
        LocalDate fixingStartDate = obs.getEffectiveDate();
        LocalDate fixingEndDate = obs.getMaturityDate();
        double fixingYearFraction = obs.getYearFraction();
        DoubleArray convexityDeriv = hwProvider.futuresConvexityFactorAdjoint(future.getLastTradeDate(), fixingStartDate, fixingEndDate).getDerivatives();
        convexityDeriv = convexityDeriv.multipliedBy(-forward - 1.0 / fixingYearFraction);
        return convexityDeriv;
    }
}

