/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.index.HullWhiteIborFutureProductPricer;
import com.opengamma.strata.pricer.model.HullWhiteOneFactorPiecewiseConstantParametersProvider;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedIborFuture;
import com.opengamma.strata.product.index.ResolvedIborFutureTrade;
import java.time.LocalDate;

public class HullWhiteIborFutureTradePricer {
    public static final HullWhiteIborFutureTradePricer DEFAULT = new HullWhiteIborFutureTradePricer(HullWhiteIborFutureProductPricer.DEFAULT);
    private final HullWhiteIborFutureProductPricer productPricer;

    public HullWhiteIborFutureTradePricer(HullWhiteIborFutureProductPricer productPricer) {
        this.productPricer = (HullWhiteIborFutureProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public double price(ResolvedIborFutureTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        return this.productPricer.price(trade.getProduct(), ratesProvider, hwProvider);
    }

    public PointSensitivities priceSensitivityRates(ResolvedIborFutureTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        return this.productPricer.priceSensitivityRates(trade.getProduct(), ratesProvider, hwProvider);
    }

    private double referencePrice(ResolvedIborFutureTrade trade, LocalDate valuationDate, double lastSettlementPrice) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        return trade.getTradedPrice().filter(tp -> tp.getTradeDate().equals(valuationDate)).map(tp -> tp.getPrice()).orElse(lastSettlementPrice);
    }

    CurrencyAmount presentValue(ResolvedIborFutureTrade trade, double currentPrice, double referencePrice) {
        ResolvedIborFuture future = trade.getProduct();
        double priceIndex = this.productPricer.marginIndex(future, currentPrice);
        double referenceIndex = this.productPricer.marginIndex(future, referencePrice);
        double pv = (priceIndex - referenceIndex) * trade.getQuantity();
        return CurrencyAmount.of((Currency)future.getCurrency(), (double)pv);
    }

    public CurrencyAmount presentValue(ResolvedIborFutureTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider, double lastSettlementPrice) {
        double referencePrice = this.referencePrice(trade, ratesProvider.getValuationDate(), lastSettlementPrice);
        double price = this.price(trade, ratesProvider, hwProvider);
        return this.presentValue(trade, price, referencePrice);
    }

    public PointSensitivities presentValueSensitivityRates(ResolvedIborFutureTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        ResolvedIborFuture product = trade.getProduct();
        PointSensitivities priceSensi = this.productPricer.priceSensitivityRates(product, ratesProvider, hwProvider);
        PointSensitivities marginIndexSensi = this.productPricer.marginIndexSensitivity(product, priceSensi);
        return marginIndexSensi.multipliedBy(trade.getQuantity());
    }

    public DoubleArray presentValueSensitivityModelParamsHullWhite(ResolvedIborFutureTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        ResolvedIborFuture product = trade.getProduct();
        DoubleArray hwSensi = this.productPricer.priceSensitivityModelParamsHullWhite(product, ratesProvider, hwProvider);
        hwSensi = hwSensi.multipliedBy(product.getNotional() * product.getAccrualFactor() * trade.getQuantity());
        return hwSensi;
    }

    public double parSpread(ResolvedIborFutureTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider, double lastSettlementPrice) {
        double referencePrice = this.referencePrice(trade, ratesProvider.getValuationDate(), lastSettlementPrice);
        return this.price(trade, ratesProvider, hwProvider) - referencePrice;
    }

    public PointSensitivities parSpreadSensitivityRates(ResolvedIborFutureTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        return this.productPricer.priceSensitivityRates(trade.getProduct(), ratesProvider, hwProvider);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedIborFutureTrade trade, RatesProvider provider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider, double lastSettlementPrice) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, provider, hwProvider, lastSettlementPrice)});
    }
}

