/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.index.IborFutureOptionVolatilitiesName;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IborFutureOptionSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final IborFutureOptionVolatilitiesName volatilitiesName;
    @PropertyDefinition(validate="notNull")
    private final double expiry;
    @PropertyDefinition(validate="notNull")
    private final LocalDate fixingDate;
    @PropertyDefinition
    private final double strikePrice;
    @PropertyDefinition
    private final double futurePrice;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static IborFutureOptionSensitivity of(IborFutureOptionVolatilitiesName volatilitiesName, double expiry, LocalDate fixingDate, double strikePrice, double futurePrice, Currency sensitivityCurrency, double sensitivity) {
        return new IborFutureOptionSensitivity(volatilitiesName, expiry, fixingDate, strikePrice, futurePrice, sensitivityCurrency, sensitivity);
    }

    public IborFutureOptionSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new IborFutureOptionSensitivity(this.volatilitiesName, this.expiry, this.fixingDate, this.strikePrice, this.futurePrice, currency, this.sensitivity);
    }

    public IborFutureOptionSensitivity withSensitivity(double sensitivity) {
        return new IborFutureOptionSensitivity(this.volatilitiesName, this.expiry, this.fixingDate, this.strikePrice, this.futurePrice, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof IborFutureOptionSensitivity) {
            IborFutureOptionSensitivity otherOption = (IborFutureOptionSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.volatilitiesName), (Comparable)((Object)otherOption.volatilitiesName)).compare((Comparable)this.currency, (Comparable)otherOption.currency).compare(this.expiry, otherOption.expiry).compare((Comparable)this.fixingDate, (Comparable)otherOption.fixingDate).compare(this.strikePrice, otherOption.strikePrice).compare(this.futurePrice, otherOption.futurePrice).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public IborFutureOptionSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (IborFutureOptionSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public IborFutureOptionSensitivity multipliedBy(double factor) {
        return new IborFutureOptionSensitivity(this.volatilitiesName, this.expiry, this.fixingDate, this.strikePrice, this.futurePrice, this.currency, this.sensitivity * factor);
    }

    public IborFutureOptionSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new IborFutureOptionSensitivity(this.volatilitiesName, this.expiry, this.fixingDate, this.strikePrice, this.futurePrice, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public IborFutureOptionSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public IborFutureOptionSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private IborFutureOptionSensitivity(IborFutureOptionVolatilitiesName volatilitiesName, double expiry, LocalDate fixingDate, double strikePrice, double futurePrice, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)volatilitiesName, (String)"volatilitiesName");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)fixingDate, (String)"fixingDate");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.volatilitiesName = volatilitiesName;
        this.expiry = expiry;
        this.fixingDate = fixingDate;
        this.strikePrice = strikePrice;
        this.futurePrice = futurePrice;
        this.currency = currency;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public IborFutureOptionVolatilitiesName getVolatilitiesName() {
        return this.volatilitiesName;
    }

    public double getExpiry() {
        return this.expiry;
    }

    public LocalDate getFixingDate() {
        return this.fixingDate;
    }

    public double getStrikePrice() {
        return this.strikePrice;
    }

    public double getFuturePrice() {
        return this.futurePrice;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborFutureOptionSensitivity other = (IborFutureOptionSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.volatilitiesName, (Object)other.volatilitiesName) && JodaBeanUtils.equal((double)this.expiry, (double)other.expiry) && JodaBeanUtils.equal((Object)this.fixingDate, (Object)other.fixingDate) && JodaBeanUtils.equal((double)this.strikePrice, (double)other.strikePrice) && JodaBeanUtils.equal((double)this.futurePrice, (double)other.futurePrice) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.volatilitiesName);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strikePrice);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.futurePrice);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("IborFutureOptionSensitivity{");
        buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("fixingDate").append('=').append(JodaBeanUtils.toString((Object)this.fixingDate)).append(',').append(' ');
        buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
        buf.append("futurePrice").append('=').append(JodaBeanUtils.toString((Object)this.futurePrice)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IborFutureOptionSensitivity> {
        private IborFutureOptionVolatilitiesName volatilitiesName;
        private double expiry;
        private LocalDate fixingDate;
        private double strikePrice;
        private double futurePrice;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case -518499002: {
                    return this.futurePrice;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    this.volatilitiesName = (IborFutureOptionVolatilitiesName)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (Double)newValue;
                    break;
                }
                case 1255202043: {
                    this.fixingDate = (LocalDate)newValue;
                    break;
                }
                case 50946231: {
                    this.strikePrice = (Double)newValue;
                    break;
                }
                case -518499002: {
                    this.futurePrice = (Double)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IborFutureOptionSensitivity build() {
            return new IborFutureOptionSensitivity(this.volatilitiesName, this.expiry, this.fixingDate, this.strikePrice, this.futurePrice, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("IborFutureOptionSensitivity.Builder{");
            buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("fixingDate").append('=').append(JodaBeanUtils.toString((Object)this.fixingDate)).append(',').append(' ');
            buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
            buf.append("futurePrice").append('=').append(JodaBeanUtils.toString((Object)this.futurePrice)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborFutureOptionVolatilitiesName> volatilitiesName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"volatilitiesName", IborFutureOptionSensitivity.class, IborFutureOptionVolatilitiesName.class);
        private final MetaProperty<Double> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", IborFutureOptionSensitivity.class, Double.TYPE);
        private final MetaProperty<LocalDate> fixingDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDate", IborFutureOptionSensitivity.class, LocalDate.class);
        private final MetaProperty<Double> strikePrice = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikePrice", IborFutureOptionSensitivity.class, Double.TYPE);
        private final MetaProperty<Double> futurePrice = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"futurePrice", IborFutureOptionSensitivity.class, Double.TYPE);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IborFutureOptionSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", IborFutureOptionSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"volatilitiesName", "expiry", "fixingDate", "strikePrice", "futurePrice", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 1255202043: {
                    return this.fixingDate;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case -518499002: {
                    return this.futurePrice;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IborFutureOptionSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends IborFutureOptionSensitivity> beanType() {
            return IborFutureOptionSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborFutureOptionVolatilitiesName> volatilitiesName() {
            return this.volatilitiesName;
        }

        public MetaProperty<Double> expiry() {
            return this.expiry;
        }

        public MetaProperty<LocalDate> fixingDate() {
            return this.fixingDate;
        }

        public MetaProperty<Double> strikePrice() {
            return this.strikePrice;
        }

        public MetaProperty<Double> futurePrice() {
            return this.futurePrice;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return ((IborFutureOptionSensitivity)bean).getVolatilitiesName();
                }
                case -1289159373: {
                    return ((IborFutureOptionSensitivity)bean).getExpiry();
                }
                case 1255202043: {
                    return ((IborFutureOptionSensitivity)bean).getFixingDate();
                }
                case 50946231: {
                    return ((IborFutureOptionSensitivity)bean).getStrikePrice();
                }
                case -518499002: {
                    return ((IborFutureOptionSensitivity)bean).getFuturePrice();
                }
                case 575402001: {
                    return ((IborFutureOptionSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((IborFutureOptionSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

