/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.impl.option.NormalFormulaRepository;
import com.opengamma.strata.pricer.index.DiscountingIborFutureProductPricer;
import com.opengamma.strata.pricer.index.IborFutureOptionSensitivity;
import com.opengamma.strata.pricer.index.NormalIborFutureOptionVolatilities;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedIborFuture;
import com.opengamma.strata.product.index.ResolvedIborFutureOption;
import com.opengamma.strata.product.option.FutureOptionPremiumStyle;

public class NormalIborFutureOptionMarginedProductPricer {
    public static final NormalIborFutureOptionMarginedProductPricer DEFAULT = new NormalIborFutureOptionMarginedProductPricer(DiscountingIborFutureProductPricer.DEFAULT);
    private final DiscountingIborFutureProductPricer futurePricer;

    public NormalIborFutureOptionMarginedProductPricer(DiscountingIborFutureProductPricer futurePricer) {
        this.futurePricer = (DiscountingIborFutureProductPricer)ArgChecker.notNull((Object)futurePricer, (String)"futurePricer");
    }

    DiscountingIborFutureProductPricer getFuturePricer() {
        return this.futurePricer;
    }

    double marginIndex(ResolvedIborFutureOption option, double price) {
        double notional = option.getUnderlyingFuture().getNotional();
        double accrualFactor = option.getUnderlyingFuture().getAccrualFactor();
        return price * notional * accrualFactor;
    }

    PointSensitivities marginIndexSensitivity(ResolvedIborFutureOption option, PointSensitivities priceSensitivity) {
        double notional = option.getUnderlyingFuture().getNotional();
        double accrualFactor = option.getUnderlyingFuture().getAccrualFactor();
        return priceSensitivity.multipliedBy(notional * accrualFactor);
    }

    public double price(ResolvedIborFutureOption futureOption, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, ratesProvider);
        return this.price(futureOption, ratesProvider, volatilities, futurePrice);
    }

    public double price(ResolvedIborFutureOption futureOption, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        ArgChecker.isTrue((boolean)futureOption.getUnderlyingFuture().getIndex().equals(volatilities.getIndex()), (String)"Future index should be the same as data index");
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double strike = futureOption.getStrikePrice();
        ResolvedIborFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(timeToExpiry, future.getLastTradeDate(), strike, futurePrice);
        return NormalFormulaRepository.price(futurePrice, strike, timeToExpiry, volatility, futureOption.getPutCall());
    }

    public double deltaStickyStrike(ResolvedIborFutureOption futureOption, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, ratesProvider);
        return this.deltaStickyStrike(futureOption, ratesProvider, volatilities, futurePrice);
    }

    public double deltaStickyStrike(ResolvedIborFutureOption futureOption, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double strike = futureOption.getStrikePrice();
        ResolvedIborFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(timeToExpiry, future.getLastTradeDate(), strike, futurePrice);
        return NormalFormulaRepository.delta(futurePrice, strike, timeToExpiry, volatility, futureOption.getPutCall());
    }

    public PointSensitivities priceSensitivityRatesStickyStrike(ResolvedIborFutureOption futureOption, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double futurePrice = this.futurePrice(futureOption, ratesProvider);
        return this.priceSensitivityRatesStickyStrike(futureOption, ratesProvider, volatilities, futurePrice);
    }

    public PointSensitivities priceSensitivityRatesStickyStrike(ResolvedIborFutureOption futureOption, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities, double futurePrice) {
        double delta = this.deltaStickyStrike(futureOption, ratesProvider, volatilities, futurePrice);
        PointSensitivities futurePriceSensitivity = this.futurePricer.priceSensitivity(futureOption.getUnderlyingFuture(), ratesProvider);
        return futurePriceSensitivity.multipliedBy(delta);
    }

    public IborFutureOptionSensitivity priceSensitivityModelParamsVolatility(ResolvedIborFutureOption futureOption, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, ratesProvider);
        return this.priceSensitivityModelParamsVolatility(futureOption, ratesProvider, volatilities, futurePrice);
    }

    public IborFutureOptionSensitivity priceSensitivityModelParamsVolatility(ResolvedIborFutureOption futureOption, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double strike = futureOption.getStrikePrice();
        ResolvedIborFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(timeToExpiry, future.getLastTradeDate(), strike, futurePrice);
        double vega = NormalFormulaRepository.vega(futurePrice, strike, timeToExpiry, volatility, futureOption.getPutCall());
        return IborFutureOptionSensitivity.of(volatilities.getName(), timeToExpiry, future.getLastTradeDate(), strike, futurePrice, future.getCurrency(), vega);
    }

    private double futurePrice(ResolvedIborFutureOption futureOption, RatesProvider ratesProvider) {
        ResolvedIborFuture future = futureOption.getUnderlyingFuture();
        return this.futurePricer.price(future, ratesProvider);
    }
}

