/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.index.IborFutureOptionSensitivity;
import com.opengamma.strata.pricer.index.NormalIborFutureOptionMarginedProductPricer;
import com.opengamma.strata.pricer.index.NormalIborFutureOptionVolatilities;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedIborFuture;
import com.opengamma.strata.product.index.ResolvedIborFutureOption;
import com.opengamma.strata.product.index.ResolvedIborFutureOptionTrade;
import java.time.LocalDate;

public final class NormalIborFutureOptionMarginedTradePricer {
    public static final NormalIborFutureOptionMarginedTradePricer DEFAULT = new NormalIborFutureOptionMarginedTradePricer(NormalIborFutureOptionMarginedProductPricer.DEFAULT);
    private final NormalIborFutureOptionMarginedProductPricer futureOptionPricer;

    public NormalIborFutureOptionMarginedTradePricer(NormalIborFutureOptionMarginedProductPricer futureOptionPricer) {
        this.futureOptionPricer = (NormalIborFutureOptionMarginedProductPricer)ArgChecker.notNull((Object)futureOptionPricer, (String)"futureOptionPricer");
    }

    public double price(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities) {
        return this.futureOptionPricer.price(trade.getProduct(), ratesProvider, volatilities);
    }

    public CurrencyAmount presentValue(ResolvedIborFutureOptionTrade trade, LocalDate valuationDate, double currentOptionPrice, double lastOptionSettlementPrice) {
        ResolvedIborFutureOption option = trade.getProduct();
        double referencePrice = this.referencePrice(trade, valuationDate, lastOptionSettlementPrice);
        double priceIndex = this.futureOptionPricer.marginIndex(option, currentOptionPrice);
        double referenceIndex = this.futureOptionPricer.marginIndex(option, referencePrice);
        double pv = (priceIndex - referenceIndex) * trade.getQuantity();
        return CurrencyAmount.of((Currency)option.getUnderlyingFuture().getCurrency(), (double)pv);
    }

    public CurrencyAmount presentValue(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities, double lastOptionSettlementPrice) {
        double price = this.price(trade, ratesProvider, volatilities);
        return this.presentValue(trade, ratesProvider.getValuationDate(), price, lastOptionSettlementPrice);
    }

    public CurrencyAmount presentValue(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities, double futurePrice, double lastOptionSettlementPrice) {
        double optionPrice = this.futureOptionPricer.price(trade.getProduct(), ratesProvider, volatilities, futurePrice);
        return this.presentValue(trade, ratesProvider.getValuationDate(), optionPrice, lastOptionSettlementPrice);
    }

    public PointSensitivities presentValueSensitivityRates(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities) {
        ResolvedIborFutureOption product = trade.getProduct();
        PointSensitivities priceSensi = this.futureOptionPricer.priceSensitivityRatesStickyStrike(product, ratesProvider, volatilities);
        PointSensitivities marginIndexSensi = this.futureOptionPricer.marginIndexSensitivity(product, priceSensi);
        return marginIndexSensi.multipliedBy(trade.getQuantity());
    }

    public IborFutureOptionSensitivity presentValueSensitivityModelParamsVolatility(ResolvedIborFutureOptionTrade futureOptionTrade, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities) {
        ResolvedIborFuture future = futureOptionTrade.getProduct().getUnderlyingFuture();
        double futurePrice = this.futureOptionPricer.getFuturePricer().price(future, ratesProvider);
        return this.presentValueSensitivityModelParamsVolatility(futureOptionTrade, ratesProvider, volatilities, futurePrice);
    }

    public IborFutureOptionSensitivity presentValueSensitivityModelParamsVolatility(ResolvedIborFutureOptionTrade futureOptionTrade, RatesProvider ratesProvider, NormalIborFutureOptionVolatilities volatilities, double futurePrice) {
        ResolvedIborFutureOption product = futureOptionTrade.getProduct();
        IborFutureOptionSensitivity priceSensitivity = this.futureOptionPricer.priceSensitivityModelParamsVolatility(product, ratesProvider, volatilities, futurePrice);
        double factor = this.futureOptionPricer.marginIndex(product, 1.0) * futureOptionTrade.getQuantity();
        return priceSensitivity.multipliedBy(factor);
    }

    private double referencePrice(ResolvedIborFutureOptionTrade trade, LocalDate valuationDate, double lastSettlementPrice) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        return trade.getTradedPrice().filter(tp -> tp.getTradeDate().equals(valuationDate)).map(tp -> tp.getPrice()).orElse(lastSettlementPrice);
    }
}

