/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.index;

import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.index.OvernightFutureOptionVolatilitiesName;
import java.time.LocalDate;
import java.time.ZonedDateTime;

public interface OvernightFutureOptionVolatilities
extends MarketDataView,
ParameterizedData {
    public OvernightFutureOptionVolatilitiesName getName();

    public OvernightIndex getIndex();

    public ValueType getVolatilityType();

    default public LocalDate getValuationDate() {
        return this.getValuationDateTime().toLocalDate();
    }

    public ZonedDateTime getValuationDateTime();

    public OvernightFutureOptionVolatilities withParameter(int var1, double var2);

    public OvernightFutureOptionVolatilities withPerturbation(ParameterPerturbation var1);

    default public double volatility(ZonedDateTime expiryDateTime, LocalDate fixingDate, double strikePrice, double futurePrice) {
        return this.volatility(this.relativeTime(expiryDateTime), fixingDate, strikePrice, futurePrice);
    }

    public double volatility(double var1, LocalDate var3, double var4, double var6);

    default public CurrencyParameterSensitivities parameterSensitivity(PointSensitivity ... pointSensitivities) {
        return this.parameterSensitivity(PointSensitivities.of((PointSensitivity[])pointSensitivities));
    }

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities var1);

    public double relativeTime(ZonedDateTime var1);
}

