/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.model;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class HullWhiteOneFactorPiecewiseConstantParameters
implements ImmutableBean,
Serializable {
    private static final double VOLATILITY_TIME_INFINITY = 1000.0;
    @PropertyDefinition(validate="notNull")
    private final double meanReversion;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray volatility;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray volatilityTime;
    private static final TypedMetaBean<HullWhiteOneFactorPiecewiseConstantParameters> META_BEAN = LightMetaBean.of(HullWhiteOneFactorPiecewiseConstantParameters.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"meanReversion", "volatility", "volatilityTime"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static HullWhiteOneFactorPiecewiseConstantParameters of(double meanReversion, DoubleArray volatility, DoubleArray volatilityTime) {
        double[] volatilityTimeArray = new double[volatilityTime.size() + 2];
        volatilityTimeArray[0] = 0.0;
        volatilityTimeArray[volatilityTime.size() + 1] = 1000.0;
        System.arraycopy(volatilityTime.toArray(), 0, volatilityTimeArray, 1, volatilityTime.size());
        return new HullWhiteOneFactorPiecewiseConstantParameters(meanReversion, volatility, DoubleArray.copyOf((double[])volatilityTimeArray));
    }

    @ImmutableValidator
    private void validate() {
        int sizeTime = this.volatilityTime.size();
        ArgChecker.isTrue((sizeTime == this.volatility.size() + 1 ? 1 : 0) != 0, (String)"size mismatch between volatility and volatilityTime");
        for (int i = 1; i < sizeTime; ++i) {
            ArgChecker.isTrue((this.volatilityTime.get(i - 1) < this.volatilityTime.get(i) ? 1 : 0) != 0, (String)"volatility times should be increasing");
        }
    }

    public HullWhiteOneFactorPiecewiseConstantParameters withVolatility(DoubleArray volatility) {
        return new HullWhiteOneFactorPiecewiseConstantParameters(this.meanReversion, volatility, this.volatilityTime);
    }

    public double getLastVolatility() {
        return this.volatility.get(this.volatility.size() - 1);
    }

    public HullWhiteOneFactorPiecewiseConstantParameters withLastVolatility(double volatility) {
        double[] volatilityArray = this.volatility.toArray();
        volatilityArray[volatilityArray.length - 1] = volatility;
        return new HullWhiteOneFactorPiecewiseConstantParameters(this.meanReversion, DoubleArray.copyOf((double[])volatilityArray), this.volatilityTime);
    }

    public HullWhiteOneFactorPiecewiseConstantParameters withVolatilityAdded(double volatility, double volatilityTime) {
        double[] volatilityArray = this.volatility.toArray();
        double[] volatilityTimeArray = this.volatilityTime.toArray();
        ArgChecker.isTrue((volatilityTime > volatilityTimeArray[volatilityTimeArray.length - 2] ? 1 : 0) != 0, (String)"volatility times should be increasing");
        double[] newVolatilityArray = new double[volatilityArray.length + 1];
        double[] newVolatilityTimeArray = new double[volatilityTimeArray.length + 1];
        System.arraycopy(volatilityArray, 0, newVolatilityArray, 0, volatilityArray.length);
        System.arraycopy(volatilityTimeArray, 0, newVolatilityTimeArray, 0, volatilityTimeArray.length - 1);
        newVolatilityArray[volatilityArray.length] = volatility;
        newVolatilityTimeArray[volatilityTimeArray.length - 1] = volatilityTime;
        newVolatilityTimeArray[volatilityTimeArray.length] = 1000.0;
        return new HullWhiteOneFactorPiecewiseConstantParameters(this.meanReversion, DoubleArray.copyOf((double[])newVolatilityArray), DoubleArray.copyOf((double[])newVolatilityTimeArray));
    }

    public static TypedMetaBean<HullWhiteOneFactorPiecewiseConstantParameters> meta() {
        return META_BEAN;
    }

    private HullWhiteOneFactorPiecewiseConstantParameters(double meanReversion, DoubleArray volatility, DoubleArray volatilityTime) {
        JodaBeanUtils.notNull((Object)meanReversion, (String)"meanReversion");
        JodaBeanUtils.notNull((Object)volatility, (String)"volatility");
        JodaBeanUtils.notNull((Object)volatilityTime, (String)"volatilityTime");
        this.meanReversion = meanReversion;
        this.volatility = volatility;
        this.volatilityTime = volatilityTime;
        this.validate();
    }

    public TypedMetaBean<HullWhiteOneFactorPiecewiseConstantParameters> metaBean() {
        return META_BEAN;
    }

    public double getMeanReversion() {
        return this.meanReversion;
    }

    public DoubleArray getVolatility() {
        return this.volatility;
    }

    public DoubleArray getVolatilityTime() {
        return this.volatilityTime;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            HullWhiteOneFactorPiecewiseConstantParameters other = (HullWhiteOneFactorPiecewiseConstantParameters)obj;
            return JodaBeanUtils.equal((double)this.meanReversion, (double)other.meanReversion) && JodaBeanUtils.equal((Object)this.volatility, (Object)other.volatility) && JodaBeanUtils.equal((Object)this.volatilityTime, (Object)other.volatilityTime);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.meanReversion);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.volatility);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.volatilityTime);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("HullWhiteOneFactorPiecewiseConstantParameters{");
        buf.append("meanReversion").append('=').append(JodaBeanUtils.toString((Object)this.meanReversion)).append(',').append(' ');
        buf.append("volatility").append('=').append(JodaBeanUtils.toString((Object)this.volatility)).append(',').append(' ');
        buf.append("volatilityTime").append('=').append(JodaBeanUtils.toString((Object)this.volatilityTime));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

