/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.model;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.pricer.impl.rate.model.HullWhiteOneFactorPiecewiseConstantInterestRateModel;
import com.opengamma.strata.pricer.model.HullWhiteOneFactorPiecewiseConstantParameters;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class HullWhiteOneFactorPiecewiseConstantParametersProvider
implements ImmutableBean,
Serializable {
    private static final HullWhiteOneFactorPiecewiseConstantInterestRateModel MODEL = HullWhiteOneFactorPiecewiseConstantInterestRateModel.DEFAULT;
    @PropertyDefinition(validate="notNull")
    private final HullWhiteOneFactorPiecewiseConstantParameters parameters;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final ZonedDateTime valuationDateTime;
    private static final long serialVersionUID = 1L;

    public static HullWhiteOneFactorPiecewiseConstantParametersProvider of(HullWhiteOneFactorPiecewiseConstantParameters parameters, DayCount dayCount, ZonedDateTime valuationDateTime) {
        return new HullWhiteOneFactorPiecewiseConstantParametersProvider(parameters, dayCount, valuationDateTime);
    }

    public static HullWhiteOneFactorPiecewiseConstantParametersProvider of(HullWhiteOneFactorPiecewiseConstantParameters parameters, DayCount dayCount, LocalDate valuationDate, LocalTime valuationTime, ZoneId valuationZone) {
        return HullWhiteOneFactorPiecewiseConstantParametersProvider.of(parameters, dayCount, valuationDate.atTime(valuationTime).atZone(valuationZone));
    }

    public double futuresConvexityFactor(LocalDate referenceDate, LocalDate startDate, LocalDate endDate) {
        double referenceTime = this.relativeTime(referenceDate);
        double startTime = this.relativeTime(startDate);
        double endTime = this.relativeTime(endDate);
        return MODEL.futuresConvexityFactor(this.parameters, referenceTime, startTime, endTime);
    }

    public ValueDerivatives futuresConvexityFactorAdjoint(LocalDate referenceDate, LocalDate startDate, LocalDate endDate) {
        double referenceTime = this.relativeTime(referenceDate);
        double startTime = this.relativeTime(startDate);
        double endTime = this.relativeTime(endDate);
        return MODEL.futuresConvexityFactorAdjoint(this.parameters, referenceTime, startTime, endTime);
    }

    public double relativeTime(LocalDate date) {
        ArgChecker.notNull((Object)date, (String)"date");
        LocalDate valuationDate = this.valuationDateTime.toLocalDate();
        boolean timeIsNegative = valuationDate.isAfter(date);
        if (timeIsNegative) {
            return -this.dayCount.yearFraction(date, valuationDate);
        }
        return this.dayCount.yearFraction(valuationDate, date);
    }

    public double alpha(LocalDate startDate, LocalDate endDate, LocalDate numeraireDate, LocalDate maturityDate) {
        double startTime = this.relativeTime(startDate);
        double endTime = this.relativeTime(endDate);
        double numeraireTime = this.relativeTime(numeraireDate);
        double maturityTime = this.relativeTime(maturityDate);
        return MODEL.alpha(this.parameters, startTime, endTime, numeraireTime, maturityTime);
    }

    public ValueDerivatives alphaAdjoint(LocalDate startDate, LocalDate endDate, LocalDate numeraireDate, LocalDate maturityDate) {
        double startTime = this.relativeTime(startDate);
        double endTime = this.relativeTime(endDate);
        double numeraireTime = this.relativeTime(numeraireDate);
        double maturityTime = this.relativeTime(maturityDate);
        return MODEL.alphaAdjoint(this.parameters, startTime, endTime, numeraireTime, maturityTime);
    }

    public HullWhiteOneFactorPiecewiseConstantInterestRateModel getModel() {
        return MODEL;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private HullWhiteOneFactorPiecewiseConstantParametersProvider(HullWhiteOneFactorPiecewiseConstantParameters parameters, DayCount dayCount, ZonedDateTime valuationDateTime) {
        JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        this.parameters = parameters;
        this.dayCount = dayCount;
        this.valuationDateTime = valuationDateTime;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public HullWhiteOneFactorPiecewiseConstantParameters getParameters() {
        return this.parameters;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            HullWhiteOneFactorPiecewiseConstantParametersProvider other = (HullWhiteOneFactorPiecewiseConstantParametersProvider)obj;
            return JodaBeanUtils.equal((Object)this.parameters, (Object)other.parameters) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.parameters);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("HullWhiteOneFactorPiecewiseConstantParametersProvider{");
        buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<HullWhiteOneFactorPiecewiseConstantParametersProvider> {
        private HullWhiteOneFactorPiecewiseConstantParameters parameters;
        private DayCount dayCount;
        private ZonedDateTime valuationDateTime;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 458736106: {
                    return this.parameters;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 458736106: {
                    this.parameters = (HullWhiteOneFactorPiecewiseConstantParameters)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public HullWhiteOneFactorPiecewiseConstantParametersProvider build() {
            return new HullWhiteOneFactorPiecewiseConstantParametersProvider(this.parameters, this.dayCount, this.valuationDateTime);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("HullWhiteOneFactorPiecewiseConstantParametersProvider.Builder{");
            buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<HullWhiteOneFactorPiecewiseConstantParameters> parameters = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameters", HullWhiteOneFactorPiecewiseConstantParametersProvider.class, HullWhiteOneFactorPiecewiseConstantParameters.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", HullWhiteOneFactorPiecewiseConstantParametersProvider.class, DayCount.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", HullWhiteOneFactorPiecewiseConstantParametersProvider.class, ZonedDateTime.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"parameters", "dayCount", "valuationDateTime"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 458736106: {
                    return this.parameters;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends HullWhiteOneFactorPiecewiseConstantParametersProvider> builder() {
            return new Builder();
        }

        public Class<? extends HullWhiteOneFactorPiecewiseConstantParametersProvider> beanType() {
            return HullWhiteOneFactorPiecewiseConstantParametersProvider.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<HullWhiteOneFactorPiecewiseConstantParameters> parameters() {
            return this.parameters;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 458736106: {
                    return ((HullWhiteOneFactorPiecewiseConstantParametersProvider)bean).getParameters();
                }
                case 1905311443: {
                    return ((HullWhiteOneFactorPiecewiseConstantParametersProvider)bean).getDayCount();
                }
                case -949589828: {
                    return ((HullWhiteOneFactorPiecewiseConstantParametersProvider)bean).getValuationDateTime();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

